/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.taglib.ContextTag;
import java.util.HashMap;
import java.util.Iterator;

public abstract class IteratingContextTag
extends ContextTag {
    protected final int INVALID_VALUE = -99;
    private int tempPageSize = -99;

    public void setPagesize(String size) {
        try {
            this.tempPageSize = Integer.parseInt(size);
        }
        catch (NumberFormatException nfe) {
            this.unlockSessionContext();
            throw nfe;
        }
    }

    public int getPagesize() {
        return this.tempPageSize;
    }

    protected abstract String getPageName();

    protected Page getActivePage() {
        return this.sessionContext.getPage(this.getPageName());
    }

    public String getElementValueBaseName() {
        return null;
    }

    public void activateSubPages(int idx, Page mc) throws ExceptionContainer {
        HashMap subPages = mc.getSubPages(idx);
        if (subPages == null) {
            return;
        }
        Iterator it = subPages.keySet().iterator();
        while (it.hasNext()) {
            String pageName = (String)it.next();
            Page subpage = (Page)subPages.get(pageName);
            this.sessionContext.setPage(pageName, subpage);
        }
    }

    public abstract int getCurrentIndex();

    public IteratingContextTag getEnclosingContext() {
        String base = this.getBase();
        if (base == null) {
            return null;
        }
        ContextTag ct = ContextTag.lookup(this);
        while (ct != null) {
            if (ct instanceof IteratingContextTag && base.equals(((IteratingContextTag)ct).getPageName())) {
                return (IteratingContextTag)ct;
            }
            ct = ContextTag.lookup(ct);
        }
        return null;
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("pagesize", Integer.toString(this.getPagesize()));
        this.traceInfo.addAttribute("pagename", this.getPageName());
        if (this.getActivePage() != null) {
            this.traceInfo.addAttribute("pageStartElementNo", Integer.toString(this.getActivePage().getPageStartElementNo() + 1));
            this.traceInfo.addAttribute("pageCapacity", Integer.toString(this.getActivePage().getPageCapacity()));
        }
        super.endDumpDiagnosis();
    }
}

