/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.JspTag;
import com.softwareag.xtools.xapplication.jsp.taglib.ContextTag;
import com.softwareag.xtools.xapplication.jsp.taglib.DisplayTag;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import java.io.IOException;
import javax.servlet.jsp.tagext.BodyContent;

public abstract class FieldTag
extends JspTag {
    protected String select = null;
    protected boolean rawContent = false;
    protected String fieldValue;
    private ContextTag contextTag;
    private boolean callAfterBody;

    public void setSelect(String select) {
        this.select = select;
    }

    public void setRawcontent(String parm) {
        this.rawContent = parm.equalsIgnoreCase("true");
    }

    public int doStartTagCore() throws ExceptionContainer {
        BodyContent body;
        this.contextTag = ContextTag.lookup(this);
        if (this.contextTag == null) {
            throw new ExceptionContainer("152");
        }
        this.callAfterBody = true;
        if (this.contextTag.isEmpty()) {
            this.callAfterBody = false;
            return 0;
        }
        boolean escapeValue = false;
        if (this instanceof DisplayTag && ((body = this.getBodyContent()) == null || body.getString().length() == 0)) {
            escapeValue = true;
        }
        try {
            this.fieldValue = this.contextTag.getElementValue(this.select, this.rawContent, escapeValue);
        }
        catch (BusinessDocumentStateException e) {
            throw new ExceptionContainer("204", e);
        }
        String temp = this.contextTag.getElementName(this.select);
        if (temp != null) {
            this.setSelect(temp);
        }
        return 2;
    }

    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        this.callAfterBody = false;
        this.processField();
        return 0;
    }

    public abstract void processField() throws ExceptionContainer, IOException;

    protected void handleInputControls(HtmlElement htmlElement) {
        if (htmlElement.getName().equals("input")) {
            String s = htmlElement.getAttribute("type");
            if (s.equals("checkbox") || s.equals("radio")) {
                htmlElement.setAttribute("name", this.select);
                if (htmlElement.getAttribute("value").equals(this.fieldValue)) {
                    htmlElement.setAttribute("checked", "true");
                } else {
                    htmlElement.setAttribute("checked", null);
                }
            } else {
                htmlElement.setAttribute("name", this.select);
                htmlElement.setAttribute("value", this.fieldValue);
            }
        }
        if (htmlElement.getName().equals("textarea")) {
            htmlElement.setAttribute("name", this.select);
            htmlElement.addContent(this.fieldValue);
        }
        if (htmlElement.getName().equals("select")) {
            htmlElement.setAttribute("name", this.select);
            htmlElement.setSelectedOption(this.fieldValue);
        }
    }

    public int doEndTagCore() throws ExceptionContainer, IOException {
        if (this.callAfterBody) {
            try {
                this.doAfterBodyCore();
            }
            catch (ExceptionContainer e) {
                System.err.println(e);
            }
        }
        return 6;
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("select", this.select);
        this.traceInfo.addAttribute("fieldValue", this.fieldValue);
        this.traceInfo.addAttribute("rawcontent", new Boolean(this.rawContent).toString());
        super.endDumpDiagnosis();
    }
}

