/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.taglib.CommandTag;
import com.softwareag.xtools.xapplication.jsp.taglib.ContextTag;
import com.softwareag.xtools.xapplication.jsp.taglib.LoopTag;
import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import java.io.IOException;
import javax.servlet.jsp.tagext.BodyContent;

public class ElementActionTag
extends CommandTag {
    private String type = null;
    private String base = null;
    private String form = null;
    private StringBuffer parmBuffer = null;

    public void setType(String type) {
        this.type = type;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getBase() {
        return this.base;
    }

    public void processAction() throws ExceptionContainer, IOException {
        LoopTag enclosingLoopTag = this.getEnclosingLoopTag();
        if (enclosingLoopTag == null && this.getBase() == null) {
            throw new ExceptionContainer("120", this.type);
        }
        BusinessNodePage np = this.getNodePage(enclosingLoopTag);
        if (np == null) {
            throw new ExceptionContainer("121", new Object[]{this.getBase(), this.type});
        }
        BodyContent body = this.getBodyContent();
        String bodyContentStr = body.getString();
        if (bodyContentStr.length() == 0) {
            throw new ExceptionContainer("122", this.type);
        }
        if (!(this.type.equals("insert") || this.type.equals("remove") || this.type.equals("select"))) {
            throw new ExceptionContainer("123", this.type);
        }
        if (this.type.equals("remove") && !np.allowsRemoving()) {
            body.clearBody();
            return;
        }
        Arguments args = this.createArguments(enclosingLoopTag, np);
        this.createBodyContent(this.form, "elementaction", this.type, args);
        body.clearBody();
    }

    private Arguments createArguments(LoopTag enclosingLoopTag, BusinessNodePage np) throws ExceptionContainer {
        Arguments result = new Arguments();
        String docName = this.getDocumentName();
        if (docName != null) {
            result.add(":document", docName);
        }
        result.add(":elementaction", this.type + "(" + this.getPositionVector(enclosingLoopTag, np) + ")");
        return result;
    }

    private String getDocumentName() {
        return this.getDocument() != null ? this.getDocument() : this.contextTag.getDocument();
    }

    private String getPositionVector(LoopTag enclosingLoopTag, BusinessNodePage np) throws ExceptionContainer {
        return np.getPositionVector(0) + ";" + (enclosingLoopTag != null && enclosingLoopTag.getActivePage() == np ? enclosingLoopTag.getCurrentIndex() : this.getNodeIndex(np));
    }

    private BusinessNodePage getNodePage(LoopTag enclosingLoopTag) throws ExceptionContainer {
        if (enclosingLoopTag == null && this.getBase() == null) {
            throw new PreconditionViolation("parameter 'enclosingLoopTag' must not be null if base is null");
        }
        return enclosingLoopTag != null ? (BusinessNodePage)enclosingLoopTag.getActivePage() : (BusinessNodePage)this.sessionContext.getPage(this.getBase());
    }

    private LoopTag getEnclosingLoopTag() {
        ContextTag ct = ContextTag.lookup(this);
        String pageName = this.getBase();
        while (ct != null) {
            if (ct instanceof LoopTag && (pageName == null || pageName.equals(((LoopTag)ct).getActivePage().getPageName()))) break;
            ct = ContextTag.lookup(ct);
        }
        return (LoopTag)ct;
    }

    private int getNodeIndex(BusinessNodePage np) throws ExceptionContainer {
        if (this.type.equals("insert")) {
            return np.getLastNodeIndex() + 1;
        }
        BusinessNode selectedNode = np.getDocument().lookup(np.getPageName());
        int i = np.getPageCapacity() - 1;
        while (i >= 0) {
            if (np.get(i) == selectedNode) {
                return i;
            }
            --i;
        }
        throw new ExceptionContainer("158", new String[]{this.type, np.getPageName()});
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("type", this.type);
        this.traceInfo.addAttribute("base", this.base);
        this.traceInfo.addAttribute("form", this.form);
        super.endDumpDiagnosis();
    }
}

