/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.JspTag;
import com.softwareag.xtools.xapplication.jsp.XTag;
import com.softwareag.xtools.xapplication.jsp.taglib.BrowseTag;
import com.softwareag.xtools.xapplication.jsp.taglib.IteratingContextTag;
import com.softwareag.xtools.xapplication.jsp.taglib.LoopTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public abstract class ContextTag
extends JspTag {
    private String moduleId = null;
    private String documentName = null;
    private String baseName = null;
    private boolean contextEmpty;
    private static final String PREFIX = "$";
    private static final String ID = "$ID";
    private static final String POS = "$POS";
    private static final String COUNT = "$COUNT";
    private static final String SIZE = "$SIZE";

    public static ContextTag lookup(XTag tag) {
        tag = tag.getXParent();
        while (tag != null) {
            if (tag instanceof ContextTag) {
                return (ContextTag)tag;
            }
            tag = tag.getXParent();
        }
        return null;
    }

    public void setModule(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setDocument(String document) {
        this.documentName = document;
    }

    public void setBase(String base) {
        this.baseName = base;
    }

    protected String getDocument() {
        return this.documentName;
    }

    protected String getBase() {
        return this.baseName;
    }

    public String getElementValueBaseName() {
        return this.getBase();
    }

    public boolean isEmpty() {
        return this.contextEmpty;
    }

    public void setEmpty(boolean contextEmpty) {
        this.contextEmpty = contextEmpty;
    }

    public String getElementValue(String xPath, boolean rawContent, boolean escapeValue) {
        String fieldValue;
        block24: {
            BusinessNode node;
            fieldValue = null;
            BusinessDocument doc = this.sessionContext.getDocument(this.getDocument());
            if (doc == null) {
                if (xPath.equals(COUNT) || xPath.equals(SIZE)) {
                    return "0";
                }
                return "?document?";
            }
            if (xPath.startsWith(PREFIX)) {
                return this.getSpecialElementValue(xPath, doc);
            }
            String base = this.getElementValueBaseName();
            if (base != null) {
                node = doc.lookup(base);
                if (node == null) {
                    Page mc = this.sessionContext.getPage(base);
                    node = doc.lookup(base);
                    if (node == null) {
                        return "?base=" + base + "?";
                    }
                }
            } else {
                node = doc.getRoot();
                if (node == null) {
                    return "?root?";
                }
            }
            try {
                BusinessNode temp = node.getDescendant(xPath);
                if (temp == null) {
                    fieldValue = "?xpath returns null?";
                } else {
                    fieldValue = rawContent ? temp.toXML() : temp.getValue();
                    if (fieldValue == null) {
                        fieldValue = "?value=null?";
                    }
                }
            }
            catch (InvalidXPathException e) {
                if (doc.isWriteAble()) {
                    try {
                        node.touchDescendants(xPath);
                        fieldValue = rawContent ? node.toXML() : node.getDescendant(xPath).getValue();
                    }
                    catch (InvalidXPathException e2) {
                        return "?xpath=" + xPath + "?";
                    }
                    catch (BusinessDocumentStateException e2) {
                        System.err.println(e2);
                        break block24;
                    }
                }
                System.err.println("Addressing a non-existing field which might be optional in readonly state. If the path (" + xPath + ") is correct and the field is optional, you can ignore this warning.");
                fieldValue = "";
            }
            catch (BusinessDocumentStateException e) {
                fieldValue = "?dead document?";
            }
        }
        if (fieldValue == null) {
            fieldValue = "???";
        }
        if (rawContent) {
            if (fieldValue.startsWith("<")) {
                StringBuffer sb = new StringBuffer(fieldValue);
                sb.delete(0, fieldValue.indexOf(">") + 1);
                int i = sb.length() - 1;
                while (i > 0) {
                    if (sb.charAt(i) == '<') {
                        sb.delete(i, sb.length());
                        break;
                    }
                    --i;
                }
                fieldValue = sb.toString();
            }
            return fieldValue;
        }
        if (escapeValue) {
            fieldValue = Util.escapeElementText(fieldValue);
        }
        return fieldValue;
    }

    public boolean hasElement(String xPath) {
        BusinessNode baseNode;
        BusinessDocument doc = this.sessionContext.getDocument(this.getDocument());
        if (doc == null) {
            return false;
        }
        String base = this.getElementValueBaseName();
        BusinessNode businessNode = baseNode = base != null ? doc.lookup(base) : doc.getRoot();
        if (baseNode == null) {
            return false;
        }
        try {
            return baseNode.getDescendant(xPath) != null;
        }
        catch (InvalidXPathException e) {
            return false;
        }
    }

    public String getElementName(String xPath) {
        BusinessNode node;
        if (xPath.equals(ID)) {
            return null;
        }
        String fieldName = null;
        BusinessDocument doc = this.sessionContext.getDocument(this.getDocument());
        if (doc == null) {
            return null;
        }
        if (this.getElementValueBaseName() != null) {
            node = doc.lookup(this.getElementValueBaseName());
            if (node == null) {
                return null;
            }
        } else {
            if (this.getDocument() != null) {
                return "#" + this.getDocument() + "#" + xPath;
            }
            return xPath;
        }
        try {
            fieldName = node.getPath();
            if (fieldName.endsWith(xPath)) {
                if (this instanceof LoopTag && !xPath.equals(".")) {
                    System.err.println("***** Your bdm:loop tag addresses " + fieldName + " while your field tag addresses " + xPath + ". You should rather define a select=\".\" in the field tag (bdm:display, bdm:edit)");
                }
            } else {
                fieldName = fieldName + "/" + xPath;
            }
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            System.err.println("xpath=" + xPath);
            return null;
        }
        if (fieldName == null) {
            fieldName = xPath;
        }
        if (this.getDocument() != null) {
            fieldName = "#" + this.getDocument() + "#" + fieldName;
        }
        return fieldName;
    }

    protected String getBaseStruct() {
        String s;
        ContextTag ct = ContextTag.lookup(this);
        String returnValue = null;
        if (ct != null) {
            returnValue = ct.getBaseStruct();
        }
        if ((s = this.getThisBaseStruct()) != null) {
            returnValue = returnValue == null ? s : returnValue + "," + s;
        }
        return returnValue;
    }

    protected String getThisBaseStruct() {
        if (this.getBase() != null) {
            return "0,any,0";
        }
        return null;
    }

    public int doStartTagCore() throws ExceptionContainer {
        IteratingContextTag itTemp;
        this.contextEmpty = false;
        ContextTag ctTemp = ContextTag.lookup(this);
        if (ctTemp instanceof IteratingContextTag && (itTemp = (IteratingContextTag)ctTemp).isEmpty()) {
            return 0;
        }
        return 2;
    }

    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        BodyContent bc = this.getBodyContent();
        JspWriter enclosing = bc.getEnclosingWriter();
        if (this.requestContext.markHiddenForm()) {
            this.sessionContext.getArgumentsCodec().writeHiddenFields((Writer)enclosing);
        }
        bc.writeOut((Writer)enclosing);
        return 0;
    }

    private String getSpecialElementValue(String xPath, BusinessDocument doc) {
        if (xPath.equals(ID)) {
            if (doc.getState() == 4) {
                return "?dead document?";
            }
            if (doc.getId() == null) {
                return "?no $ID?";
            }
            return doc.getId();
        }
        if (xPath.equals(POS)) {
            if (this instanceof BrowseTag) {
                return Integer.toString(((BrowseTag)this).getCurrentDocIndex() + 1);
            }
            if (this instanceof LoopTag) {
                return Integer.toString(((LoopTag)this).getCurrentNodeIndex() + 1);
            }
            return "?no $POS?";
        }
        if (xPath.equals(COUNT) || xPath.equals(SIZE)) {
            Page page = null;
            String cursorName = "current";
            if (this.getDocument() != null) {
                cursorName = this.getDocument();
            }
            if (this.getBase() != null) {
                cursorName = this.getBase();
            }
            if ((page = this.sessionContext.getPage(cursorName)) == null) {
                System.err.println("Cursor name=" + cursorName + " addressed within page but cannot be found in application.");
                return "0";
            }
            try {
                boolean reread = xPath.equals(COUNT);
                int i = page.size(reread);
                return Integer.toString(i);
            }
            catch (UnsupportedOperationException e) {
                return "?n/a?";
            }
        }
        return "?unkown: " + xPath + "?";
    }

    protected void registerNodePage(String baseId, String targetName, BusinessNodePage np) {
        ContextTag ct = ContextTag.lookup(this);
        if (ct != null) {
            ct.registerNodePage(baseId, targetName, np);
        }
    }

    protected boolean appendPosition(StringBuffer sb) {
        ContextTag ct = ContextTag.lookup(this);
        if (ct != null) {
            return ct.appendPosition(sb);
        }
        return false;
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("moduleId", this.moduleId);
        this.traceInfo.addAttribute("document", this.getDocument());
        this.traceInfo.addAttribute("base", this.getBase());
        this.traceInfo.addAttribute("isEmpty", new Boolean(this.isEmpty()).toString());
        this.traceInfo.addAttribute("elementValueBaseName", this.getElementValueBaseName());
        super.endDumpDiagnosis();
    }
}

