/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentPage;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.taglib.IteratingContextTag;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.tagext.BodyContent;

public class BrowseTag
extends IteratingContextTag {
    private String targetDocument = null;
    private int docIndex;
    private BusinessDocumentPage currentPage;

    public void setTargetdocument(String targetDocument) {
        this.targetDocument = targetDocument;
    }

    public String getTargetDocument() {
        return this.targetDocument;
    }

    protected String getPageName() {
        if (this.getDocument() == null) {
            return "current";
        }
        return this.getDocument();
    }

    public int doStartTagCore() throws ExceptionContainer {
        try {
            int result = super.doStartTagCore();
            this.currentPage = (BusinessDocumentPage)this.getActivePage();
            if (this.currentPage != null && this.currentPage.containsDeadDocuments()) {
                this.currentPage.gotoPageStartingAt(this.currentPage.getPageStartElementNo() + 1);
            }
            if (result == 0 || this.currentPage == null || this.currentPage.get(0) == null) {
                return 0;
            }
            if (this.getPagesize() != -99 && this.currentPage.getPageCapacity() != this.getPagesize()) {
                try {
                    this.currentPage.setPageCapacity(this.getPagesize());
                }
                catch (StoreException e) {
                    throw new ExceptionContainer("134", e);
                }
            }
            this.docIndex = 0;
            this.sessionContext.setPage(this.currentPage.getPageName(), this.currentPage);
            this.sessionContext.map(this.currentPage.getPageName(), this.currentPage.get(this.docIndex));
            this.activateSubPages(this.docIndex, this.currentPage);
            return result;
        }
        catch (StoreException e) {
            e.printStackTrace();
            throw new ExceptionContainer("135", this.getPageName(), (Throwable)e);
        }
    }

    public void doInitBodyCore() {
    }

    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        BodyContent bc = this.getBodyContent();
        bc.writeOut((Writer)bc.getEnclosingWriter());
        bc.clearBody();
        ++this.docIndex;
        if (this.docIndex <= this.currentPage.getPageCapacity() - 1 && this.currentPage.get(this.docIndex) != null) {
            if (!this.currentPage.get(this.docIndex).isReadAble()) {
                throw new AssertionFailed("document at position " + this.docIndex + " must be readable");
            }
            this.sessionContext.setPage(this.currentPage.getPageName(), this.currentPage);
            this.sessionContext.map(this.currentPage.getPageName(), this.currentPage.get(this.docIndex));
            this.activateSubPages(this.docIndex, this.currentPage);
            return 2;
        }
        return 0;
    }

    public int getCurrentDocIndex() {
        BusinessDocumentPage dp = (BusinessDocumentPage)this.getActivePage();
        if (0 > this.docIndex || this.docIndex > dp.getPageCapacity() - 1) {
            throw new AssertionFailed("relative document index " + this.docIndex + " must be in range [0.." + dp.getPageCapacity() + ")");
        }
        int result = dp.getPageStartElementNo() + 1 + this.docIndex;
        if (result < 0) {
            throw new AssertionFailed("absolute document index " + result + " must be greater than Zero");
        }
        return result;
    }

    public int getCurrentIndex() {
        return this.docIndex;
    }

    public boolean isFirst() {
        return this.firstOnPage() && this.currentPage.getPageStartElementNo() == -1;
    }

    public boolean isLast() throws StoreException {
        return this.docIndex < this.currentPage.getPageCapacity() - 1 && this.currentPage.get(this.docIndex + 1) == null || this.docIndex >= this.currentPage.getPageCapacity() - 1 && !this.currentPage.hasNextPage();
    }

    public boolean firstOnPage() {
        return this.docIndex == 0;
    }

    public boolean lastOnPage() {
        return this.docIndex >= this.currentPage.getPageCapacity() - 1 || this.currentPage.get(this.docIndex + 1) == null;
    }

    public boolean atEvenPos() {
        BusinessDocumentPage dp = (BusinessDocumentPage)this.getActivePage();
        return (this.docIndex + dp.getPageStartElementNo() + 2) % 2 == 0;
    }

    public boolean atOddPos() {
        return !this.atEvenPos();
    }

    public boolean atEvenPosOnPage() {
        return (this.docIndex + 1) % 2 == 0;
    }

    public boolean atOddPosOnPage() {
        return !this.atEvenPosOnPage();
    }

    protected void registerNodePage(String baseId, String targetName, BusinessNodePage np) {
        if (baseId == null) {
            this.currentPage.addSubPage(this.docIndex, targetName, np);
        }
    }

    protected boolean appendPosition(StringBuffer sb) {
        boolean result = super.appendPosition(sb);
        if (result) {
            sb.append(',');
        }
        sb.append(this.getPageName());
        sb.append(',');
        sb.append(this.docIndex);
        return true;
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("targetDocument", this.getTargetDocument());
        super.endDumpDiagnosis();
    }
}

