/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class TraceInfo {
    private Element root;
    private Element currentContext;
    private Element pageContext;
    private Element parentKeeper;

    public TraceInfo() {
        this.currentContext = this.root = new Element("Session");
        this.pageContext = this.root;
    }

    public String toXML() {
        return Util.elementToString(this.root, "", false);
    }

    public String getSessionAsXML() {
        String result = Util.elementToString(this.root, "", false);
        return result;
    }

    public String getPageAsXML() {
        List list = this.root.getChildren();
        String result = list.size() > 0 ? Util.elementToString((Element)list.get(list.size() - 1), "", false) : Util.elementToString(this.root, "", false);
        return result;
    }

    public String clearContext() {
        this.currentContext = this.root = new Element("Session");
        this.pageContext = this.root;
        return "<message>Traced Informations are cleared.</message>";
    }

    public void startElement(String name) {
        Element context = new Element(name);
        this.currentContext.addContent(context);
        this.currentContext = context;
    }

    public void addElement(String name) {
        Element context = new Element(name);
        this.currentContext.addContent(context);
    }

    public void addElementWithInfo(String name, String info) {
        Element context = new Element(name);
        if (info != null) {
            context.addContent(info);
        } else {
            context.addContent("null");
        }
        this.currentContext.addContent(context);
    }

    public void addElementWithInfo(String name, String info, int pos) {
        List childrenOfContext = this.currentContext.getChildren();
        Element context = new Element(name);
        if (info != null) {
            context.addContent(info);
        } else {
            context.addContent("null");
        }
        childrenOfContext.add(pos, context);
    }

    public void addAttribute(String name, String info) {
        if (info != null) {
            this.currentContext.addAttribute(name, info);
        } else {
            this.currentContext.addAttribute(name, "null");
        }
    }

    public void endElement() {
        if (this.currentContext == this.root) {
            System.err.println(this.toXML());
            throw new PreconditionViolation("Error: Already on top level!");
        }
        this.currentContext = this.currentContext.getParent();
    }

    public void moveToChildElement(String name) {
        Element localChild = this.currentContext.getChild(name);
        if (localChild == null) {
            throw new PreconditionViolation("Current Context \"" + this.currentContext.getName() + "\" has no Child \"" + name + "\"!");
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add(this.currentContext.getName());
        parameterList.add(name);
        this.currentContext = this.currentContext.getChild(name);
    }
}

