/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentCursor;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentPage;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentWorkspace;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.businessdocument.QueryContainer;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.jsp.ApplicationContext;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.InvalidEmbeddedContentException;
import com.softwareag.xtools.xapplication.jsp.NavigationException;
import com.softwareag.xtools.xapplication.jsp.RequestContext;
import com.softwareag.xtools.xapplication.jsp.TraceInfo;
import com.softwareag.xtools.xapplication.jsp.util.ArgumentsCodec;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.input.SAXBuilder;

public class SessionContext {
    private boolean locked = false;
    private BusinessDocumentWorkspace businessDocumentWorkspace = null;
    private QueryContainer container = null;
    public static final String CURRENT_DOCUMENT = "current";
    private int pageSize = 10;
    private final HashMap modulePageTable = new HashMap();
    private static final int CURSOR_CACHE_MAX = 100;
    private Page[] pageCache = new Page[100];
    private int pageCacheIndex = -1;
    public String request = null;
    public String servletPath = null;
    private final ApplicationContext config;
    private TraceInfo traceInfo;
    private final SAXBuilder jdomBuilder;
    private final HtmlElement htmlElement = new HtmlElement();
    private final ArgumentsCodec argumentsCodec;

    public SessionContext(ApplicationContext config) throws ExceptionContainer {
        this(config, config.newWorkspace(), config.newArgumentsCodec());
        if (config == null) {
            throw new PreconditionViolation("parameter 'config' must not be null");
        }
        this.traceInfo = config.isDiagnosisOn() ? new TraceInfo() : null;
    }

    public SessionContext(ApplicationContext conf, BusinessDocumentWorkspace ws, ArgumentsCodec args) throws ExceptionContainer {
        this.config = conf;
        this.businessDocumentWorkspace = ws;
        this.jdomBuilder = new SAXBuilder();
        this.argumentsCodec = args;
    }

    public synchronized boolean lock() {
        if (!this.isLocked()) {
            this.locked = true;
            return true;
        }
        return false;
    }

    public synchronized void lock(long timeout) throws ExceptionContainer {
        if (this.lock()) {
            return;
        }
        long started = System.currentTimeMillis();
        long remaining = timeout;
        do {
            try {
                this.wait(remaining);
            }
            catch (InterruptedException e) {
                break;
            }
            if (!this.lock()) continue;
            return;
        } while ((remaining = timeout - (System.currentTimeMillis() - started)) > 0L);
        if (this.servletPath != null) {
            throw new ExceptionContainer("003", this.servletPath, (Throwable)new NavigationException());
        }
        throw new ExceptionContainer("003", new NavigationException());
    }

    public synchronized void unlock() {
        if (!this.isLocked()) {
            throw new AssertionFailed("SessionContext is not locked.");
        }
        this.locked = false;
        this.notifyAll();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public ArgumentsCodec getArgumentsCodec() {
        return this.argumentsCodec;
    }

    protected void setPagesize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    public BusinessDocumentWorkspace getWorkspace() {
        return this.businessDocumentWorkspace;
    }

    public BusinessDocument getDocument(String document) {
        if (this.getWorkspace() == null) {
            return null;
        }
        if (document == null) {
            document = CURRENT_DOCUMENT;
        }
        return this.getWorkspace().lookup(document);
    }

    public void map(String documentName, BusinessDocument document) {
        this.getWorkspace().map(documentName, document);
    }

    public String getDocumentId(String document) {
        if (this.getDocument(document) == null) {
            return null;
        }
        return this.getDocument(document).getDocumentId();
    }

    public void read(String documentName, String documentId) throws StoreException {
        if (documentName == null) {
            documentName = CURRENT_DOCUMENT;
        }
        this.getWorkspace().unmap(documentName);
        this.getWorkspace().read(documentName, documentId);
        this.clearPageCache();
    }

    public void create(String documentName, String schema) throws StoreException {
        if (documentName == null) {
            documentName = CURRENT_DOCUMENT;
        }
        this.getWorkspace().create(documentName, schema);
        this.clearPageCache();
    }

    public void delete(String document) throws StoreException, BusinessDocumentStateException {
        if (this.getDocument(document).getState() == 2) {
            this.getDocument(document).abandon();
        }
        if (this.getDocument(document).getState() != 3) {
            this.getDocument(document).delete();
        }
    }

    public void modify(String document) throws StoreException, BusinessDocumentStateException {
        if (this.getDocument(document).getState() == 3) {
            this.getDocument(document).abandon();
        }
        if (this.getDocument(document).getState() != 2) {
            this.getDocument(document).modify();
        }
    }

    public void commit(String document) throws StoreException, BusinessDocumentStateException {
        if (this.getDocument(document).getState() != 1 && this.getDocument(document).getState() != 4) {
            this.getDocument(document).commit();
        }
    }

    public void abandon(String document) throws StoreException, BusinessDocumentStateException {
        if (this.getDocument(document).getState() != 1 && this.getDocument(document).getState() != 4 && this.getDocument(document).getState() != 0) {
            this.getDocument(document).abandon();
        }
    }

    public void commitAll() throws StoreException {
        this.getWorkspace().commitAll();
    }

    public void abandonAll() throws StoreException {
        this.getWorkspace().abandonAll();
    }

    public void commitAll(String[] docList) throws StoreException, BusinessDocumentStateException {
        int counter = 0;
        int i = 0;
        while (i < docList.length) {
            if (this.getDocument(docList[i]) != null && this.getDocument(docList[i]).getState() != 1 && this.getDocument(docList[i]).getState() != 4) {
                ++counter;
            } else {
                docList[i] = null;
            }
            ++i;
        }
        if (counter == 0) {
            return;
        }
        if (counter == docList.length) {
            this.getWorkspace().commitAll(docList);
            return;
        }
        String[] tempDocList = new String[counter];
        int x = 0;
        int i2 = 0;
        while (i2 < docList.length) {
            if (docList[i2] != null) {
                tempDocList[x] = docList[i2];
                ++x;
            }
            ++i2;
        }
        this.getWorkspace().commitAll(tempDocList);
    }

    public void setQuery(RequestContext requestContext, String pageName, QueryContainer container) throws ExceptionContainer {
        if (this.getWorkspace() == null) {
            return;
        }
        if (pageName == null) {
            pageName = CURRENT_DOCUMENT;
        }
        this.getWorkspace().unmap(pageName);
        this.container = container;
        try {
            BusinessDocumentCursor cursor = (BusinessDocumentCursor)this.getWorkspace().query(pageName, container, this.getPageSize());
            BusinessDocumentPage dp = new BusinessDocumentPage(cursor, pageName, cursor.getPagesize());
            this.map(dp.getPageName(), dp.get(0));
            this.setPage(pageName, dp);
        }
        catch (StoreException e) {
            System.err.println("exception setting query:" + e);
            throw new ExceptionContainer("157", e);
        }
        if (pageName.startsWith("$$temp")) {
            return;
        }
    }

    public void setPage(String name, Page page) throws ExceptionContainer {
        Page temp = (Page)this.modulePageTable.get(name);
        if (temp != page) {
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (StoreException e) {
                    throw new ExceptionContainer("008", e);
                }
            }
            this.modulePageTable.put(name, page);
        }
    }

    public BusinessDocumentCursor getCursor(String name, QueryContainer qc) throws StoreException {
        if (name == null) {
            throw new PreconditionViolation("parameter 'name' must not be null");
        }
        if (qc == null) {
            throw new PreconditionViolation("parameter 'qc' must not be null");
        }
        return (BusinessDocumentCursor)this.businessDocumentWorkspace.query(name, qc);
    }

    public Page getPage(String name) {
        if (name == null) {
            return null;
        }
        Page mc = (Page)this.modulePageTable.get(name);
        return mc;
    }

    public Iterator pageNames() {
        return this.modulePageTable.keySet().iterator();
    }

    protected void removePage(String name) throws ExceptionContainer {
        Page page = this.getPage(name);
        if (page instanceof BusinessDocumentPage) {
            this.getWorkspace().unmap(name);
        }
        if (page != null) {
            try {
                page.close();
            }
            catch (StoreException e) {
                throw new ExceptionContainer("008", e);
            }
        }
        this.modulePageTable.remove(name);
    }

    public boolean inDiagnosisMode() {
        return this.config.isDiagnosisOn();
    }

    public HtmlElement initHtmlElement(String htmlString) throws IOException, ExceptionContainer {
        if (htmlString == null || htmlString.length() == 0) {
            throw new ExceptionContainer("004", new InvalidEmbeddedContentException("Content of X-Application jsp tag must be filled with something and is empty"));
        }
        HtmlElement template = this.config.getHtmlElementCache().parse(this.jdomBuilder, htmlString);
        this.htmlElement.set(template);
        return this.htmlElement;
    }

    public int registerPageInCache(Page page) {
        this.pageCacheIndex = this.pageCacheIndex >= 99 ? 0 : ++this.pageCacheIndex;
        this.pageCache[this.pageCacheIndex] = page;
        return this.pageCacheIndex;
    }

    public boolean activatePageFromCache(int i, String pageName) throws ExceptionContainer {
        if (i > 99) {
            return false;
        }
        Page page = this.pageCache[i];
        if (page == null) {
            return false;
        }
        if (!page.getPageName().equals(pageName)) {
            return false;
        }
        this.setPage(page.getPageName(), page);
        return true;
    }

    public void clearPageCache() {
        this.pageCache = new Page[100];
    }

    public void close() throws ExceptionContainer {
        try {
            int i = 0;
            while (i < 100) {
                if (this.pageCache[i] != null) {
                    this.pageCache[i].close();
                }
                ++i;
            }
            Iterator iter = this.modulePageTable.values().iterator();
            while (iter.hasNext()) {
                Page temp = (Page)iter.next();
                temp.close();
            }
            if (this.getWorkspace().getStore().getIteratorCount() > 0) {
                System.err.println("WARNING: unbinding session while there are still open cursors in the Tamino Store. Internal programming error. Potential object leak");
            }
        }
        catch (StoreException e) {
            throw new ExceptionContainer("008", e);
        }
    }

    public TraceInfo getTraceInfoObject() {
        return this.traceInfo;
    }
}

