/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.NavigationException;
import com.softwareag.xtools.xapplication.jsp.SessionContext;
import com.softwareag.xtools.xapplication.jsp.TraceInfo;
import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RequestContext {
    private final String diagnosis;
    private final String destination;
    private boolean hiddenForm = false;
    private final String requestURI;
    private final String headerURI;
    private final String docid;
    private final String basestruct;
    private final String document;
    private final String linkaction;
    private final String action;
    private final String usecursorindex;
    private final String usecursorname;
    private final String pos;
    private final String goto_;
    private final String elementaction;
    private final String baseindex;
    private final String setchoice;
    private final String base;
    private final String select;
    private final String extselect;
    private final String schema;
    private final String[] fieldnames;
    private final String[][] fields;
    private final String querydocument;
    private final String queryschema;
    private final String querysortname;
    private final String[] querysort;
    private final String[] querynames;
    private final String[][] query;

    public RequestContext() {
        this.diagnosis = null;
        this.destination = null;
        this.headerURI = this.requestURI = "http://localhost/foo.html";
        this.docid = null;
        this.basestruct = null;
        this.document = null;
        this.linkaction = null;
        this.action = null;
        this.usecursorindex = null;
        this.usecursorname = null;
        this.pos = null;
        this.goto_ = null;
        this.elementaction = null;
        this.baseindex = null;
        this.setchoice = null;
        this.base = null;
        this.select = null;
        this.extselect = null;
        this.schema = null;
        this.fieldnames = new String[0];
        this.fields = new String[0][];
        this.querydocument = null;
        this.queryschema = null;
        this.querysortname = null;
        this.querysort = new String[0];
        this.querynames = new String[0];
        this.query = new String[0][];
    }

    public static RequestContext forRequest(SessionContext sessionContext, HttpServletRequest request) throws ExceptionContainer {
        String requestURI = request.getRequestURI();
        String headerURI = "http://" + request.getHeader("Host") + request.getRequestURI();
        Arguments arguments = new Arguments();
        arguments.add((ServletRequest)request);
        RequestContext.requestPagesize2sessionPagesize(sessionContext, arguments);
        if (!sessionContext.getArgumentsCodec().decode(arguments)) {
            sessionContext.request = null;
            throw new ExceptionContainer("002", sessionContext.servletPath, (Throwable)new NavigationException());
        }
        return new RequestContext(requestURI, headerURI, arguments);
    }

    private static void requestPagesize2sessionPagesize(SessionContext sessionContext, Arguments arguments) throws ExceptionContainer {
        String pagesizeStr = arguments.eatNoneEmptyValue(":pagesize");
        if (pagesizeStr != null) {
            try {
                int pagesize = Integer.parseInt(pagesizeStr);
                sessionContext.setPagesize(pagesize);
            }
            catch (NumberFormatException e) {
                System.err.println("invalid page size - ignored: " + pagesizeStr);
            }
        }
    }

    private RequestContext(String requestURI, String headerURI, Arguments arguments) {
        this.diagnosis = arguments.getValue("diagnosis");
        this.destination = arguments.getValue("destination") == null ? "Browser" : arguments.getValue("destination");
        this.requestURI = requestURI;
        this.headerURI = headerURI;
        this.docid = arguments.eatNoneEmptyValue(":docid");
        this.basestruct = arguments.eatNoneEmptyValue(":basestruct");
        this.document = arguments.eatNoneEmptyValue(":document");
        this.linkaction = arguments.eatNoneEmptyValue(":linkaction");
        this.action = arguments.eatNoneEmptyValue(":action");
        this.usecursorindex = arguments.eatNoneEmptyValue(":usecursorindex");
        this.usecursorname = arguments.eatNoneEmptyValue(":usecursorname");
        this.pos = arguments.eatNoneEmptyValue(":pos");
        this.goto_ = RequestContext.convertGotoParam(arguments);
        this.elementaction = arguments.eatNoneEmptyValue(":elementaction");
        this.baseindex = arguments.eatNoneEmptyValue(":baseindex");
        this.setchoice = arguments.eatNoneEmptyValue(":setchoice");
        this.base = arguments.eatNoneEmptyValue(":base");
        this.select = arguments.eatNoneEmptyValue(":select");
        this.extselect = arguments.eatNoneEmptyValue(":extselect");
        this.schema = arguments.eatNoneEmptyValue(":schema");
        ArrayList fieldNameLst = new ArrayList();
        ArrayList fieldLst = new ArrayList();
        ArrayList querysortLst = new ArrayList();
        ArrayList querynamesLst = new ArrayList();
        ArrayList queryLst = new ArrayList();
        String[] strings = RequestContext.getGeneric(arguments, fieldNameLst, fieldLst, querysortLst, querynamesLst, queryLst);
        this.fieldnames = RequestContext.array(fieldNameLst);
        this.fields = RequestContext.array2(fieldLst);
        this.querydocument = strings[0];
        this.queryschema = strings[1];
        this.querysortname = strings[2];
        this.querysort = RequestContext.array(querysortLst);
        this.querynames = RequestContext.array(querynamesLst);
        this.query = RequestContext.array2(queryLst);
    }

    private static String[] getGeneric(Arguments arguments, List fieldNames, List fields, List querysort, List querynames, List query) {
        String querydocument = null;
        String queryschema = null;
        String querysortname = null;
        Object queryname = null;
        Iterator pos = arguments.getNames();
        while (pos.hasNext()) {
            String name = (String)pos.next();
            String lowerName = name.toLowerCase();
            String[] values = arguments.getValues(name);
            if (RequestContext.isField(name)) {
                fieldNames.add(name);
                fields.add(values);
                continue;
            }
            if (name.startsWith(":")) continue;
            if (lowerName.startsWith("querysort")) {
                querysortname = name;
                int i = 0;
                while (i < values.length) {
                    querysort.add(values[i]);
                    ++i;
                }
                continue;
            }
            if (lowerName.startsWith("queryschema")) {
                queryschema = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                continue;
            }
            if (lowerName.startsWith("querydocument")) {
                querydocument = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                continue;
            }
            if (lowerName.startsWith("query")) {
                querynames.add(name);
                query.add(values);
                continue;
            }
            System.err.println("request parameter ignored: " + name);
        }
        return new String[]{querydocument, queryschema, querysortname, queryname};
    }

    private static String[] array(List lst) {
        String[] ar = new String[lst.size()];
        lst.toArray(ar);
        return ar;
    }

    private static String[][] array2(List lst) {
        String[][] ar = new String[lst.size()][];
        lst.toArray((T[])ar);
        return ar;
    }

    public boolean hasFields() {
        return this.fields.length > 0;
    }

    public static boolean isField(String name) {
        return name.startsWith("/") || name.startsWith("#");
    }

    public void dump(TraceInfo traceInfo) throws ExceptionContainer {
        traceInfo.addElementWithInfo("URL", this.headerURI);
        traceInfo.startElement("Parameters");
        if (this.diagnosis != null) {
            this.dump(traceInfo, "diagnosis", this.diagnosis);
        }
        if (this.destination != null) {
            this.dump(traceInfo, "destination", this.destination);
        }
        if (this.docid != null) {
            this.dump(traceInfo, "docid", this.docid);
        }
        if (this.basestruct != null) {
            this.dump(traceInfo, "basestruct", this.basestruct);
        }
        if (this.document != null) {
            this.dump(traceInfo, "document", this.document);
        }
        if (this.linkaction != null) {
            this.dump(traceInfo, "linkaction", this.linkaction);
        }
        if (this.action != null) {
            this.dump(traceInfo, "action", this.action);
        }
        if (this.pos != null) {
            this.dump(traceInfo, "pos", this.pos);
        }
        traceInfo.endElement();
    }

    private void dump(TraceInfo traceInfo, String name, String value) throws ExceptionContainer {
        traceInfo.startElement("Parameter");
        traceInfo.addElementWithInfo("Name", name);
        traceInfo.addElementWithInfo("Value", value);
        traceInfo.endElement();
    }

    public boolean markHiddenForm() {
        if (!this.hiddenForm) {
            this.hiddenForm = true;
            return true;
        }
        return false;
    }

    private static String convertGotoParam(Arguments args) {
        Iterator it = args.getNames();
        String gotoExpr = null;
        while (it.hasNext() && gotoExpr == null) {
            String name = (String)it.next();
            if (!name.startsWith(":goto")) continue;
            gotoExpr = name;
        }
        if (gotoExpr == null) {
            return null;
        }
        if (!(gotoExpr.equals(":goto") || gotoExpr.startsWith(":goto(") && gotoExpr.endsWith(")"))) {
            throw new AssertionFailed("expected ':goto(<cursor name>)=<number>' , but got '" + gotoExpr + "'");
        }
        String value = args.getValue(gotoExpr);
        if (value == null) {
            return null;
        }
        return gotoExpr.length() <= 7 ? "," + value : gotoExpr.substring(6, gotoExpr.length() - 1) + "," + value;
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getHeaderURI() {
        return this.headerURI;
    }

    public String getDocid() {
        return this.docid;
    }

    public String getBasestruct() {
        return this.basestruct;
    }

    public String getDocument() {
        return this.document;
    }

    public String getLinkaction() {
        return this.linkaction;
    }

    public String getAction() {
        return this.action;
    }

    public String getUsecursorindex() {
        return this.usecursorindex;
    }

    public String getUsecursorname() {
        return this.usecursorname;
    }

    public String getPos() {
        return this.pos;
    }

    public String getGoto() {
        return this.goto_;
    }

    public String getElementaction() {
        return this.elementaction;
    }

    public String getBaseindex() {
        return this.baseindex;
    }

    public String getSetchoice() {
        return this.setchoice;
    }

    public String getBase() {
        return this.base;
    }

    public String getSelect() {
        return this.select;
    }

    public String getExtselect() {
        return this.extselect;
    }

    public String getSchema() {
        return this.schema;
    }

    public String[] getFieldnames() {
        return this.fieldnames;
    }

    public String[][] getFields() {
        return this.fields;
    }

    public String getQuerydocument() {
        return this.querydocument;
    }

    public String getQueryschema() {
        return this.queryschema;
    }

    public String getQuerysortname() {
        return this.querysortname;
    }

    public String[] getQuerysort() {
        return this.querysort;
    }

    public String[] getQuerynames() {
        return this.querynames;
    }

    public String[][] getQuery() {
        return this.query;
    }
}

