/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.jsp.ContextInitException;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.ExceptionDispatcher;
import com.softwareag.xtools.xapplication.jsp.RequestContext;
import com.softwareag.xtools.xapplication.jsp.ServletSessionContext;
import com.softwareag.xtools.xapplication.jsp.TraceInfo;
import com.softwareag.xtools.xapplication.jsp.XJspException;
import com.softwareag.xtools.xapplication.jsp.XTag;
import com.softwareag.xtools.xapplication.jsp.taglib.ModuleTag;
import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public abstract class JspTag
extends XTag
implements BodyTag {
    private PageContext pageContext;
    private Tag parent;
    protected TraceInfo traceInfo = null;

    public void setParent(Tag parent) {
        this.parent = parent;
        this.setXParent(parent);
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public final int doStartTag() throws XJspException {
        int result = 42;
        Throwable throwable = null;
        this.preProcessing();
        try {
            this.checkContext();
            this.traceInfo = this.sessionContext.getTraceInfoObject();
            String moduleTagSwitch = this.requestContext.getDiagnosis();
            String diagnosisDestination = this.requestContext.getDestination();
            if (null == moduleTagSwitch || !this.sessionContext.inDiagnosisMode()) {
                result = this.doStartTagCore();
                if (this.isToBeDumped()) {
                    this.startDumpDiagnosis();
                }
            } else {
                this.getDumpDiagnosis(moduleTagSwitch, diagnosisDestination);
                result = 0;
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        this.postProcessing(throwable);
        return result;
    }

    public final void doInitBody() throws XJspException {
        Throwable throwable = null;
        this.preProcessing();
        try {
            this.doInitBodyCore();
        }
        catch (Throwable e) {
            throwable = e;
        }
        this.postProcessing(throwable);
    }

    public final int doAfterBody() throws XJspException {
        int result = 42;
        Throwable throwable = null;
        this.preProcessing();
        try {
            result = this.doAfterBodyCore();
        }
        catch (Throwable e) {
            throwable = e;
        }
        this.postProcessing(throwable);
        return result;
    }

    public final int doEndTag() throws XJspException {
        int result = 42;
        Throwable throwable = null;
        this.preProcessing();
        try {
            result = this.doEndTagCore();
            if (this.isToBeDumped()) {
                this.endDumpDiagnosis();
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        this.postProcessing(throwable);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkContext() throws ContextInitException, ExceptionContainer {
        XTag xparent = this.getXParent();
        if (xparent == null) {
            if (!(this instanceof ModuleTag)) throw new ContextInitException((Throwable)((Object)new ExceptionContainer("100")));
            try {
                this.setSessionContext(ServletSessionContext.findSessionContext(this.pageContext));
            }
            catch (Throwable e) {
                throw new ContextInitException(e);
            }
            this.setRequestContext(RequestContext.forRequest(this.sessionContext, (HttpServletRequest)this.pageContext.getRequest()));
            this.initResponse();
        } else {
            this.setSessionContext(xparent.sessionContext);
            this.setRequestContext(xparent.requestContext);
        }
        if (this.sessionContext != null) return;
        throw new AssertionFailed("no session context");
    }

    public void closeSession() {
        ServletSessionContext.invalidateSessionContext(this.pageContext.getSession());
    }

    private void initResponse() {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        response.addHeader("Cache-Control", "private");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    private void preProcessing() {
        this.setOut(this.pageContext.getOut());
    }

    private void postProcessing(Throwable e) throws XJspException {
        if (e != null) {
            this.handleException(e);
        }
    }

    protected void unlockSessionContext() {
        this.sessionContext.unlock();
    }

    private void handleException(Throwable e) throws XJspException {
        if (e instanceof ContextInitException) {
            e = ((ContextInitException)e).getNested();
        } else {
            this.unlockSessionContext();
        }
        ExceptionDispatcher.rethrow(e);
    }

    protected void getDumpDiagnosis(String condition, String destination) throws IOException {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        response.reset();
        response.setStatus(200);
        if (this.getBrowserType().indexOf("MSIE 5") >= 0 || this.getBrowserType().indexOf("MSIE 6") >= 0 || destination.equalsIgnoreCase("browser")) {
            response.setContentType("text/xml; charset=UTF-8");
        }
        if (this.getBrowserType().toLowerCase().indexOf("netscape") >= 0 || destination.equalsIgnoreCase("file")) {
            response.setContentType("application/some_application_displaying_xml; charset=UTF-8");
        }
        JspWriter diagnosisOut = this.getOut();
        diagnosisOut.clear();
        diagnosisOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        String result = new String("<error message=\"You have used a wrong parameter of Diagnosis or Destination(optional). ");
        result = result + "Use following instead:\"> <parameter>Diagnosis<value_1>clear</value_1><value_2>page</value_2>";
        result = result + "<value_3>session</value_3></parameter><parameter>Destination<value_1>browser</value_1>";
        result = result + "<value_2>file</value_2></parameter></error>";
        if (condition.equalsIgnoreCase("clear")) {
            result = this.traceInfo.clearContext();
        }
        if (condition.equalsIgnoreCase("page")) {
            result = this.traceInfo.getPageAsXML();
        }
        if (condition.equalsIgnoreCase("session")) {
            result = this.traceInfo.getSessionAsXML();
        }
        diagnosisOut.println(result);
        diagnosisOut.close();
    }

    protected void startDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.startElement(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1));
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.endElement();
    }

    private String getBrowserType() {
        HttpServletRequest hsq = (HttpServletRequest)this.pageContext.getRequest();
        return hsq.getHeader("User-Agent");
    }

    private String getAcceptedCharset() {
        HttpServletRequest hsq = (HttpServletRequest)this.pageContext.getRequest();
        return hsq.getHeader("Accepted-Charset");
    }

    private String getAcceptedLanguage() {
        HttpServletRequest hsq = (HttpServletRequest)this.pageContext.getRequest();
        return hsq.getHeader("Accepted-Language");
    }

    private String getAcceptedEncoding() {
        HttpServletRequest hsq = (HttpServletRequest)this.pageContext.getRequest();
        return hsq.getHeader("Accepted-Encoding");
    }

    private String getContentLanguage() {
        HttpServletResponse hsr = (HttpServletResponse)this.pageContext.getResponse();
        if (hsr.getLocale() == null) {
            return null;
        }
        return hsr.getLocale().toString();
    }

    private String getContentEncoding() {
        HttpServletResponse hsr = (HttpServletResponse)this.pageContext.getResponse();
        if (hsr.getLocale() == null) {
            return null;
        }
        return hsr.getCharacterEncoding();
    }

    public boolean isToBeDumped() {
        String moduleTagSwitch = this.requestContext.getDiagnosis();
        return null == moduleTagSwitch && this.sessionContext.inDiagnosisMode();
    }

    protected void dumpServletContext() throws ExceptionContainer {
        this.traceInfo.startElement("ServletContext");
        this.traceInfo.addElementWithInfo("Browser", this.getBrowserType());
        this.traceInfo.addElementWithInfo("Accepted-Charset", this.getAcceptedCharset());
        this.traceInfo.addElementWithInfo("Accepted-Language", this.getAcceptedLanguage());
        this.traceInfo.addElementWithInfo("Accepted-Encoding", this.getAcceptedEncoding());
        this.traceInfo.addElementWithInfo("Content-Language", this.getContentLanguage());
        this.traceInfo.addElementWithInfo("Content-Encoding", this.getContentEncoding());
        this.requestContext.dump(this.traceInfo);
        this.traceInfo.endElement();
    }

    protected void createBodyContent(String form, String tag, String type, Arguments args) throws ExceptionContainer, IOException {
        BodyContent body = this.getBodyContent();
        String bodyContentStr = body.getString();
        HtmlElement htmlElement = this.sessionContext.initHtmlElement(bodyContentStr);
        if (htmlElement.getName().toLowerCase().equals("a")) {
            if (htmlElement.getAttribute("href") == null || htmlElement.getAttribute("href").length() == 0) {
                if (form == null || form.length() == 0) {
                    throw new ExceptionContainer("101", new Object[]{tag, type});
                }
                htmlElement.setAttribute("href", "javascript:" + this.sessionContext.getArgumentsCodec().defineJavaScript(args, form) + "document.forms['" + form + "'].submit();");
            } else if (htmlElement.getAttribute("href").toLowerCase().startsWith("javascript:")) {
                htmlElement.setAttribute("href", "javascript:" + this.sessionContext.getArgumentsCodec().defineJavaScript(args, form) + htmlElement.getAttribute("href").substring(11));
            } else {
                String linkChar = "?";
                if (htmlElement.getAttribute("href").indexOf("?") >= 0) {
                    linkChar = "&";
                }
                htmlElement.setAttribute("href", htmlElement.getAttribute("href") + linkChar + this.sessionContext.getArgumentsCodec().defineNormal(args));
            }
        } else if (htmlElement.getName().toLowerCase().equals("input")) {
            if (form == null || form.length() == 0) {
                throw new ExceptionContainer("102", new Object[]{tag, type});
            }
            htmlElement.setAttribute("onclick", this.sessionContext.getArgumentsCodec().defineJavaScript(args, form));
        } else {
            throw new ExceptionContainer("103", htmlElement.getName());
        }
        htmlElement.writeOut((Writer)body.getEnclosingWriter());
    }
}

