/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.jsp.ApplicationException;
import com.softwareag.xtools.xapplication.jsp.DesignException;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.MajorEnvironmentException;
import com.softwareag.xtools.xapplication.jsp.MinorEnvironmentException;
import com.softwareag.xtools.xapplication.jsp.UserException;
import com.softwareag.xtools.xapplication.jsp.XJspException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ExceptionDispatcher {
    private Element root;
    private ExceptionEntry[] entries;
    private static ExceptionDispatcher exceptionDispatcher = null;
    public static final String MALFORMED_XML = "1001";
    public static final String MISSING_ID_ATTRIBUTE = "1002";
    public static final String MISSING_TYPE_ATTRIBUTE = "1003";
    public static final String UNKOWN_TYPE = "1004";
    public static final String MISSING_MESSAGE_ELEMENT = "1005";
    public static final String MISSING_HELP_ELEMENT = "1006";
    private static final List types = Arrays.asList("UserException", "MinorEnvironmentException", "MajorEnvironmentException", "DesignException", "ApplicationException");
    private static final int USER_EXCEPTION = 0;
    private static final int MINOR_ENVIRONMENT_EXCEPTION = 1;
    private static final int MAJOR_ENVIRONMENT_EXCEPTION = 2;
    private static final int DESIGN_EXCEPTION = 3;
    private static final int APPLICATION_EXCEPTION = 4;
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$jsp$ExceptionDispatcher;

    private static ExceptionDispatcher get() throws ApplicationException {
        if (exceptionDispatcher == null) {
            System.err.println("loading exceptions.xml");
            InputStream src = (class$com$softwareag$xtools$xapplication$jsp$ExceptionDispatcher == null ? (class$com$softwareag$xtools$xapplication$jsp$ExceptionDispatcher = ExceptionDispatcher.class$("com.softwareag.xtools.xapplication.jsp.ExceptionDispatcher")) : class$com$softwareag$xtools$xapplication$jsp$ExceptionDispatcher).getResourceAsStream("exceptions.xml");
            exceptionDispatcher = new ExceptionDispatcher(src);
            System.err.println("done");
        }
        return exceptionDispatcher;
    }

    public static ExceptionDispatcher forStream(InputStream src) throws ApplicationException {
        return new ExceptionDispatcher(src);
    }

    private ExceptionDispatcher(InputStream src) throws ApplicationException {
        try {
            this.root = Util.inputToElement(src);
        }
        catch (JDOMException e) {
            ExceptionDispatcher.invalidExceptionsXml(MALFORMED_XML, "malformed XML", e);
        }
        ArrayList<ExceptionEntry> lst = new ArrayList<ExceptionEntry>();
        List children = this.root.getChildren();
        int max = children.size();
        int i = 0;
        while (i < max) {
            lst.add(ExceptionEntry.forElement(i, (Element)children.get(i)));
            ++i;
        }
        this.entries = new ExceptionEntry[lst.size()];
        lst.toArray(this.entries);
    }

    private static void invalidExceptionsXml(String id, int entryNo, String entryId, String problem) throws ApplicationException {
        ExceptionDispatcher.invalidExceptionsXml(id, "entry no " + entryNo + "(id=" + entryId + "):" + problem, null);
    }

    private static void invalidExceptionsXml(String id, String problem, Throwable e) throws ApplicationException {
        throw new ApplicationException(id, "invalid exceptions file: " + problem, e, "");
    }

    public static void rethrow(Throwable e) throws XJspException {
        if (e instanceof ExceptionContainer) {
            throw ExceptionDispatcher.get().dispatch((ExceptionContainer)((Object)e));
        }
        if (e instanceof IOException) {
            throw ExceptionDispatcher.get().dispatch(new ExceptionContainer("997", e));
        }
        if (e instanceof RuntimeException || e instanceof Error) {
            throw ExceptionDispatcher.get().dispatch(new ExceptionContainer("999", e));
        }
        throw ExceptionDispatcher.get().dispatch(new ExceptionContainer("998", e));
    }

    private XJspException dispatch(ExceptionContainer exception) {
        String id = exception.getId();
        ExceptionEntry entry = this.lookup(id);
        if (entry == null) {
            return new ApplicationException("1000", "Exception not defined !", (Throwable)((Object)exception), "");
        }
        String msg = id + ": " + MessageFormat.format(entry.getMessage(), exception.getParameters());
        String help = entry.getHelp();
        switch (entry.getType()) {
            case 0: {
                return new UserException(id, msg, exception.getNestedException(), help);
            }
            case 1: {
                return new MinorEnvironmentException(id, msg, exception.getNestedException(), help);
            }
            case 2: {
                return new MajorEnvironmentException(id, msg, exception.getNestedException(), help);
            }
            case 3: {
                return new DesignException(id, msg, exception.getNestedException(), help);
            }
            case 4: {
                return new ApplicationException(id, msg, exception.getNestedException(), help);
            }
        }
        return new ApplicationException("1000", "undefined exception type", new PreconditionViolation("Undefined Exception Type!"), "");
    }

    private ExceptionEntry lookup(String id) {
        int i = 0;
        while (i < this.entries.length) {
            ExceptionEntry entry = this.entries[i];
            if (entry.getId().equalsIgnoreCase(id)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private static int lookupType(String type) {
        return types.indexOf(type);
    }

    public String toXML() {
        return Util.elementToString(this.root, "", false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExceptionEntry {
        private String id;
        private int type;
        private String msg;
        private String help;

        private static ExceptionEntry forElement(int no, Element elem) throws ApplicationException {
            String help;
            String msg;
            int type;
            Attribute attr = elem.getAttribute("id");
            if (attr == null) {
                ExceptionDispatcher.invalidExceptionsXml(ExceptionDispatcher.MISSING_ID_ATTRIBUTE, no, "?", "missing 'id' attribute");
            }
            String id = attr.getValue();
            attr = elem.getAttribute("type");
            if (attr == null) {
                ExceptionDispatcher.invalidExceptionsXml(ExceptionDispatcher.MISSING_TYPE_ATTRIBUTE, no, id, "missing 'type' attribute");
            }
            if ((type = ExceptionDispatcher.lookupType(attr.getValue())) == -1) {
                ExceptionDispatcher.invalidExceptionsXml(ExceptionDispatcher.UNKOWN_TYPE, no, id, "unkown type '" + attr.getValue() + "'");
            }
            if ((msg = elem.getChildTextTrim("message")) == null) {
                ExceptionDispatcher.invalidExceptionsXml(ExceptionDispatcher.MISSING_MESSAGE_ELEMENT, no, id, "missing 'message' element");
            }
            if ((help = elem.getChildTextTrim("help")) == null) {
                ExceptionDispatcher.invalidExceptionsXml(ExceptionDispatcher.MISSING_HELP_ELEMENT, no, id, "missing 'help' element");
            }
            return new ExceptionEntry(id, type, msg, help);
        }

        private ExceptionEntry(String id, int type, String msg, String help) {
            if (id == null) {
                throw new PreconditionViolation("missing id");
            }
            if (msg == null) {
                throw new PreconditionViolation("missing message");
            }
            if (help == null) {
                throw new PreconditionViolation("missing help");
            }
            this.id = id;
            this.type = type;
            this.msg = msg;
            this.help = help;
        }

        private String getId() {
            return this.id;
        }

        private int getType() {
            return this.type;
        }

        private String getMessage() {
            return this.msg;
        }

        private String getHelp() {
            return this.help;
        }
    }
}

