/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentWorkspace;
import com.softwareag.xtools.xapplication.businessdocument.SchemaCache;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.util.ArgumentsCodec;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElementCache;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.util.ArrayList;
import javax.servlet.ServletContext;

public class ApplicationContext {
    private final boolean CODED;
    private final String URL;
    private final String userId;
    private final String password;
    private final String[] doctypes;
    private final String[] collections;
    private final boolean diagnosis;
    private final SchemaCache schemaCache;
    private final HtmlElementCache htmlElementCache;

    public ApplicationContext(boolean CODED, String URL2, String userId, String password, String[] doctypes, String[] collections, boolean diagnosis) throws ExceptionContainer {
        this.CODED = CODED;
        this.URL = URL2;
        this.userId = userId;
        this.password = password;
        this.doctypes = doctypes;
        this.collections = collections;
        this.diagnosis = diagnosis;
        this.schemaCache = new SchemaCache(this.newStore());
        this.htmlElementCache = new HtmlElementCache();
    }

    public static ApplicationContext forServlet(ServletContext context) throws ExceptionContainer {
        String[] collections;
        boolean CODED = ApplicationContext.readBoolean(context, "CODED", false, true);
        String URL2 = context.getInitParameter("TAMINO_URL");
        if (URL2 == null) {
            throw new ExceptionContainer("011");
        }
        String userId = context.getInitParameter("USER_ID");
        String password = context.getInitParameter("PASSWORD");
        if (userId == null && password != null) {
            throw new ExceptionContainer("012");
        }
        if (userId != null && password == null) {
            throw new ExceptionContainer("013");
        }
        String[] doctypes = ApplicationContext.readArray(context, "TAMINO_DOCTYPE");
        if (doctypes.length != (collections = ApplicationContext.readArray(context, "TAMINO_COLLECTION")).length) {
            throw new ExceptionContainer("014");
        }
        boolean diagnosis = ApplicationContext.readBoolean(context, "DIAGNOSIS", false, false);
        return new ApplicationContext(CODED, URL2, userId, password, doctypes, collections, diagnosis);
    }

    private static boolean readBoolean(ServletContext context, String name, boolean required, boolean deflt) throws ExceptionContainer {
        String value = context.getInitParameter(name);
        if (value == null) {
            if (required) {
                throw new ExceptionContainer("015", name);
            }
            return deflt;
        }
        if (value.equals("yes") || value.equals("true")) {
            return true;
        }
        if (value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new ExceptionContainer("016", new Object[]{name, value});
    }

    private static String[] readArray(ServletContext context, String name) {
        String value;
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while ((value = context.getInitParameter(name + i)) != null) {
            list.add(value);
            ++i;
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public BusinessDocumentWorkspace newWorkspace() throws ExceptionContainer {
        return new BusinessDocumentWorkspace(this.newStore(), this.schemaCache);
    }

    private TaminoStore newStore() throws ExceptionContainer {
        TaminoStore store;
        try {
            store = new TaminoStore(this.URL, this.userId, this.password);
        }
        catch (StoreException e) {
            throw new ExceptionContainer("017", e);
        }
        int i = 0;
        while (i < this.doctypes.length) {
            store.registerDoctypeCollection(this.doctypes[i], this.collections[i]);
            ++i;
        }
        return store;
    }

    public ArgumentsCodec newArgumentsCodec() {
        return new ArgumentsCodec(this.CODED);
    }

    public boolean isDiagnosisOn() {
        return this.diagnosis;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("url       = " + this.URL + "\n" + "userId    = " + this.userId + "\n" + "password  = " + this.password + "\n" + "coded     = " + this.CODED + "\n" + "diagnosis = " + this.diagnosis + "\n");
        int i = 0;
        while (i < this.doctypes.length) {
            buffer.append(i + 1);
            buffer.append(". doctype/collection: ");
            buffer.append(this.doctypes[i]);
            buffer.append("\t-> ");
            buffer.append(this.collections[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public HtmlElementCache getHtmlElementCache() {
        return this.htmlElementCache;
    }
}

