/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.ConfigContainer;
import com.softwareag.xtools.xapplication.generator.Log;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslParser {
    private ConfigContainer configContainer;
    private Log log;

    public XslParser(ConfigContainer configContainer) {
        this.configContainer = configContainer;
        this.log = new Log(true, "[XslParser]");
    }

    private static String getArgValue(String arg) {
        return arg.substring(arg.lastIndexOf("=") + 1);
    }

    private static String getArgName(String arg) {
        return arg.substring(1, arg.lastIndexOf("="));
    }

    public void parse() throws Abort {
        String[][] pages = this.configContainer.getPages();
        int numberOfPages = pages.length;
        this.log.println("Processing stylesheets!");
        int i = 0;
        while (i < numberOfPages) {
            String resultPath = this.configContainer.getWebappDir() + File.separatorChar + pages[i][1];
            this.log.println("Processing " + pages[i][0] + ", " + pages[i][1]);
            Object outDoc = null;
            TransformerFactory tfactory = TransformerFactory.newInstance();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            Transformer transformer = null;
            try {
                transformer = tfactory.newTransformer(new StreamSource(new File(this.configContainer.getWebappDir() + File.separator + pages[i][0])));
            }
            catch (TransformerConfigurationException e) {
                throw new IllegalStateException("cannot configure transformer: " + e.getMessage());
            }
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("cannot configure parser: " + e.getMessage());
            }
            String structureFileName = this.configContainer.getWebappDir() + File.separator + "structure.xml";
            try {
                transformer.transform(new StreamSource(new File(structureFileName)), new StreamResult(new File(resultPath)));
            }
            catch (TransformerException e) {
                throw new Abort("error processing " + structureFileName + ":" + e.getMessage());
            }
            ++i;
        }
        this.log.println("...transformation finished!");
    }
}

