/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public class WebInf {
    private static final String USAGE = "X-Application WebInf\n  create a web application directory for a JSP X-Application.\nusage: webinf [options] dir url database collection doctype(s)\n  dir         Directory to be created. This directory must not exists.\n  url         Tamino URL. \n  collection  Where to define the doctype(s) in.\n  doctype(s)  List of comma-separated (comma-only,no spaces!) root element names;\n              do not use spaces between doctypes.\noptions:\n  coded=true|false    use coded parameters to link pages. Default is true. \n\nexample 1: webinf myapp/WEB-INF http://localhost/tamino/mydb mycoll root\nexample 2: webinf coded=true myapp/WEB-INF http://localhost/tamino/mydb mycoll root1,root2,root3\n";
    private static final String WEB_XML_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE web-app\n      PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN\"\n      \"http://java.sun.com/j2ee/dtds/web-app_2.2.dtd\">\n<web-app>\n  <context-param>\n    <param-name>DIAGNOSIS</param-name><param-value>false</param-value>\n  </context-param>\n  <context-param>\n    <param-name>CODED</param-name><param-value>{0}</param-value>\n  </context-param>\n  <context-param>\n    <param-name>TAMINO_URL</param-name><param-value>{1}</param-value>\n  </context-param>\n";
    private static final String WEB_XML_USER_PWD = "  <context-param>\n    <param-name>USER_ID</param-name><param-value>{0}</param-value>\n  </context-param>\n  <context-param>\n    <param-name>PASSWORD</param-name><param-value>{1}</param-value>\n  </context-param>\n";
    private static final String WEB_XML_MAP = "  <context-param>\n    <param-name>TAMINO_COLLECTION{0}</param-name><param-value>{1}</param-value>\n  </context-param>\n  <context-param>\n    <param-name>TAMINO_DOCTYPE{0}</param-name><param-value>{2}</param-value>\n  </context-param>\n";
    private static final String WEB_XML_TAIL = "  <taglib>\n    <taglib-uri>http://www.softwareag.com/xtools/xapplication</taglib-uri>\n    <taglib-location>/WEB-INF/jsp/xapplication.tld</taglib-location>\n  </taglib>\n</web-app>\n";
    private static final int BUF_SIZE = 16384;

    public static void main(String[] args) {
        String[] remaining;
        boolean coded;
        if (args.length < 4 || args.length > 5) {
            System.out.println("expected 4 or 5 arguments, got " + args.length);
            System.out.println(USAGE);
            return;
        }
        if (args[0].startsWith("coded=")) {
            String value = args[0].substring(args[0].indexOf(61) + 1);
            if (value.equals("true")) {
                coded = true;
            } else if (value.equals("false")) {
                coded = false;
            } else {
                System.out.println("invalid value for 'coded' option: " + value);
                return;
            }
            remaining = new String[4];
            System.arraycopy(args, 1, remaining, 0, 4);
        } else {
            remaining = args;
            coded = true;
        }
        try {
            WebInf.create(Util.locateHome(), coded, new File(remaining[0]), remaining[1], remaining[2], remaining[3], null, null);
        }
        catch (IOException e) {
            System.err.println("error: " + e.getMessage());
            System.err.println("aborted");
            System.exit(1);
        }
    }

    public static void create(File home, boolean coded, File dir, String taminoURL, String collection, String doctypeList, String userId, String password) throws IOException {
        File file;
        String[] debugJars = new String[]{"JavaTaminoAPI.jar", "instrumentation.jar"};
        String[] extJars = new String[]{"xerces.jar", "xalan.jar", "jdom.jar", "log4j.jar"};
        char S = File.separatorChar;
        if (!dir.mkdir()) {
            throw new IOException("unable to create directory: " + dir);
        }
        WebInf.createWebXml(new File(dir, "web.xml"), coded, taminoURL, collection, doctypeList, userId, password);
        WebInf.copy(new File(home, "WEB-INF"), new File(dir, "jsp"), false, false);
        WebInf.copy(new File(home, "lib" + S + "debug"), new File(dir, "lib"), true, false);
        int i = 0;
        while (i < extJars.length) {
            file = new File(home, "prerequisites" + S + "lib" + S + "ext" + S + extJars[i]);
            WebInf.copy(file, new File(dir, "lib" + S + extJars[i]), false, false);
            ++i;
        }
        i = 0;
        while (i < debugJars.length) {
            file = new File(home, "prerequisites" + S + "lib" + S + "debug" + S + debugJars[i]);
            WebInf.copy(file, new File(dir, "lib" + S + debugJars[i]), false, false);
            ++i;
        }
    }

    public static void createWebXml(File dest, boolean coded, String taminoURL, String collection, String doctypeList, String userId, String password) throws IOException {
        if (userId == null != (password == null)) {
            throw new PreconditionViolation("userid (=" + userId + ") without password (" + password + ") or vice versa is not allowed");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(MessageFormat.format(WEB_XML_HEAD, coded ? "true" : "false", taminoURL));
        String[] doctypes = Util.split(doctypeList, ',');
        int i = 0;
        while (i < doctypes.length) {
            buffer.append(MessageFormat.format(WEB_XML_MAP, "" + (i + 1), collection, doctypes[i]));
            ++i;
        }
        if (userId != null) {
            buffer.append(MessageFormat.format(WEB_XML_USER_PWD, userId, password));
        }
        buffer.append(WEB_XML_TAIL);
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                WebInf.copy(in, out);
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    public static void copy(File src, File dest, boolean overwrite, boolean recurseCVS) throws IOException {
        boolean createDest;
        if (!src.exists()) {
            throw new IOException("no such file or directory: " + src);
        }
        boolean bl = createDest = !dest.exists();
        if (!createDest && !overwrite) {
            throw new IOException("file or directory exists: " + dest);
        }
        if (src.isDirectory()) {
            if (createDest && !dest.mkdir()) {
                throw new IOException("cannot create directory: " + dest);
            }
            File[] all = src.listFiles();
            int i = 0;
            while (i < all.length) {
                if (!(!recurseCVS && "CVS".equals(all[i].getName()) || "generatorGui".equals(all[i].getName()))) {
                    WebInf.copy(all[i], new File(dest, all[i].getName()), overwrite, recurseCVS);
                }
                ++i;
            }
        } else {
            FileInputStream in = new FileInputStream(src);
            try {
                FileOutputStream out = new FileOutputStream(dest);
                try {
                    WebInf.copy(in, out);
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
    }

    public static void copy(InputStream src, OutputStream dest) throws IOException {
        int len;
        byte[] buffer = new byte[16384];
        while ((len = src.read(buffer)) != -1) {
            dest.write(buffer, 0, len);
        }
    }
}

