/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.common.schematools.converterfromDTD.Main;
import com.softwareag.xtools.common.schematools.schemamodel.api.definitionLevel.DefinitionNavigator;
import com.softwareag.xtools.common.schematools.schemamodel.api.definitionLevel.DefinitionSchemaNavigator;
import com.softwareag.xtools.common.schematools.schemamodel.api.definitionLevel.DefinitionSchemaTool;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEvent;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEventKeeper;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEventListener;
import com.softwareag.xtools.common.schematools.schemamodel.navigator.definitionLevel.DefinitionSchemaNavigatorImpl;
import com.softwareag.xtools.xapplication.businessdocument.DefineTSD;
import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.Log;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public class SchemaContainer {
    private File schemaFile;
    private PrintWriter userOutput;
    private Log debugLogger;
    private boolean isDTD;
    private boolean isFile;

    public SchemaContainer(String schemaString, PrintWriter userOutput) throws Abort {
        this(schemaString, userOutput, true);
    }

    public SchemaContainer(String schemaString, PrintWriter userOutput, boolean doLog) throws Abort {
        File tempfile;
        this.isFile = false;
        this.debugLogger = new Log(doLog, "[SchemaContainer]");
        this.userOutput = userOutput;
        try {
            tempfile = File.createTempFile("xapp", ".tmp");
            tempfile.deleteOnExit();
            FileWriter fileWriter = new FileWriter(tempfile);
            fileWriter.write(schemaString);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new Abort("Can not create temp file for DTD definition! " + e);
        }
        this.schemaFile = tempfile;
        this.isDTD = this.isDTD(schemaString);
    }

    public SchemaContainer(File schemaFile, PrintWriter userOutput) throws Abort {
        this(schemaFile, userOutput, true);
    }

    public SchemaContainer(File schemaFile, PrintWriter userOutput, boolean doLog) throws Abort {
        this.isFile = true;
        this.debugLogger = new Log(doLog, "[SchemaContainer]");
        this.userOutput = userOutput;
        this.schemaFile = schemaFile;
        this.isDTD = this.isDTD(schemaFile);
    }

    private boolean isDTD(String schemaString) {
        boolean found = false;
        boolean exit = false;
        StringTokenizer st = new StringTokenizer(schemaString);
        while (!exit && st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.equals("<!ELEMENT")) continue;
            found = true;
            exit = true;
        }
        this.debugLogger.println("Schema type isDTD: " + found);
        return found;
    }

    private boolean isDTD(File file) {
        boolean hasDTDEnding = file.getName().toUpperCase().endsWith(".DTD");
        String fileName = this.schemaFile.getName();
        if (fileName.indexOf(".") == -1) {
            this.debugLogger.println("WARNING: File " + file.getAbsolutePath() + " has no ending!");
            this.debugLogger.println("WARNING: => file is processed as if it was a TSD file!");
            this.userOutput.flush();
        }
        this.debugLogger.println("Schema type isDTD (determined by file ending): " + hasDTDEnding);
        return hasDTDEnding;
    }

    private DefinitionSchemaNavigator getInternalSchema(boolean withOutput) throws IOException, Abort {
        InputSource in;
        if (this.isDTD) {
            SchemaToolsEventKeeper listener = new SchemaToolsEventKeeper();
            DefinitionSchemaNavigator internalSchema = Main.convert((String)this.schemaFile.toURL().toString(), (SchemaToolsEventListener)listener);
            List eventList = listener.getEventList();
            if (withOutput) {
                Iterator i = eventList.iterator();
                while (i.hasNext()) {
                    this.userOutput.write(((SchemaToolsEvent)i.next()).toConsoleString());
                    this.userOutput.flush();
                }
            }
            return internalSchema;
        }
        try {
            in = new InputSource(new FileInputStream(this.schemaFile));
        }
        catch (FileNotFoundException e) {
            throw new Abort("Cannot locate file: " + this.schemaFile.getPath() + " " + e);
        }
        SchemaToolsEventKeeper keeper = new SchemaToolsEventKeeper();
        DefinitionSchemaNavigator internalSchema = DefinitionSchemaNavigatorImpl.createDefinitionSchemaNavigator((InputSource)in, (SchemaToolsEventListener)keeper);
        List eventList = keeper.getEventList();
        if (withOutput) {
            Iterator i = eventList.iterator();
            while (i.hasNext()) {
                this.userOutput.write(((SchemaToolsEvent)i.next()).toConsoleString());
                this.userOutput.flush();
            }
        }
        return internalSchema;
    }

    public void defineSchema(String doctype, String collection, String schema, String taminoUrl) throws IOException, Abort {
        this.debugLogger.println("Defining Schema " + schema + ", with Doctype " + doctype + " in DB " + taminoUrl);
        DefinitionSchemaNavigator internalSchema = this.getInternalSchema(true);
        DefinitionSchemaTool tool = new DefinitionSchemaTool();
        tool.createSchemaInfo(internalSchema, collection, schema);
        if (internalSchema.getReferencedElementDefinition(doctype) != null) {
            DefinitionNavigator schemaDefinition = internalSchema.getSchemaDefinition();
            boolean hasThisDoctype = false;
            if (schemaDefinition.hasChildren()) {
                Iterator childIter = schemaDefinition.getAllChildren().iterator();
                while (childIter.hasNext()) {
                    DefinitionNavigator child = (DefinitionNavigator)childIter.next();
                    if (!child.getDefinitionName().equals("doctype") || !child.getLogicalProperty("doctypeName").getValue().equals(doctype)) continue;
                    hasThisDoctype = true;
                    this.debugLogger.println("Doctype: " + doctype + " already defined in schema!");
                    break;
                }
            }
            if (!hasThisDoctype) {
                tool.createDoctype(internalSchema, doctype);
            }
        } else {
            throw new Abort("Doctype: " + doctype + " has no corresponding element definition in schema " + schema);
        }
        this.debugLogger.println("Output of DefineTSD:");
        String msg = DefineTSD.def(taminoUrl, collection, internalSchema.toString(), new PrintStream(System.out));
        if (msg != null) {
            throw new Abort("Problems while defining schema " + schema + " " + msg);
        }
    }

    public boolean isTopLevelElement(String elementName) throws IOException, Abort {
        DefinitionSchemaNavigator internalSchema = this.getInternalSchema(false);
        List topLevelElements = this.getGlobalElements(internalSchema);
        return topLevelElements.contains(elementName);
    }

    public String getDefaultDoctype() throws IOException, Abort {
        DefinitionSchemaNavigator internalSchema = this.getInternalSchema(false);
        List topLevelElements = this.getGlobalElements(internalSchema);
        this.debugLogger.println("topLevelElements:");
        Iterator i = topLevelElements.iterator();
        while (i.hasNext()) {
            this.debugLogger.print((String)i.next() + ", ");
        }
        this.debugLogger.println("");
        if (topLevelElements.isEmpty()) {
            return "???";
        }
        return (String)topLevelElements.get(0);
    }

    public void deleteCollection(String collection, String taminoUrl) throws IOException {
        this.userOutput.write("Deleting Collection " + collection + "...<br>");
        this.userOutput.flush();
        try {
            TaminoStore taminoStore = new TaminoStore(taminoUrl);
            taminoStore.deleteCollection(collection);
        }
        catch (StoreException e) {
            this.userOutput.write("Exception while deleting collection " + collection + " in DB " + taminoUrl + ": " + e.toString());
        }
    }

    public List getGlobalElements(DefinitionSchemaNavigator schema) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator topLevelIter = schema.getTopLevelElementDefinitions().iterator();
        while (topLevelIter.hasNext()) {
            result.add(((DefinitionNavigator)topLevelIter.next()).getLogicalProperty("name").getValue());
        }
        return result;
    }
}

