/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.Log;
import com.softwareag.xtools.xapplication.generator.WebInf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Prepare {
    private static File resourceDir = null;
    private static Log debugLogger = new Log(false, "[Prepare]");
    private static final String S = File.separator;
    private static final String CONFIG_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xappgenConfig>\n <general>\n  <schemaRoot value=\"{0}\"/>\n </general>\n <output>\n  <maxBrowseElem value=\"6\"/>\n </output>\n <xslParser>\n  <!-- *** Please dont change the xslFile names. The path of the xslFile may be altered *** -->\n  <!-- *** The jspFile attribute may be changed without restrictions *** -->\n  <page xslFile=\"xsl" + S + "search.xsl\" jspFile=\"search.jsp\"/>\n" + "  <page xslFile=\"xsl" + S + "browse.xsl\" jspFile=\"list.jsp\"/>\n" + "  <page xslFile=\"xsl" + S + "view.xsl\" jspFile=\"view.jsp\"/>\n" + "  <page xslFile=\"xsl" + S + "modify.xsl\" jspFile=\"modify.jsp\"/>\n" + "  <page xslFile=\"xsl" + S + "create.xsl\" jspFile=\"create.jsp\"/>\n" + "  <page xslFile=\"xsl" + S + "delete.xsl\" jspFile=\"delete.jsp\"/>\n" + " </xslParser>\n" + "</xappgenConfig>\n";

    public static void prepare(File xappHome, File dir, String url, String coll, String doctype, String userId, String password) throws Abort {
        resourceDir = new File(xappHome, "template");
        debugLogger.println("Resource dir set to: " + resourceDir);
        debugLogger.println("Preparing directory " + dir);
        try {
            WebInf.copy(resourceDir, dir, false, false);
        }
        catch (IOException e) {
            throw new Abort("error copying resource files: " + e.getMessage());
        }
        File config = new File(dir, "config.xml");
        try {
            Prepare.createConfig(config, doctype);
        }
        catch (IOException e) {
            throw new Abort("error creating XAppGenerator config file " + config + ": " + e.getMessage());
        }
        try {
            WebInf.create(xappHome, true, new File(dir, "WEB-INF"), url, coll, doctype, userId, password);
        }
        catch (IOException e) {
            throw new Abort("cannot create WEB-INF directory: " + e.getMessage());
        }
        debugLogger.println("done");
    }

    private static void createConfig(File dest, String root) throws IOException {
        Object[] args = new Object[]{root};
        String content = MessageFormat.format(CONFIG_TEMPLATE, args);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            out.write(content.getBytes("UTF-8"));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    private static void copyResources(File dest) throws IOException {
        String prefix = "com/softwareag/xtools/xapplication/generator/template/";
        JarFile jar = new JarFile(resourceDir);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(prefix)) continue;
            Prepare.copyJarResource(jar.getInputStream(entry), dest, entryName.substring(prefix.length()));
        }
    }

    private static void copyJarResource(InputStream in, File destDir, String destName) throws IOException {
        try {
            int idx;
            while ((idx = destName.indexOf(47)) != -1) {
                String subdir = destName.substring(0, idx);
                System.out.println("subdir:" + subdir);
                destDir = new File(destDir, subdir);
                if (!destDir.exists() && !destDir.mkdir()) {
                    throw new IOException("cannot create directory: " + destDir);
                }
                destName.substring(idx + 1);
            }
            System.out.println("dest: " + destDir);
            FileOutputStream out = new FileOutputStream(new File(destDir, destName));
            try {
                WebInf.copy(in, out);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                out.close();
                throw throwable;
            }
            out.close();
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }
}

