/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.ApplicationLauncher;
import com.softwareag.xtools.xapplication.generator.ConfigContainer;
import com.softwareag.xtools.xapplication.generator.Generator;
import com.softwareag.xtools.xapplication.generator.Log;
import com.softwareag.xtools.xapplication.generator.Prepare;
import com.softwareag.xtools.xapplication.generator.SchemaContainer;
import com.softwareag.xtools.xapplication.generator.ServerThread;
import com.softwareag.xtools.xapplication.generator.XslParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class GuiServlet
extends HttpServlet {
    private ServerThread serverThread = null;
    private boolean remoteClient = false;
    private HttpSession session;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private ServletContext context;
    private Log debugLogger;
    private SchemaContainer schemaContainer = null;

    public void init() {
        this.debugLogger = new Log(true, "[GuiServlet]");
    }

    public void destroy() {
        this.serverThread.stopServer();
        this.session.invalidate();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.processRequest(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String layoutPage;
        this.response = resp;
        this.request = req;
        this.context = this.getServletContext();
        this.response.setBufferSize(0);
        this.response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = this.response.getWriter();
        this.session = this.request.getSession();
        String requestURL = HttpUtils.getRequestURL((HttpServletRequest)this.request).toString();
        String remoteHost = this.request.getRemoteHost();
        this.log("[INFO] request URL: " + requestURL);
        this.log("[INFO] remote host: " + remoteHost);
        if (requestURL.indexOf("http://localhost") != -1) {
            layoutPage = "Gui.html";
            this.remoteClient = false;
        } else {
            layoutPage = "GuiRemote.html";
            this.remoteClient = true;
        }
        this.debugLogger.println("Session isNew(): " + this.session.isNew());
        FileInputStream in = new FileInputStream(this.context.getInitParameter("XAPP_HOME") + File.separator + "generator" + File.separator + layoutPage);
        try {
            String paramName;
            Enumeration e = this.context.getInitParameterNames();
            while (e.hasMoreElements()) {
                paramName = (String)e.nextElement();
                if (this.session.getAttribute(paramName) != null) continue;
                this.session.setAttribute(paramName, (Object)this.context.getInitParameter(paramName));
            }
            Enumeration e2 = this.request.getParameterNames();
            while (e2.hasMoreElements()) {
                paramName = (String)e2.nextElement();
                this.session.setAttribute(paramName, (Object)this.request.getParameter(paramName));
            }
            String doctype = this.session.getAttribute("DOCTYPE") != null ? (String)this.session.getAttribute("DOCTYPE") : "";
            this.session.setAttribute("DOCTYPE", (Object)doctype);
            String schemaFile = this.session.getAttribute("TAMINO_SCHEMA_FILE") != null ? (String)this.session.getAttribute("TAMINO_SCHEMA_FILE") : "";
            this.session.setAttribute("TAMINO_SCHEMA_FILE", (Object)schemaFile);
            String schemaText = this.session.getAttribute("TAMINO_SCHEMA_TEXT") != null ? (String)this.session.getAttribute("TAMINO_SCHEMA_TEXT") : "";
            this.session.setAttribute("TAMINO_SCHEMA_TEXT", (Object)schemaText);
            String mode = this.session.getAttribute("MODE") != null ? (String)this.session.getAttribute("MODE") : "";
            this.session.setAttribute("MODE", (Object)mode);
            String schema = this.session.getAttribute("TAMINO_SCHEMA") != null ? (String)this.session.getAttribute("TAMINO_SCHEMA") : "";
            this.session.setAttribute("TAMINO_SCHEMA", (Object)schema);
            if (!schemaFile.equals("")) {
                this.schemaContainer = new SchemaContainer(new File((String)this.session.getAttribute("TAMINO_SCHEMA_FILE")), out);
                this.debugLogger.println("schemaContainer created with file: " + (String)this.session.getAttribute("TAMINO_SCHEMA_FILE"));
            } else if (!schemaText.equals("")) {
                this.schemaContainer = new SchemaContainer((String)this.session.getAttribute("TAMINO_SCHEMA_TEXT"), out);
                this.debugLogger.println("schemaContainer created with text:");
                this.debugLogger.println((String)this.session.getAttribute("TAMINO_SCHEMA_TEXT"));
            } else {
                this.debugLogger.println("No schemaContainer created!");
                this.schemaContainer = null;
            }
            if (doctype.equals("") && this.schemaContainer != null) {
                String defaultDoctype = this.schemaContainer.getDefaultDoctype();
                if (!defaultDoctype.equals("???")) {
                    this.session.setAttribute("DOCTYPE", (Object)defaultDoctype);
                } else {
                    throw new Abort("No top level element found!");
                }
            }
            this.session.setAttribute("TAMINO_SCHEMA", this.session.getAttribute("DOCTYPE"));
            if (!this.session.getAttribute("DOCTYPE").equals("") && this.session.getAttribute("TARGET_DIR").equals(this.session.getAttribute("TOMCAT_HOME") + File.separator + "webapps")) {
                this.session.setAttribute("TARGET_DIR", (Object)this.getNewAppDir((String)this.session.getAttribute("TARGET_DIR")));
            }
            if (this.remoteClient) {
                this.session.setAttribute("TAMINO_COLLECTION", (Object)("XappRemoteCol_" + this.session.getId()));
            }
            this.debugLogger.println("############## attribute values ###############");
            Enumeration e3 = this.session.getAttributeNames();
            while (e3.hasMoreElements()) {
                paramName = (String)e3.nextElement();
                String paramValue = (String)this.session.getAttribute(paramName);
                if (!paramName.equals("PASSWORD")) {
                    this.debugLogger.println(paramName + ": " + paramValue);
                    continue;
                }
                this.debugLogger.println(paramName + ": CONFIDENTIAL");
            }
            this.debugLogger.println("################################################");
            if (mode.equals("startapp")) {
                this.restartServer();
                ApplicationLauncher appLauncher = new ApplicationLauncher(this.context, this.request, this.session, out);
                appLauncher.process();
            } else {
                this.fillLayout(in, out);
                out.close();
                in.close();
            }
        }
        catch (Abort e) {
            out.write("<table border=\"2\" width=\"85%\">\n");
            out.write("<tr><td>\n");
            out.write("<font color=\"crimson\"> <bold><PRE>" + e.getMessage() + "</PRE></br>\n");
            out.write("...aborted</bold></font>\n");
            out.write("</tr></td>\n");
            out.write("</table>\n");
            out.write("</body>\n");
            out.write("<script  language=\"JavaScript\">\n");
            out.write(" <!--\n");
            out.write(" setAuthorization();\n");
            out.write(" //-->\n");
            out.write(" </script>\n");
            out.write("</html>\n");
            in.close();
            out.close();
            this.log("[ERROR] caused by " + remoteHost, e);
        }
        if (this.request.getSession(false) != null) {
            this.session.removeAttribute("TAMINO_AUTHORIZATION");
        }
    }

    private void fillLayout(InputStream src, PrintWriter dest) throws IOException, Abort {
        int status;
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(src));
        StreamTokenizer srcTokenizer = new StreamTokenizer(srcReader);
        srcTokenizer.resetSyntax();
        srcTokenizer.wordChars(33, 126);
        srcTokenizer.quoteChar(34);
        while ((status = srcTokenizer.nextToken()) != -1) {
            String nonPrefixToken;
            if (status == -3) {
                if (srcTokenizer.sval.length() > 5) {
                    if (srcTokenizer.sval.substring(0, 5).equals("xapp_")) {
                        String attr;
                        nonPrefixToken = srcTokenizer.sval.substring(5);
                        if (nonPrefixToken.equals("STATE")) {
                            if (this.request.getParameter("terminateButton") != null) {
                                this.cleanUp(dest);
                            } else {
                                this.callGenerator(dest);
                            }
                        } else if (nonPrefixToken.equals("TAMINO_SCHEMA")) {
                            this.showSchemaSourceDestination(dest);
                        } else if (nonPrefixToken.equals("TAMINO_AUTHORIZATION")) {
                            attr = (String)this.session.getAttribute(nonPrefixToken);
                            if (attr != null) {
                                dest.write("checked");
                            }
                        } else if (nonPrefixToken.equals("GEN_TYPE_0")) {
                            attr = (String)this.session.getAttribute("genType");
                            if (attr == null) {
                                dest.write("checked");
                            }
                        } else if (nonPrefixToken.equals("GEN_TYPE_1")) {
                            attr = (String)this.session.getAttribute("genType");
                            if (attr != null) {
                                dest.write("checked");
                            }
                        } else if (this.session.getAttribute(nonPrefixToken) != null) {
                            dest.write((String)this.session.getAttribute(nonPrefixToken));
                        } else {
                            dest.write(srcTokenizer.sval);
                        }
                    } else {
                        dest.write(" " + srcTokenizer.sval + " ");
                    }
                } else {
                    dest.write(" " + srcTokenizer.sval + " ");
                }
            } else if (status == 10) {
                dest.write("\n");
            }
            if (srcTokenizer.ttype != 34) continue;
            if (srcTokenizer.sval.length() > 5) {
                int startIndex = srcTokenizer.sval.indexOf("xapp_");
                if (startIndex != -1) {
                    nonPrefixToken = srcTokenizer.sval.substring(startIndex + 5);
                    if (this.session.getAttribute(nonPrefixToken) != null) {
                        dest.write("\"" + srcTokenizer.sval.substring(0, startIndex) + (String)this.session.getAttribute(nonPrefixToken) + "\"");
                        continue;
                    }
                    dest.write("\"\"");
                    continue;
                }
                dest.write("\"" + srcTokenizer.sval + "\"");
                continue;
            }
            dest.write("\"" + srcTokenizer.sval + "\"");
        }
        dest.flush();
    }

    private void callGenerator(PrintWriter dest) throws IOException, Abort {
        if (this.request.getParameter("genType") != null) {
            if (this.session.getAttribute("genType").equals("generate")) {
                this.generateApplication(dest);
            } else if (this.session.getAttribute("genType").equals("regenerate")) {
                this.regenerateApplication(dest);
            }
        } else {
            dest.write("no status available</br>");
            dest.flush();
        }
    }

    private void generateApplication(PrintWriter dest) throws IOException, Abort {
        if (this.schemaContainer != null) {
            if (!this.schemaContainer.isTopLevelElement((String)this.session.getAttribute("DOCTYPE"))) {
                throw new Abort("Doctype specified: " + (String)this.session.getAttribute("DOCTYPE") + " is no top level element in schema definition!");
            }
            this.schemaContainer.defineSchema((String)this.session.getAttribute("DOCTYPE"), (String)this.session.getAttribute("TAMINO_COLLECTION"), (String)this.session.getAttribute("TAMINO_SCHEMA"), (String)this.session.getAttribute("TAMINO_URL"));
            dest.write("Schema defined</br>");
            dest.write("<hr>");
            dest.flush();
        }
        File dir = new File((String)this.session.getAttribute("TARGET_DIR"));
        this.debugLogger.println("Generate target dir: " + dir);
        File xappHome = new File((String)this.session.getAttribute("XAPP_HOME"));
        this.log("[INFO] Doctype to be generated: " + (String)this.session.getAttribute("DOCTYPE"));
        String userId = null;
        String passWd = null;
        if (this.session.getAttribute("TAMINO_AUTHORIZATION") != null) {
            userId = (String)this.session.getAttribute("USER_ID");
            passWd = (String)this.session.getAttribute("PASSWORD");
        }
        Prepare.prepare(xappHome, dir, (String)this.session.getAttribute("TAMINO_URL"), (String)this.session.getAttribute("TAMINO_COLLECTION"), (String)this.session.getAttribute("DOCTYPE"), userId, passWd);
        dest.write("Application directory created</br>");
        dest.write("<hr>");
        dest.flush();
        ConfigContainer configContainer = new ConfigContainer(dir);
        Generator gen = new Generator(configContainer);
        dest.write("Generator started</br>");
        dest.write("<hr>");
        dest.flush();
        gen.generate();
        dest.write("Generation finished</br>");
        dest.write("<hr>");
        dest.flush();
        this.restartServer();
        dest.write("Tomcat restarted</br>");
        dest.write("<hr>");
        dest.flush();
        dest.write("<b>To start the generated application, wait until Tomcat is available.</b></br>");
        dest.write("<hr>");
        dest.flush();
        this.showStartApplicationButton(dest);
    }

    private void regenerateApplication(PrintWriter dest) throws IOException, Abort {
        File dir = new File((String)this.session.getAttribute("TARGET_DIR"));
        this.debugLogger.println("Regenerate directory: " + this.session.getAttribute("TARGET_DIR"));
        ConfigContainer configContainer = new ConfigContainer(dir);
        XslParser parser = new XslParser(configContainer);
        dest.write("XSLT processing started</br>");
        dest.write("<hr>");
        dest.flush();
        parser.parse();
        dest.write("Parsing finished!</br>");
        dest.write("<hr>");
        dest.flush();
        this.showStartApplicationButton(dest);
    }

    private void showSchemaSourceDestination(PrintWriter dest) throws IOException {
        dest.write("<tr bgcolor=#eeeeee cellpadding=\"0\">");
        dest.write("<td>&nbsp;</td>");
        if (!this.remoteClient) {
            dest.write("<td class=\"active\" id=\"TD_TAMINO_SCHEMA_FILE\" align=right><font face=\"Arial, Helvetica, sans-serif\">Schema source:&nbsp;</font></td>");
            dest.write("<td align=left colspan=\"2\">");
            dest.write("<input class=\"active\" type=\"text\" name=\"TAMINO_SCHEMA_FILE\" size=\"60\" value=\"\">");
        } else {
            dest.write("<td align=right valign=top><font face=\"Arial, Helvetica, sans-serif\">Schema source:&nbsp;</font></td>");
            dest.write("<td align=left colspan=\"2\">");
            dest.write("<textarea name=\"TAMINO_SCHEMA_TEXT\" rows=\"10\" cols=\"60\" wrap=\"off\">");
            if (this.session.getAttribute("TAMINO_SCHEMA_TEXT").equals("") || this.request.getParameter("terminateButton") != null) {
                dest.write("Paste schema definition here!");
            } else {
                dest.write((String)this.session.getAttribute("TAMINO_SCHEMA_TEXT"));
            }
            dest.write("</textarea>");
        }
        dest.write("</td>");
        dest.write("<td align=left>&nbsp;</td>");
        dest.write("<td align=left>&nbsp;</td>");
        dest.write("</tr>");
    }

    private void showStartApplicationButton(PrintWriter dest) throws IOException {
        String targetDir = (String)this.session.getAttribute("TARGET_DIR");
        int index = targetDir.lastIndexOf(File.separator);
        if (index != -1 && index + 1 <= targetDir.length()) {
            String webAppName = targetDir.substring(index + 1);
            URL requestURL = new URL(HttpUtils.getRequestURL((HttpServletRequest)this.request).toString());
            int port = requestURL.getPort();
            if (port != -1 && port != 80) {
                URL searchURL = new URL(requestURL, "/" + webAppName + "/search.jsp");
                this.debugLogger.println("The search URL: " + searchURL.toString());
                String tomcatHome = ((String)this.session.getAttribute("TOMCAT_HOME")).toUpperCase();
                if (targetDir.toUpperCase().indexOf(tomcatHome + File.separator + "WEBAPPS") == -1) {
                    String doctype = (String)this.session.getAttribute("DOCTYPE");
                    dest.write("<table border=\"2\" width=\"85%\">");
                    dest.write("<tr><td>");
                    dest.write("To start application please add the following line in the <b>&lt;ContextManager&gt;</b>");
                    dest.write("section of the <b>server.xml</b> file of your local Tomcat installation:<br><br>");
                    dest.write("<b>&lt;Context path=\"/" + webAppName + "\" docBase=\"" + targetDir + "\" debug=\"1\" reloadable=\"true\"/&gt;</b><br><br>");
                    dest.write("To access the web application, restart Tomcat and press button below<br>");
                    dest.write("</tr></td>");
                    dest.write("</table>");
                    dest.write("<hr>");
                    dest.write("<form>");
                    dest.write("<input type=\"button\" value=\"Start Application\" onClick=\"window.open('" + searchURL.toString() + "')\">");
                    dest.write("</form>");
                } else {
                    searchURL = new URL(searchURL.getProtocol(), searchURL.getHost(), 8081, searchURL.getFile());
                    dest.write("<form>");
                    dest.write("<input type=\"button\" value=\"Start generated application\" onClick=\"window.open('" + searchURL.toString() + "')\">");
                    dest.write("</form>");
                }
            } else {
                URL searchURL = new URL(requestURL, "/" + webAppName + "/search.jsp");
                this.debugLogger.println("The search URL: " + searchURL.toString());
                dest.write("<table border=\"2\" width=\"85%\">");
                dest.write("<tr><td>");
                dest.write("Now you can use the generated web application by pressing the <I>Start Application</I> button below.<br>");
                dest.write("<b>Please mind the following points:</b>");
                dest.write("<UL>");
                dest.write("<LI>The generated application is <b>temporary</b> and only for test purposes</LI>");
                dest.write("<LI>After your tests are finished, please <b>clean up</b> by pressing the <I>Clean Up</I> button</LI>");
                dest.write("<LI>All concurrent web applications run on one Tomcat which is restarted after a generation. Thus it may ");
                dest.write("happen, that the commitment of modifications fails. In that case the document has to be reloaded and modified again.</LI>");
                dest.write("<LI>It may occur that the <I>Start Application</I> button is displayed even if Tomcat hasn't finished the restart. ");
                dest.write("In that case, just reload the first page of your web application after waiting for some seconds more.</LI>");
                dest.write("</UL>");
                dest.write("</tr></td>");
                dest.write("</table>");
                dest.write("<hr>");
                dest.write("<form>");
                dest.write("<input type=\"button\" value=\"Start Application\" onClick=\"window.open('" + searchURL + "')\">");
                dest.write("</form>");
            }
        }
        dest.flush();
    }

    private void restartServer() {
        if (this.serverThread != null) {
            this.serverThread.stopServer();
        }
        this.serverThread = new ServerThread((String)this.session.getAttribute("TOMCAT_HOME"));
        this.serverThread.start();
    }

    private String getNewAppDir(String targetDir) {
        String doctype = (String)this.session.getAttribute("DOCTYPE");
        File webAppDir = new File(targetDir + File.separator + doctype);
        int i = 1;
        while (webAppDir.exists()) {
            webAppDir = new File(targetDir + File.separator + doctype + Integer.toString(i));
            ++i;
        }
        return webAppDir.toString();
    }

    private String getLatestAppDir(String targetDir) throws Abort {
        String doctype = (String)this.session.getAttribute("DOCTYPE");
        File currentWebAppDir = new File(targetDir + File.separator + doctype);
        File latestWebAppDir = null;
        int i = 1;
        while (currentWebAppDir.exists()) {
            latestWebAppDir = currentWebAppDir;
            currentWebAppDir = new File(targetDir + File.separator + doctype + Integer.toString(i));
            ++i;
        }
        if (latestWebAppDir == null) {
            throw new Abort("Web Application directory in " + targetDir + " for DOCTYPE " + doctype + " not existent!");
        }
        return latestWebAppDir.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanUp(PrintWriter dest) throws IOException, Abort {
        String cleanUpDir = (String)this.session.getAttribute("cleanUpDir");
        if (cleanUpDir != null && !cleanUpDir.equals(this.context.getInitParameter("TARGET_DIR"))) {
            String defaultTargetDir = this.context.getInitParameter("TARGET_DIR");
            if (!cleanUpDir.equals(defaultTargetDir)) {
                File cleanUpFile = new File(cleanUpDir);
                if (cleanUpFile.exists()) {
                    try {
                        dest.write("Stopping second Tomcat... <br>");
                        this.serverThread.stopServer();
                        String cleanupColl = (String)this.session.getAttribute("TAMINO_COLLECTION");
                        if (this.schemaContainer == null) {
                            throw new Abort("Cannot clean up, schemaContainer is NULL ");
                        }
                        this.schemaContainer.deleteCollection(cleanupColl, (String)this.session.getAttribute("TAMINO_URL"));
                        dest.write("Deleting application directory " + cleanUpDir + "...<br>");
                        dest.flush();
                        try {
                            Util.deleteRec(cleanUpFile);
                            dest.write("finished!<br>");
                        }
                        catch (IOException e) {
                            dest.write("failed!<br>");
                        }
                        if (this.request.getSession(false) == null) return;
                        this.session.invalidate();
                        dest.write("Session for " + cleanupColl + " invalidated!");
                        return;
                    }
                    catch (Exception e) {
                        throw new Abort(e.toString());
                    }
                }
                dest.write("Clean up took place already, start a new application!<br>");
                dest.flush();
                return;
            }
            dest.write("No new application generated yet, no need for clean up!<br>");
            dest.flush();
            return;
        }
        dest.write("No clean up performed, because no valid web application exists !!<br>");
        dest.flush();
    }
}

