/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.BreadthFirstInstructionHandler;
import com.softwareag.xtools.xapplication.generator.BreadthFirstSearchProcessor;
import com.softwareag.xtools.xapplication.generator.ConfigContainer;
import com.softwareag.xtools.xapplication.generator.DepthFirstInstructionHandler;
import com.softwareag.xtools.xapplication.generator.DepthFirstSchemaProcessor;
import com.softwareag.xtools.xapplication.generator.Generator;
import com.softwareag.xtools.xapplication.generator.Log;
import com.softwareag.xtools.xapplication.generator.XslParser;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class Generator
implements TSDConstants {
    private static final String XML_HEADER = "<?xml version =\"1.0\" encoding=\"utf-8\"?>\n";
    private ConfigContainer configContainer;
    private Element structureRoot;
    private Document structureDoc;
    private Element searchTree;
    private Element browseTree;
    private Element viewTree;
    private Element modifyTree;
    private Element createTree;
    private Element deleteTree;
    private Element schemaDocRoot;
    private Schema docSchema;
    private Element schemaRootElem;
    private Stack nestedLoopElementsView;
    private Stack nestedLoopElementsModify;
    private Stack nestedLoopElementsCreate;
    private Stack nestedLoopElementsDelete;
    private Stack nestedLoopElementsSearch;
    private Element currentInsertElementSearch = null;
    private Element currentInsertElementView = null;
    private Element currentInsertElementModify = null;
    private Element currentInsertElementCreate = null;
    private Element currentInsertElementDelete = null;
    private Namespace schemaNamespace;
    private OutputStreamWriter structureFileWriter;
    private String structureFileName = null;
    private Log log;
    private boolean isTest;

    public Generator(ConfigContainer configContainer) throws Abort {
        this(configContainer, true, false);
    }

    public Generator(ConfigContainer configContainer, boolean useLogger, boolean isTest) throws Abort {
        this.log = new Log(useLogger, "[Generator]");
        this.isTest = isTest;
        this.configContainer = configContainer;
        this.structureFileName = configContainer.getWebappDir() + File.separator + "structure.xml";
        this.log.println("Initializing Generator!");
        this.initialize();
        this.log.println("Reading Schema!");
        this.readSchema();
        this.log.println("Generator creation finished!");
    }

    private Element getChildByName(Element parentElem, String name) {
        List children = parentElem.getChildren();
        int j = 0;
        while (j < children.size()) {
            Element currentChild = (Element)children.get(j);
            if (name.equals(currentChild.getAttributeValue("name", currentChild.getNamespace()))) {
                return currentChild;
            }
            ++j;
        }
        return null;
    }

    private String getElementName(Element e) {
        String elemName = e.getAttributeValue("ref", e.getNamespace());
        if (elemName == null) {
            elemName = e.getAttributeValue("name", e.getNamespace());
        }
        return elemName;
    }

    private Element addToTree(Element tree, String tagName, Hashtable attributes) {
        if (tree != null) {
            Element newTagElement = new Element(tagName);
            Enumeration attNames = attributes.keys();
            while (attNames.hasMoreElements()) {
                String currentAttName = (String)attNames.nextElement();
                newTagElement.addAttribute(currentAttName, (String)attributes.get(currentAttName));
            }
            tree = tree.addContent(newTagElement);
            return newTagElement;
        }
        this.log.println("ERROR: Tried to append new element " + tagName + " to subtree that is null!");
        return null;
    }

    private void addNewHeads(Hashtable attributes) {
        String convertedName = this.convertFromPathLayout((String)attributes.get("name"));
        attributes.remove("name");
        attributes.put("name", convertedName);
        this.currentInsertElementSearch = this.addToTree(this.currentInsertElementSearch, "heading", attributes);
        this.currentInsertElementView = this.addToTree(this.currentInsertElementView, "heading", attributes);
        this.currentInsertElementModify = this.addToTree(this.currentInsertElementModify, "heading", attributes);
        this.currentInsertElementCreate = this.addToTree(this.currentInsertElementCreate, "heading", attributes);
        this.currentInsertElementDelete = this.addToTree(this.currentInsertElementDelete, "heading", attributes);
    }

    private void addNewChoices(Hashtable attributes) {
        this.currentInsertElementSearch = this.addToTree(this.currentInsertElementSearch, "choice", attributes);
        this.currentInsertElementView = this.addToTree(this.currentInsertElementView, "choice", attributes);
        this.currentInsertElementModify = this.addToTree(this.currentInsertElementModify, "choice", attributes);
        this.currentInsertElementCreate = this.addToTree(this.currentInsertElementCreate, "choice", attributes);
        this.currentInsertElementDelete = this.addToTree(this.currentInsertElementDelete, "choice", attributes);
    }

    private String convertFromPathLayout(String path) {
        String returnValue = path;
        if (path.startsWith("/")) {
            int startIndex = path.indexOf("/", 1);
            returnValue = startIndex != -1 && startIndex + 1 < path.length() ? path.substring(startIndex + 1) : path.substring(1);
        }
        int i = returnValue.indexOf(47);
        while (i != -1) {
            returnValue = returnValue.substring(0, i) + " - " + returnValue.substring(i + 1);
            i = returnValue.indexOf(47);
        }
        return returnValue;
    }

    private void addNewLoops(Hashtable loopAttributes) {
        this.currentInsertElementSearch = this.addToTree(this.currentInsertElementSearch, "loop", loopAttributes);
        this.nestedLoopElementsSearch.push(this.currentInsertElementSearch);
        this.currentInsertElementView = this.addToTree(this.currentInsertElementView, "loop", loopAttributes);
        this.nestedLoopElementsView.push(this.currentInsertElementView);
        this.currentInsertElementModify = this.addToTree(this.currentInsertElementModify, "loop", loopAttributes);
        this.nestedLoopElementsModify.push(this.currentInsertElementModify);
        this.currentInsertElementCreate = this.addToTree(this.currentInsertElementCreate, "loop", loopAttributes);
        this.nestedLoopElementsCreate.push(this.currentInsertElementCreate);
        this.currentInsertElementDelete = this.addToTree(this.currentInsertElementDelete, "loop", loopAttributes);
        this.nestedLoopElementsDelete.push(this.currentInsertElementDelete);
    }

    private void addNewFieldsOthers(Hashtable attributes) {
        this.addToTree(this.currentInsertElementView, "display", attributes);
        this.addToTree(this.currentInsertElementDelete, "display", attributes);
        attributes.put("size", "20");
        this.addToTree(this.currentInsertElementModify, "edit", attributes);
        this.addToTree(this.currentInsertElementCreate, "edit", attributes);
    }

    private void addNewSetchoice(Hashtable attributes) {
        this.addToTree(this.currentInsertElementModify, "setchoice", attributes);
        this.addToTree(this.currentInsertElementCreate, "setchoice", attributes);
    }

    private void addNewFieldsSearch(Hashtable attributes) {
        this.addToTree(this.currentInsertElementSearch, "input", attributes);
    }

    private void stepUpLoopLevel() {
        if (!this.nestedLoopElementsSearch.empty()) {
            this.nestedLoopElementsSearch.pop();
        } else {
            this.log.println("ERROR: Illegal loop level step up SEARCH");
        }
        this.currentInsertElementSearch = this.currentInsertElementSearch.getParent();
        if (!this.nestedLoopElementsView.empty()) {
            this.nestedLoopElementsView.pop();
        } else {
            this.log.println("ERROR: Illegal loop level step up VIEW");
        }
        this.currentInsertElementView = this.currentInsertElementView.getParent();
        if (!this.nestedLoopElementsDelete.empty()) {
            this.nestedLoopElementsDelete.pop();
        } else {
            this.log.println("ERROR: Illegal loop level step up DELETE");
        }
        this.currentInsertElementDelete = this.currentInsertElementDelete.getParent();
        if (!this.nestedLoopElementsModify.empty()) {
            this.nestedLoopElementsModify.pop();
        } else {
            this.log.println("ERROR: Illegal loop level step up MODIFY");
        }
        this.currentInsertElementModify = this.currentInsertElementModify.getParent();
        if (!this.nestedLoopElementsCreate.empty()) {
            this.nestedLoopElementsCreate.pop();
        } else {
            this.log.println("ERROR: Illegal loop level step up CREATE");
        }
        this.currentInsertElementCreate = this.currentInsertElementCreate.getParent();
    }

    private void stepUpInsertLevel() {
        this.currentInsertElementSearch = this.currentInsertElementSearch.getParent();
        this.currentInsertElementView = this.currentInsertElementView.getParent();
        this.currentInsertElementDelete = this.currentInsertElementDelete.getParent();
        this.currentInsertElementModify = this.currentInsertElementModify.getParent();
        this.currentInsertElementCreate = this.currentInsertElementCreate.getParent();
    }

    private void initialize() throws Abort {
        this.structureRoot = new Element("XAppGenWeb");
        this.searchTree = new Element("search");
        this.structureRoot.addContent(this.searchTree);
        this.currentInsertElementSearch = this.searchTree;
        this.browseTree = new Element("browse");
        this.structureRoot.addContent(this.browseTree);
        this.viewTree = new Element("view");
        this.structureRoot.addContent(this.viewTree);
        this.currentInsertElementView = this.viewTree;
        this.modifyTree = new Element("modify");
        this.structureRoot.addContent(this.modifyTree);
        this.currentInsertElementModify = this.modifyTree;
        this.createTree = new Element("create");
        this.structureRoot.addContent(this.createTree);
        this.currentInsertElementCreate = this.createTree;
        this.deleteTree = new Element("delete");
        this.structureRoot.addContent(this.deleteTree);
        this.currentInsertElementDelete = this.deleteTree;
        Document structureDoc = new Document(this.structureRoot);
        this.nestedLoopElementsView = new Stack();
        this.nestedLoopElementsCreate = new Stack();
        this.nestedLoopElementsModify = new Stack();
        this.nestedLoopElementsDelete = new Stack();
        this.nestedLoopElementsSearch = new Stack();
        try {
            File f = new File(this.structureFileName);
            FileOutputStream fos = new FileOutputStream(f);
            this.structureFileWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.structureFileWriter.write(XML_HEADER, 0, XML_HEADER.length());
        }
        catch (IOException e) {
            throw new Abort("cannot create " + this.structureFileName + ": " + e.getMessage());
        }
    }

    private void readSchema() throws Abort {
        TaminoStore store;
        String root = this.configContainer.getSchemaRoot();
        String collection = this.configContainer.getTaminoCollection();
        try {
            store = new TaminoStore(this.configContainer.getTaminoURL(), this.configContainer.getUserId(), this.configContainer.getPassword());
        }
        catch (StoreException e) {
            throw new Abort("cannot connect to Tamino: " + e.getMessage());
        }
        store.registerDoctypeCollection(root, collection);
        try {
            this.docSchema = Schema.read(store, root, false);
            this.schemaDocRoot = this.docSchema.getRoot();
        }
        catch (StoreException e) {
            throw new Abort("Error reading schema from Tamino: " + e.getMessage());
        }
        if (this.schemaDocRoot == null) {
            throw new Abort("No TSD3 schema '" + root + "' defined in collection '" + collection + "'");
        }
        this.schemaNamespace = this.schemaDocRoot.getNamespace();
        String schemaRootElemName = this.configContainer.getSchemaRoot();
        if (schemaRootElemName == null || schemaRootElemName.equals("")) {
            this.schemaRootElem = (Element)this.schemaDocRoot.getChildren().get(0);
            schemaRootElemName = this.schemaRootElem.getAttributeValue("name", this.schemaRootElem.getNamespace());
        } else {
            this.schemaRootElem = this.getChildByName(this.schemaDocRoot, schemaRootElemName);
        }
        if (this.schemaRootElem == null) {
            System.out.println("Root element " + schemaRootElemName + " not found in Schema " + this.configContainer.getTaminoURL());
            System.exit(-1);
        }
        this.log.println("schemaRootElemName: " + schemaRootElemName);
        this.log.println("schemaRootElem: " + this.schemaRootElem);
        this.structureRoot.addAttribute("name", schemaRootElemName);
    }

    public void generate() throws Abort {
        XMLOutputter structureDocOutputter = new XMLOutputter("  ", true);
        StringBuffer path = new StringBuffer();
        this.log.println("");
        this.log.println("Performing BFS for browse page...");
        this.breadthFirstSearch(this.schemaRootElem);
        this.log.println("");
        this.log.println("Performing DFS for other pages...");
        this.depthFirstSearch(this.schemaRootElem);
        try {
            structureDocOutputter.output(new Comment("Page generated by X-Application Generator Copyright (c) 2001 - 2002 SOFTWARE AG, ALL Rights Reserved"), (Writer)this.structureFileWriter);
            structureDocOutputter.output(this.structureRoot, (Writer)this.structureFileWriter);
            this.structureFileWriter.close();
            this.log.println("Generation finished!");
        }
        catch (IOException ioe) {
            throw new Abort("cannot write structure file: " + ioe.getMessage());
        }
        if (!this.isTest) {
            XslParser parser = new XslParser(this.configContainer);
            parser.parse();
        }
    }

    void depthFirstSearch(Element rootElement) {
        class DepthFirstInstHndl
        implements DepthFirstInstructionHandler {
            private final /* synthetic */ Generator this$0;

            DepthFirstInstHndl(Generator this$0) {
                this.this$0 = this$0;
            }

            public void processField(Hashtable attributes) {
                Generator.access$000(this.this$0, attributes);
            }

            public void processSearchField(Hashtable attributes) {
                Generator.access$100(this.this$0, attributes);
            }

            public void processOpenLoop(Hashtable attributes) {
                Generator.access$200(this.this$0, attributes);
            }

            public void processCloseLoop() {
                Generator.access$300(this.this$0);
            }

            public void processOpenHeading(Hashtable attributes) {
                Generator.access$400(this.this$0, attributes);
            }

            public void processCloseHeading() {
                Generator.access$500(this.this$0);
            }

            public void processOpenChoice(Hashtable attributes) {
                Generator.access$600(this.this$0, attributes);
            }

            public void processCloseChoice() {
                Generator.access$500(this.this$0);
            }

            public void processSetchoice(Hashtable attributes) {
                Generator.access$700(this.this$0, attributes);
            }
        }
        DepthFirstSchemaProcessor schemaProcessor = new DepthFirstSchemaProcessor(this.docSchema, new DepthFirstInstHndl(this));
        schemaProcessor.process(Schema.getElementName(rootElement));
    }

    void breadthFirstSearch(Element rootElement) {
        class BreadthFirstInstHndl
        implements BreadthFirstInstructionHandler {
            private final /* synthetic */ Generator this$0;

            BreadthFirstInstHndl(Generator this$0) {
                this.this$0 = this$0;
            }

            public void processField(Hashtable attributes) {
                Generator.access$900(this.this$0, Generator.access$800(this.this$0), "display", attributes);
            }
        }
        BreadthFirstSearchProcessor schemaProcessor = new BreadthFirstSearchProcessor(this.docSchema, new BreadthFirstInstHndl(this));
        String parentPath = "/";
        schemaProcessor.process(rootElement, parentPath);
    }

    static /* synthetic */ void access$000(Generator x0, Hashtable x1) {
        x0.addNewFieldsOthers(x1);
    }

    static /* synthetic */ void access$100(Generator x0, Hashtable x1) {
        x0.addNewFieldsSearch(x1);
    }

    static /* synthetic */ void access$200(Generator x0, Hashtable x1) {
        x0.addNewLoops(x1);
    }

    static /* synthetic */ void access$300(Generator x0) {
        x0.stepUpLoopLevel();
    }

    static /* synthetic */ void access$400(Generator x0, Hashtable x1) {
        x0.addNewHeads(x1);
    }

    static /* synthetic */ void access$500(Generator x0) {
        x0.stepUpInsertLevel();
    }

    static /* synthetic */ void access$600(Generator x0, Hashtable x1) {
        x0.addNewChoices(x1);
    }

    static /* synthetic */ void access$700(Generator x0, Hashtable x1) {
        x0.addNewSetchoice(x1);
    }

    static /* synthetic */ Element access$800(Generator x0) {
        return x0.browseTree;
    }

    static /* synthetic */ Element access$900(Generator x0, Element x1, String x2, Hashtable x3) {
        return x0.addToTree(x1, x2, x3);
    }
}

