/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.ConfigContainer;
import com.softwareag.xtools.xapplication.generator.Generator;
import com.softwareag.xtools.xapplication.generator.Prepare;
import java.io.File;

public class Generate {
    public static final String USAGE = "X-Application Generator generate\n  creates a new application. \nusage: generate dir url coll doctype [uid pwd]\n  dir     directory to be created. This directory must not exist.\n  url     Tamino URL, including database name.\n  coll    collection to hold application data. \n  doctype root element of the schema. \n  uid     user id the generated application uses for accessing Tamino [optional]. \n  pwd     password for the userid [optional]. \nexample (1): generate mydir http://localhost/tamino/mydb mycoll myroot\nexample (2): generate mydir http://localhost/tamino/mydb mycoll myroot userA passwordA\n";

    public static void main(String[] args) {
        System.out.println("X-Application Generator generate");
        if (args.length != 4 && args.length != 6) {
            System.out.println("4 or 6 arguments expected, got " + args.length);
            System.out.println(USAGE);
            System.exit(1);
        } else {
            int result = args.length == 4 ? Generate.process(args[0], args[1], args[2], args[3], null, null, true, false) : Generate.process(args[0], args[1], args[2], args[3], args[4], args[5], true, false);
            System.exit(result);
        }
    }

    public static int process(String dirname, String url, String coll, String doctype, String uid, String passwd, boolean debugOutput, boolean isTest) {
        File dir = new File(dirname);
        try {
            Prepare.prepare(Util.locateHome(), dir, url, coll, doctype, uid, passwd);
            ConfigContainer configContainer = new ConfigContainer(dir, debugOutput);
            Generator gen = new Generator(configContainer, debugOutput, isTest);
            gen.generate();
            return 0;
        }
        catch (Abort e) {
            System.err.println("error: " + e.getMessage());
            System.err.println("aborted");
            return -1;
        }
    }
}

