/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.Iterator;
import org.jdom.Element;

public class GenUtil
implements TSDConstants {
    public static boolean isOcc(Element elem) {
        return Schema.isOccurrence(elem) && !Schema.isOptional(elem);
    }

    public static boolean isOccSeq(Element elem) {
        if (elem == null) {
            throw new PreconditionViolation("parameter 'elem' must be not null");
        }
        Element parentElem = elem;
        do {
            if ((parentElem = parentElem.getParent()) != null) {
                if (!GenUtil.isSequenceNode(parentElem) || !GenUtil.isOcc(parentElem)) continue;
                return true;
            }
            return false;
        } while (!"complexType".equals(parentElem.getName()));
        return false;
    }

    public static boolean isContentNode(Schema schema, Element node) {
        return "element".equals((node = GenUtil.getElementDefinition(schema, node)).getName()) && (node.getChild("complexType") == null || node.getChild("complexType").getChild("simpleContent") != null);
    }

    public static boolean isComplexNode(Schema schema, Element node) {
        return "element".equals((node = GenUtil.getElementDefinition(schema, node)).getName()) && node.getChild("complexType") != null && node.getChild("complexType").getChild("simpleContent") == null;
    }

    public static boolean isSequenceNode(Element node) {
        return "sequence".equals(node.getName());
    }

    public static boolean isAnnotationNode(Element node) {
        return "annotation".equals(node.getName());
    }

    public static boolean isChoiceNode(Element node) {
        return "choice".equals(node.getName());
    }

    public static boolean isAttributeNode(Element node) {
        return "attribute".equals(node.getName());
    }

    public static String createContentString(Element node) {
        StringBuffer result = new StringBuffer();
        Iterator elems = Schema.getElementList(node, true).iterator();
        while (elems.hasNext()) {
            Element elem = (Element)elems.next();
            String elemName = Schema.getElementName(elem);
            result.append(elemName + " ");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String buildPath(String path1, String path2) {
        boolean slash = path1.length() > 0 && path2.length() > 0 && path1.charAt(path1.length() - 1) != '/' && path2.charAt(0) != '/';
        return path1 + (slash ? "/" : "") + path2;
    }

    public static String buildPath(String path1, String path2, String path3) {
        String result = GenUtil.buildPath(path1, path2);
        return GenUtil.buildPath(result, path3);
    }

    public static Element getElementDefinition(Schema schema, Element node) {
        String refName = node.getAttributeValue("ref");
        if (refName != null && (node = schema.lookupElement(refName)) == null) {
            throw new AssertionFailed("schema does not contain the element '" + refName + "'");
        }
        return node;
    }

    public static String getLastPathFragment(String path) {
        int idx = path.lastIndexOf(47);
        if (idx < 0 || idx == path.length() - 1) {
            return path;
        }
        return path.substring(idx + 1);
    }
}

