/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.generator.DepthFirstInstructionHandler;
import com.softwareag.xtools.xapplication.generator.GenUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class DepthFirstSchemaProcessor
implements TSDConstants {
    static final String XAPP_SEQ = "xapp:seq()";
    static final String DEFAULT_FIELD_SIZE = "20";
    private Hashtable visitedNodes;
    private Schema schema;
    private DepthFirstInstructionHandler handler;

    public DepthFirstSchemaProcessor(Schema schema, DepthFirstInstructionHandler handler) {
        if (schema == null) {
            throw new PreconditionViolation("parameter 'schema' must be not null");
        }
        if (handler == null) {
            throw new PreconditionViolation("parameter 'handler' must be not null");
        }
        this.schema = schema;
        this.handler = handler;
        this.visitedNodes = new Hashtable();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public DepthFirstInstructionHandler getHandler() {
        return this.handler;
    }

    public void process(String rootElem) {
        Element rootElement = this.schema.lookupElement(rootElem);
        if (rootElem == null) {
            throw new PreconditionViolation("root element '" + rootElem + "' nust be defined within the schema");
        }
        String parentPath = "/";
        String base = "";
        if (GenUtil.isComplexNode(this.schema, rootElement)) {
            this.visitedNodes.clear();
            this.processNode(rootElement, parentPath, base, true, false, false, new ArrayList());
        } else if (GenUtil.isContentNode(this.schema, rootElement)) {
            this.processHeading(parentPath, rootElem);
            this.processNode(rootElement, parentPath, base, false, false, false, new ArrayList());
            this.handler.processCloseHeading();
        } else {
            throw new AssertionFailed("root element '" + rootElem + "' must be an element");
        }
    }

    void processNode(Element node, String parentPath, String base, boolean isHeading, boolean inLoop, boolean isChoice, ArrayList choiceNodes) {
        if (GenUtil.isChoiceNode(node)) {
            this.processChoiceNode(node, parentPath, base, isHeading, inLoop, isChoice, choiceNodes);
        } else if (GenUtil.isSequenceNode(node)) {
            this.processSequenceNode(node, parentPath, base, isHeading, inLoop, isChoice, choiceNodes);
        } else if (GenUtil.isContentNode(this.schema, node)) {
            this.processContentNode(node, parentPath, base, isHeading, inLoop, isChoice, choiceNodes);
        } else if (GenUtil.isComplexNode(this.schema, node)) {
            this.processComplexNode(node, parentPath, base, isHeading, inLoop, isChoice, choiceNodes);
        } else if (GenUtil.isAttributeNode(node)) {
            this.processAttributeNode(node, parentPath, base, isHeading, inLoop);
        } else if (!GenUtil.isAnnotationNode(node)) {
            throw new AssertionFailed("unprocessed schema node '" + node.getName() + "' under '" + base + "/" + parentPath + "'");
        }
    }

    void processComplexNode(Element elem, String parentPath, String base, boolean isHeading, boolean inLoop, boolean isChoice, ArrayList choiceNodes) {
        Element nextNode;
        boolean inOcc;
        String choicePath;
        boolean visited;
        if (isHeading && inLoop) {
            throw new PreconditionViolation("loop context must prevent heading context");
        }
        String elemName = Schema.getElementName(elem);
        if (!isHeading && !inLoop) {
            return;
        }
        boolean bl = visited = elem.getAttributeValue("ref") != null && this.visitedNodes.get(elemName) != null;
        if (visited) {
            return;
        }
        this.visitedNodes.put(elemName, "");
        String string = choicePath = parentPath.equals("") ? "." : parentPath;
        if (isChoice) {
            int index = Schema.getElementIndex(elem.getParent(), elemName);
            this.processChoice(choicePath, Integer.toString(index));
        }
        this.processHeading(parentPath, elemName);
        boolean bl2 = inOcc = Schema.isOccurrence(elem) && !Schema.isOptional(elem);
        if (inOcc) {
            String iterateContent = elemName;
            String targetBase = GenUtil.buildPath(base, parentPath, elemName);
            this.processLoop(elem, targetBase, base, parentPath, iterateContent);
            base = targetBase;
            parentPath = "";
        } else {
            parentPath = GenUtil.buildPath(parentPath, elemName);
        }
        elem = GenUtil.getElementDefinition(this.schema, elem);
        Element cn = elem.getChild("complexType");
        List children = cn.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            nextNode = (Element)it.next();
            this.processNode(nextNode, parentPath, base, false, inOcc || inLoop, false, choiceNodes);
        }
        if (inOcc) {
            this.handler.processCloseLoop();
        }
        this.handler.processCloseHeading();
        if (isHeading && !inOcc) {
            it = children.iterator();
            while (it.hasNext()) {
                nextNode = (Element)it.next();
                this.processNode(nextNode, parentPath, base, isHeading, inOcc, false, choiceNodes);
            }
        }
        if (isChoice) {
            it = ((AbstractList)choiceNodes).iterator();
            while (it.hasNext()) {
                String nextNodeName = (String)it.next();
                if (nextNodeName.equals(elemName)) continue;
                this.processSetchoice(choicePath, nextNodeName);
            }
            this.handler.processCloseChoice();
        }
        if (!visited) {
            this.visitedNodes.remove(elemName);
        }
    }

    void processContentNode(Element elem, String parentPath, String base, boolean isHeading, boolean inLoop, boolean isChoice, ArrayList choiceNodes) {
        String choicePath;
        if (isHeading) {
            return;
        }
        boolean inOcc = Schema.isOccurrence(elem) && !Schema.isOptional(elem);
        String elemName = Schema.getElementName(elem);
        String relPath = inOcc ? "." : GenUtil.buildPath(parentPath, elemName);
        String fulPath = inOcc ? GenUtil.buildPath(base, parentPath, elemName) : GenUtil.buildPath(base, relPath);
        String string = choicePath = parentPath.equals("") ? "." : parentPath;
        if (isChoice) {
            int index = Schema.getElementIndex(elem.getParent(), elemName);
            this.processChoice(choicePath, Integer.toString(index));
        }
        if (inOcc) {
            String iterateContent = elemName;
            String targetBase = fulPath;
            this.processLoop(elem, targetBase, base, parentPath, iterateContent);
            base = targetBase;
            parentPath = "";
        } else {
            parentPath = GenUtil.buildPath(parentPath, elemName);
        }
        this.processField(elemName, relPath, fulPath);
        elem = GenUtil.getElementDefinition(this.schema, elem);
        Element cn = elem.getChild("complexType");
        if (cn != null) {
            cn = cn.getChild("simpleContent");
            cn = cn.getChild("extension");
            List children = cn.getChildren();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Element nextNode = (Element)it.next();
                this.processNode(nextNode, parentPath, base, false, inOcc || inLoop, false, choiceNodes);
            }
        }
        if (inOcc) {
            this.handler.processCloseLoop();
        }
        if (isChoice) {
            Iterator it = ((AbstractList)choiceNodes).iterator();
            while (it.hasNext()) {
                String nextNodeName = (String)it.next();
                if (nextNodeName.equals(elemName)) continue;
                this.processSetchoice(choicePath, nextNodeName);
            }
            this.handler.processCloseChoice();
        }
    }

    void processSequenceNode(Element elem, String parentPath, String base, boolean isHeading, boolean inLoop, boolean isChoice, ArrayList choiceNodes) {
        Element nextNode;
        boolean inOcc;
        boolean bl = inOcc = Schema.isOccurrence(elem) && !Schema.isOptional(elem);
        if (inOcc && isHeading) {
            return;
        }
        String choicePath = "???";
        int index = 0;
        String indexString = "???";
        if (isChoice) {
            Iterator siblings = elem.getParent().getChildren().iterator();
            while (siblings.hasNext()) {
                nextNode = (Element)siblings.next();
                if (nextNode.equals((Object)elem)) break;
                ++index;
            }
            indexString = new Integer(index).toString();
            choicePath = parentPath.equals("") ? "." : parentPath;
            parentPath = GenUtil.buildPath(parentPath, "xapp:child(1)");
            this.processChoice(choicePath, indexString);
        }
        if (inOcc) {
            boolean occType = elem.getParent() != null && !"complexType".equals(elem.getParent().getName());
            String iterateContent = occType ? GenUtil.createContentString(elem) : "";
            String targetBase = occType ? GenUtil.buildPath(base, parentPath) : GenUtil.buildPath(base, parentPath, XAPP_SEQ);
            this.processLoop(elem, targetBase, base, parentPath, iterateContent);
            base = targetBase;
            parentPath = "";
            isHeading = false;
        }
        Iterator children = elem.getChildren().iterator();
        while (children.hasNext()) {
            nextNode = (Element)children.next();
            this.processNode(nextNode, parentPath, base, isHeading, inLoop || inOcc, false, choiceNodes);
        }
        if (inOcc) {
            this.handler.processCloseLoop();
        }
        if (isChoice) {
            Iterator it = ((AbstractList)choiceNodes).iterator();
            while (it.hasNext()) {
                String nextNodeName = (String)it.next();
                if (nextNodeName.equals(indexString)) continue;
                this.processSetchoice(choicePath, nextNodeName);
            }
            this.handler.processCloseChoice();
        }
    }

    void processChoiceNode(Element elem, String parentPath, String base, boolean isHeading, boolean inLoop, boolean isChoice, ArrayList outerChoiceNodes) {
        boolean inOcc;
        String choicePath = "???";
        int index = 0;
        String indexString = "???";
        if (isChoice) {
            Iterator siblings = elem.getParent().getChildren().iterator();
            while (siblings.hasNext()) {
                Element nextNode = (Element)siblings.next();
                if (nextNode.equals((Object)elem)) break;
                ++index;
            }
            indexString = new Integer(index).toString();
            choicePath = parentPath.equals("") ? "." : parentPath;
            parentPath = GenUtil.buildPath(parentPath, "xapp:child(1)");
            this.processChoice(choicePath, indexString);
        }
        boolean bl = inOcc = Schema.isOccurrence(elem) && !Schema.isOptional(elem);
        if (inOcc && isHeading) {
            return;
        }
        if (inOcc) {
            boolean occType = elem.getParent() != null && !"complexType".equals(elem.getParent().getName());
            String iterateContent = occType ? GenUtil.createContentString(elem) : "";
            String targetBase = occType ? GenUtil.buildPath(base, parentPath) : GenUtil.buildPath(base, parentPath, XAPP_SEQ);
            this.processLoop(elem, targetBase, base, parentPath, iterateContent);
            base = targetBase;
            parentPath = "";
            isHeading = false;
        }
        ArrayList<String> choiceNodes = new ArrayList<String>(20);
        Iterator it = elem.getChildren().iterator();
        int childIndex = 0;
        while (it.hasNext()) {
            Element nextNode = (Element)it.next();
            String nodeName = Schema.getElementName(nextNode);
            if (nodeName != null) {
                choiceNodes.add(nodeName);
            } else {
                String iString = new Integer(childIndex).toString();
                choiceNodes.add(iString);
            }
            ++childIndex;
        }
        Iterator children = elem.getChildren().iterator();
        while (children.hasNext()) {
            Element nextNode = (Element)children.next();
            this.processNode(nextNode, parentPath, base, isHeading, inLoop || inOcc, true, choiceNodes);
        }
        if (inOcc) {
            this.handler.processCloseLoop();
        }
        if (isChoice) {
            it = ((AbstractList)outerChoiceNodes).iterator();
            while (it.hasNext()) {
                String nextNodeName = (String)it.next();
                if (nextNodeName.equals(indexString)) continue;
                this.processSetchoice(choicePath, nextNodeName);
            }
            this.handler.processCloseChoice();
        }
    }

    void processAttributeNode(Element elem, String parentPath, String base, boolean isHeading, boolean inLoop) {
        if (isHeading) {
            return;
        }
        String attrName = Schema.getElementName(elem);
        String relPath = GenUtil.buildPath(parentPath, "@" + attrName);
        String fulPath = GenUtil.buildPath(base, relPath);
        this.processField(attrName, relPath, fulPath);
    }

    void processHeading(String parentPath, String elemName) {
        Hashtable<String, String> headAttributes = new Hashtable<String, String>(1);
        headAttributes.put("name", GenUtil.buildPath(parentPath, elemName));
        this.handler.processOpenHeading(headAttributes);
    }

    void processChoice(String parentPath, String elemName) {
        Hashtable<String, String> choiceAttributes = new Hashtable<String, String>(1);
        choiceAttributes.put("select", parentPath);
        choiceAttributes.put("type", elemName);
        this.handler.processOpenChoice(choiceAttributes);
    }

    void processSetchoice(String parentPath, String elemName) {
        Hashtable<String, String> choiceAttributes = new Hashtable<String, String>(1);
        choiceAttributes.put("select", parentPath);
        choiceAttributes.put("type", elemName);
        this.handler.processSetchoice(choiceAttributes);
    }

    void processLoop(Element node, String targetBase, String base, String selectPath, String iterateContent) {
        if (base.length() == 0 && selectPath.length() == 0) {
            throw new PreconditionViolation("both parameter base and selectPath can not length Zero at the same time");
        }
        Hashtable<String, String> loopAttributes = new Hashtable<String, String>(5);
        if (targetBase.length() > 0) {
            loopAttributes.put("targetbase", targetBase);
        }
        if (base.length() > 0) {
            loopAttributes.put("base", base);
        }
        loopAttributes.put("select", selectPath.length() == 0 ? "." : selectPath);
        if (iterateContent.length() > 0) {
            loopAttributes.put("iterate", iterateContent);
            loopAttributes.put("name", iterateContent);
        } else {
            String name = Schema.getElementName(node);
            if (name == null) {
                name = GenUtil.createContentString(node);
            }
            loopAttributes.put("name", name);
        }
        this.handler.processOpenLoop(loopAttributes);
    }

    void processField(String fieldName, String relPath, String fulPath) {
        Hashtable<String, String> fieldAttributes = new Hashtable<String, String>();
        fieldAttributes.put("name", fieldName);
        fieldAttributes.put("select", DepthFirstSchemaProcessor.clearStructurePath(fulPath));
        fieldAttributes.put("size", DEFAULT_FIELD_SIZE);
        this.handler.processSearchField(fieldAttributes);
        fieldAttributes.put("select", relPath);
        fieldAttributes.remove("size");
        this.handler.processField(fieldAttributes);
    }

    static String clearStructurePath(String path) {
        StringBuffer result = new StringBuffer(path);
        int xappIdx = path.indexOf(XAPP_SEQ);
        int deletedChar = 0;
        while (xappIdx >= 0) {
            result.delete(xappIdx - deletedChar, xappIdx - deletedChar + XAPP_SEQ.length());
            deletedChar += XAPP_SEQ.length();
            xappIdx = path.indexOf(XAPP_SEQ, xappIdx + XAPP_SEQ.length());
        }
        String DS = "//";
        path = result.toString();
        int doubleSlash = path.indexOf("//");
        deletedChar = 0;
        while (doubleSlash >= 0) {
            result.delete(doubleSlash - deletedChar, doubleSlash - deletedChar + 1);
            ++deletedChar;
            doubleSlash = path.indexOf("//", doubleSlash + 1);
        }
        return result.toString();
    }
}

