/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.Log;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class ConfigContainer {
    private Element configDocRoot;
    private Element generalElem;
    private Element outputElem;
    private Element xslParserElem;
    private Namespace configNamespace;
    private Element webXmlDocRoot;
    private Namespace webXmlNamespace;
    private Element taminoUrlElem;
    private Element taminoCollectionElem;
    private Element userIdElem;
    private Element passwordElem;
    private File webAppDir;
    private Log debugLogger;

    public ConfigContainer(File webAppDir) throws Abort {
        this(webAppDir, true);
    }

    public ConfigContainer(File webAppDir, boolean doLog) throws Abort {
        File config = new File(webAppDir, "config.xml");
        File webXml = new File(webAppDir, "WEB-INF" + File.separatorChar + "web.xml");
        this.webAppDir = webAppDir;
        this.debugLogger = new Log(doLog, "[ConfigContainer]");
        this.readConfigFile(config);
        this.readWebXmlFile(webXml);
    }

    public static boolean isWebAppDir(File dir) {
        File config = new File(dir, "config.xml");
        File webXml = new File(dir, "WEB-INF" + File.separatorChar + "web.xml");
        return config.exists() && webXml.exists();
    }

    private Element readXml(File src) throws Abort {
        try {
            this.debugLogger.println("reading " + src);
            Element elem = Util.fileToElement(src);
            this.debugLogger.println("done reading " + src);
            return elem;
        }
        catch (JDOMException e) {
            throw new Abort("error reading " + src + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new Abort("error reading " + src + ": " + e.getMessage());
        }
    }

    private void readConfigFile(File src) throws Abort {
        this.configDocRoot = this.readXml(src);
        this.configNamespace = this.configDocRoot.getNamespace();
        this.generalElem = this.configDocRoot.getChild("general", this.configNamespace);
        this.outputElem = this.configDocRoot.getChild("output", this.configNamespace);
        this.xslParserElem = this.configDocRoot.getChild("xslParser", this.configNamespace);
    }

    private void readWebXmlFile(File src) throws Abort {
        this.webXmlDocRoot = this.readXml(src);
        this.webXmlNamespace = this.webXmlDocRoot.getNamespace();
        List paramList = this.webXmlDocRoot.getChildren("context-param");
        if (paramList != null) {
            int i = 0;
            while (i < paramList.size()) {
                Element paramElem = (Element)paramList.get(i);
                Element paramNameElem = paramElem.getChild("param-name", this.webXmlNamespace);
                if (paramNameElem != null) {
                    String paramName = paramNameElem.getText();
                    if (paramName.equals("TAMINO_URL")) {
                        this.taminoUrlElem = paramElem;
                    } else if (paramName.equals("TAMINO_COLLECTION1")) {
                        this.taminoCollectionElem = paramElem;
                    } else if (paramName.equals("USER_ID")) {
                        this.userIdElem = paramElem;
                    } else if (paramName.equals("PASSWORD")) {
                        this.passwordElem = paramElem;
                    }
                }
                ++i;
            }
        } else {
            this.debugLogger.println("ERROR: No <context-param> elements specified in web.xml!");
            System.exit(-1);
        }
    }

    public String getTaminoURL() {
        return this.taminoUrlElem.getChild("param-value", this.webXmlNamespace).getText();
    }

    public String getTaminoCollection() {
        return this.taminoCollectionElem.getChild("param-value", this.webXmlNamespace).getText();
    }

    public String getUserId() {
        return this.userIdElem != null ? this.userIdElem.getChild("param-value", this.webXmlNamespace).getText() : null;
    }

    public String getPassword() {
        return this.passwordElem != null ? this.passwordElem.getChild("param-value", this.webXmlNamespace).getText() : null;
    }

    public String getSchemaRoot() {
        return this.generalElem.getChild("schemaRoot", this.configNamespace).getAttributeValue("value");
    }

    public String getWebappDir() throws Abort {
        try {
            return this.webAppDir.getCanonicalPath();
        }
        catch (Exception e) {
            throw new Abort("error reading extracting path from File " + this.webAppDir);
        }
    }

    public int getMaxBrowseElem() {
        int maxBrowseElem;
        try {
            maxBrowseElem = Integer.parseInt(this.outputElem.getChild("maxBrowseElem", this.configNamespace).getAttributeValue("value"));
        }
        catch (NumberFormatException e) {
            maxBrowseElem = 5;
        }
        return maxBrowseElem;
    }

    public String[][] getPages() {
        List xslParserChildren = this.xslParserElem.getChildren();
        int numberOfPages = xslParserChildren.size();
        String[][] pages = new String[numberOfPages][2];
        int j = 0;
        while (j < numberOfPages) {
            Element currentChild = (Element)xslParserChildren.get(j);
            if (currentChild.getName().equals("page")) {
                pages[j][0] = currentChild.getAttributeValue("xslFile");
                pages[j][1] = currentChild.getAttributeValue("jspFile");
            }
            ++j;
        }
        return pages;
    }
}

