/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.generator.BreadthFirstInstructionHandler;
import com.softwareag.xtools.xapplication.generator.GenUtil;
import com.softwareag.xtools.xapplication.generator.Log;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.jdom.Element;

public class BreadthFirstSearchProcessor
implements TSDConstants {
    private ArrayList nodePathList;
    private Schema schema;
    private BreadthFirstInstructionHandler handler;
    private Log debugLogger;

    public BreadthFirstSearchProcessor(Schema schema, BreadthFirstInstructionHandler handler) {
        if (schema == null) {
            throw new PreconditionViolation("parameter 'schema' must be not null");
        }
        this.schema = schema;
        this.handler = handler;
        this.nodePathList = new ArrayList(20);
        this.debugLogger = new Log(false, "[BFS]");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void process(Element elem, String parentPath) {
        Object[] nodePathPair;
        Element elemDef = GenUtil.getElementDefinition(this.schema, elem);
        if (GenUtil.isComplexNode(this.schema, elemDef)) {
            nodePathPair = new Object[]{elemDef.getChild("complexType"), parentPath};
            this.nodePathList.add(nodePathPair);
        } else if (GenUtil.isSequenceNode(elemDef)) {
            nodePathPair = new Object[]{elemDef.getChild("sequence"), parentPath};
            this.nodePathList.add(nodePathPair);
        } else if (!GenUtil.isChoiceNode(elemDef)) {
            if (GenUtil.isContentNode(this.schema, elemDef)) {
                nodePathPair = new Object[]{elemDef, parentPath};
                this.nodePathList.add(nodePathPair);
            } else if (!GenUtil.isAnnotationNode(elemDef)) throw new AssertionFailed("unprocessed schema node '" + elemDef.getName() + "' under '" + parentPath + "'");
        }
        while (!this.nodePathList.isEmpty()) {
            nodePathPair = (Object[])this.nodePathList.remove(0);
            this.processNode((Element)nodePathPair[0], (String)nodePathPair[1]);
        }
    }

    public void processNode(Element elem, String parentPath) {
        if (elem == null) {
            throw new PreconditionViolation("root element '" + elem + "' nust be defined within the schema");
        }
        this.debugLogger.println("Processing: " + elem.getName());
        Iterator children = elem.getChildren().iterator();
        while (children.hasNext()) {
            Element currentElem = (Element)children.next();
            Element currentElemDef = GenUtil.getElementDefinition(this.schema, currentElem);
            if (GenUtil.isContentNode(this.schema, currentElemDef)) {
                this.processContentNode(currentElem, currentElemDef, parentPath);
                continue;
            }
            if (GenUtil.isAttributeNode(currentElemDef)) {
                this.processAttributeNode(currentElemDef, parentPath);
                continue;
            }
            if (GenUtil.isComplexNode(this.schema, currentElemDef)) {
                this.processComplexNode(currentElem, currentElemDef, parentPath);
                continue;
            }
            if (GenUtil.isSequenceNode(currentElemDef)) {
                this.processSequenceNode(currentElemDef, parentPath);
                continue;
            }
            if (GenUtil.isChoiceNode(currentElemDef)) continue;
            throw new AssertionFailed("Unprocessed schema node '" + currentElemDef.getName() + "' under '" + parentPath + "'");
        }
    }

    void processContentNode(Element elemInTree, Element elem, String parentPath) {
        Hashtable<String, String> attributes = new Hashtable<String, String>(2);
        String elemName = Schema.getElementName(elem);
        String elemPath = GenUtil.buildPath(parentPath, elemName);
        if (GenUtil.isOcc(elemInTree) || GenUtil.isOcc(elem) || GenUtil.isOccSeq(elemInTree)) {
            attributes.put("name", elemName + "[1]");
            attributes.put("select", elemPath + "[1]");
        } else {
            attributes.put("select", elemPath);
            attributes.put("name", elemName);
        }
        this.handler.processField(attributes);
    }

    void processAttributeNode(Element elem, String parentPath) {
        Hashtable<String, String> attributes = new Hashtable<String, String>(2);
        String elemName = Schema.getElementName(elem);
        String elemPath = GenUtil.buildPath(parentPath, "@" + elemName);
        attributes.put("name", elemName);
        attributes.put("select", elemPath);
        this.handler.processField(attributes);
    }

    void processComplexNode(Element elemInTree, Element elem, String parentPath) {
        String elemName = Schema.getElementName(elem);
        String elemPath = GenUtil.isOcc(elemInTree) || GenUtil.isOcc(elem) || GenUtil.isOccSeq(elemInTree) ? GenUtil.buildPath(parentPath, elemName + "[1]") : GenUtil.buildPath(parentPath, elemName);
        Object[] nodePathPair = new Object[]{elem.getChild("complexType"), elemPath};
        this.nodePathList.add(nodePathPair);
    }

    void processSequenceNode(Element elem, String parentPath) {
        Object[] nodePathPair = new Object[]{elem, parentPath};
        this.nodePathList.add(nodePathPair);
    }
}

