/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.generator;

import com.softwareag.xtools.xapplication.generator.Abort;
import com.softwareag.xtools.xapplication.generator.ConfigContainer;
import com.softwareag.xtools.xapplication.generator.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class ApplicationLauncher {
    private HttpSession session;
    private PrintWriter out;
    private ServletContext context;
    private HttpServletRequest request;
    private Log debugLogger;
    private ArrayList appNameList = null;

    public ApplicationLauncher(ServletContext context, HttpServletRequest request, HttpSession session, PrintWriter out) {
        this.context = context;
        this.request = request;
        this.session = session;
        this.out = out;
        this.debugLogger = new Log(true, "[StartAppPage]");
    }

    public void process() throws Abort {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.context.getInitParameter("XAPP_HOME") + File.separator + "generator" + File.separator + "StartApp.html");
            this.fillLayout(in, this.out);
            this.out.close();
            in.close();
        }
        catch (IOException e) {
            throw new Abort("IOException while trying to read template HTML page StartApp.html");
        }
    }

    private void fillLayout(InputStream src, PrintWriter dest) throws IOException, Abort {
        int status;
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(src));
        StreamTokenizer srcTokenizer = new StreamTokenizer(srcReader);
        srcTokenizer.resetSyntax();
        srcTokenizer.wordChars(33, 126);
        srcTokenizer.quoteChar(34);
        while ((status = srcTokenizer.nextToken()) != -1) {
            String nonPrefixToken;
            if (status == -3) {
                if (srcTokenizer.sval.length() > 5) {
                    if (srcTokenizer.sval.substring(0, 5).equals("xapp_")) {
                        nonPrefixToken = srcTokenizer.sval.substring(5);
                        if (nonPrefixToken.equals("CHOOSE")) {
                            this.appNameList = this.getStartAppDirs();
                            this.showApps(this.appNameList);
                        } else if (nonPrefixToken.equals("START_BUTTON")) {
                            this.showStartApplicationButton();
                        } else if (this.session.getAttribute(nonPrefixToken) != null) {
                            dest.write((String)this.session.getAttribute(nonPrefixToken));
                        } else {
                            dest.write(srcTokenizer.sval);
                        }
                    } else {
                        dest.write(" " + srcTokenizer.sval + " ");
                    }
                } else {
                    dest.write(" " + srcTokenizer.sval + " ");
                }
            } else if (status == 10) {
                dest.write("\n");
            }
            if (srcTokenizer.ttype != 34) continue;
            if (srcTokenizer.sval.length() > 5) {
                int startIndex = srcTokenizer.sval.indexOf("xapp_");
                if (startIndex != -1) {
                    nonPrefixToken = srcTokenizer.sval.substring(startIndex + 5);
                    if (this.session.getAttribute(nonPrefixToken) != null) {
                        dest.write("\"" + srcTokenizer.sval.substring(0, startIndex) + (String)this.session.getAttribute(nonPrefixToken) + "\"");
                        continue;
                    }
                    dest.write("\"\"");
                    continue;
                }
                dest.write("\"" + srcTokenizer.sval + "\"");
                continue;
            }
            dest.write("\"" + srcTokenizer.sval + "\"");
        }
        dest.flush();
    }

    private ArrayList getStartAppDirs() throws Abort {
        ArrayList<String> startAppList = new ArrayList<String>(10);
        File webappDir = new File(this.context.getInitParameter("TOMCAT_HOME") + File.separator + "webapps");
        Iterator<File> fileIterator = Arrays.asList(webappDir.listFiles()).iterator();
        String taminoCollection = (String)this.session.getAttribute("TAMINO_COLLECTION");
        String doctype = (String)this.session.getAttribute("DOCTYPE");
        String taminoUrl = (String)this.session.getAttribute("TAMINO_URL");
        while (fileIterator.hasNext()) {
            File aFile = fileIterator.next();
            if (!aFile.isDirectory() || !ConfigContainer.isWebAppDir(aFile)) continue;
            ConfigContainer configuration = new ConfigContainer(aFile);
            this.debugLogger.println("Collection: " + configuration.getTaminoCollection() + " | " + taminoCollection);
            this.debugLogger.println("Doctype: " + configuration.getSchemaRoot() + " | " + doctype);
            this.debugLogger.println("URL: " + configuration.getTaminoURL() + " | " + taminoUrl);
            this.debugLogger.println("--------------------------------------------------------");
            if (!configuration.getTaminoCollection().equals(taminoCollection) || !configuration.getSchemaRoot().equals(doctype) || !configuration.getTaminoURL().equals(taminoUrl)) continue;
            startAppList.add(aFile.getName());
        }
        return startAppList;
    }

    private void showApps(ArrayList nameList) throws IOException {
        if (nameList.isEmpty()) {
            this.out.write("<font color=red> No hits! Please check parameters!</font><br>");
        } else {
            String name = "";
            Iterator it = ((AbstractList)nameList).iterator();
            while (it.hasNext()) {
                name = (String)it.next();
                this.out.write("<INPUT TYPE=radio NAME=App2Start VALUE=" + name);
                if (!it.hasNext()) continue;
                this.out.write("> <b>" + name + "</b><BR>");
            }
            this.out.write(" CHECKED> <b>" + name + "</b><BR>");
            this.out.write("Please select an application.");
            this.out.flush();
        }
    }

    private void showStartApplicationButton() throws IOException {
        if (!this.appNameList.isEmpty()) {
            String targetDir = (String)this.session.getAttribute("TARGET_DIR");
            int index = targetDir.lastIndexOf(File.separator);
            if (index != -1 && index + 1 <= targetDir.length()) {
                String webAppName = targetDir.substring(index + 1);
                String requestURL = HttpUtils.getRequestURL((HttpServletRequest)this.request).toString();
                int endOfRequestURL = requestURL.indexOf(58, 8);
                if (endOfRequestURL != -1) {
                    String shortRequestURL = requestURL.substring(0, endOfRequestURL);
                    this.debugLogger.println("The short request URL: " + shortRequestURL);
                    this.out.write("<input type=\"button\" value=\"Start Application\" onClick=\"window.open('" + shortRequestURL + ":8081/'+getApp2Start()+'/search.jsp')\">");
                }
            }
            this.out.flush();
        }
    }
}

