/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.common;

import com.softwareag.xtools.xapplication.common.ExceptionWrapper;
import java.io.PrintStream;
import java.io.PrintWriter;

public class WrappedExceptionProcessing {
    public static Throwable getInnermostException(Throwable exception) {
        Throwable lastEx = exception;
        while (exception != null && exception instanceof ExceptionWrapper) {
            lastEx = exception;
            exception = ((ExceptionWrapper)((Object)exception)).getNestedException();
        }
        return exception != null ? exception : lastEx;
    }

    public static void printStackTrace(PrintStream s, Exception exw) {
        s.println(WrappedExceptionProcessing.getMessageHeader(exw));
        Throwable innerExc = WrappedExceptionProcessing.getInnermostException(exw);
        if (!(innerExc instanceof ExceptionWrapper)) {
            innerExc.printStackTrace(s);
        } else {
            ((ExceptionWrapper)((Object)innerExc)).printTopLevelStackTrace(s);
        }
    }

    public static void printStackTrace(PrintWriter s, Exception exw) {
        s.println(WrappedExceptionProcessing.getMessageHeader(exw));
        Throwable innerExc = WrappedExceptionProcessing.getInnermostException(exw);
        if (!(innerExc instanceof ExceptionWrapper)) {
            innerExc.printStackTrace(s);
        } else {
            ((ExceptionWrapper)((Object)innerExc)).printTopLevelStackTrace(s);
        }
    }

    public static StringBuffer collectMessages(Exception exception) {
        StringBuffer result = new StringBuffer();
        Throwable ex = exception;
        while (ex != null && ex instanceof ExceptionWrapper) {
            ExceptionWrapper ew = (ExceptionWrapper)((Object)ex);
            ew.appendTopLevelMessage(result);
            if (ew.hasNestedException()) {
                result.append("\nNestedException: ");
            }
            ex = ((ExceptionWrapper)((Object)ex)).getNestedException();
        }
        if (ex != null) {
            result.append(ex.getMessage());
        }
        return result;
    }

    private static String getMessageHeader(Exception ex) {
        StringBuffer result = new StringBuffer();
        String fullClassName = ex.getClass().getName();
        result.append(fullClassName.substring(fullClassName.lastIndexOf(46) + 1));
        result.append(": ");
        if (ex instanceof ExceptionWrapper) {
            ((ExceptionWrapper)((Object)ex)).appendTopLevelMessage(result);
        } else {
            result.append(ex.getMessage());
        }
        return result.toString();
    }
}

