/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.common;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.WrapperParserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.ProcessingInstruction;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$common$Util;

    public static String[] split(String str, char ch) {
        if (str == null) {
            throw new PreconditionViolation();
        }
        int prev = 0;
        ArrayList<String> lst = new ArrayList<String>();
        while (true) {
            int idx;
            if ((idx = str.indexOf(ch, prev)) == -1) {
                idx = str.length();
            }
            String name = str.substring(prev, idx);
            lst.add(name);
            if (idx == str.length()) {
                String[] ar = new String[lst.size()];
                lst.toArray(ar);
                return ar;
            }
            prev = idx + 1;
        }
    }

    public static List removeDuplicates(Collection coll) {
        ArrayList result = new ArrayList();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            int max = result.size();
            int i = 0;
            while (i < max) {
                if (result.get(i) == obj) break;
                ++i;
            }
            if (i != max) continue;
            result.add(obj);
        }
        return result;
    }

    public static String slurpFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("file not found: " + file);
        }
        long rawLen = file.length();
        int len = (int)rawLen;
        if ((long)len != rawLen) {
            throw new IOException("file to big: " + file);
        }
        char[] buffer = new char[len];
        FileReader src = new FileReader(file);
        if (buffer.length != src.read(buffer)) {
            throw new IOException("file truncated: " + file);
        }
        return new String(buffer);
    }

    public static void deleteRec(File targetFile) throws IOException {
        File[] files = targetFile.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                Util.deleteRec(files[i]);
                ++i;
            }
        }
        if (!targetFile.delete()) {
            throw new IOException("cannot delete file " + targetFile);
        }
    }

    public static Element stringToElement(String xml) throws JDOMException {
        return Util.inputToElement(new StringReader(xml), null);
    }

    public static Element fileToElement(File src) throws JDOMException, IOException {
        return Util.inputToElement(new FileInputStream(src));
    }

    public static Element inputToElement(Reader src) throws JDOMException {
        return Util.inputToElement(src, null);
    }

    public static Element inputToElement(Reader src, String systemId) throws JDOMException {
        Document doc = WrapperParserFactory.readXml(src, systemId);
        return doc.getRootElement();
    }

    public static Element inputToElement(InputStream src) throws JDOMException {
        return Util.inputToElement(src, null);
    }

    public static Element inputToElement(InputStream src, String systemId) throws JDOMException {
        Document doc = WrapperParserFactory.readXml(src, systemId);
        return doc.getRootElement();
    }

    public static String elementToString(Element element, String indent, boolean withNewLines) {
        StringWriter dest = new StringWriter();
        XMLOutputter outputter = indent == null && !withNewLines ? new XMLOutputter() : new XMLOutputter(indent, withNewLines);
        try {
            outputter.output(element, (Writer)dest);
            dest.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("unexpected IOException in StringWriter: " + e);
        }
        return dest.getBuffer().toString();
    }

    public static String domToString(Node node) {
        StringBuffer result = new StringBuffer();
        Util.asText(node, result, true);
        return result.toString();
    }

    private static void asText(Node node, StringBuffer str, boolean contentOnly) {
        switch (node.getNodeType()) {
            case 1: {
                int len;
                int i;
                if (!contentOnly) {
                    str.append("<" + node.getNodeName());
                    NamedNodeMap attributes = node.getAttributes();
                    i = 0;
                    len = attributes.getLength();
                    while (i < len) {
                        str.append(" ");
                        Util.asText(attributes.item(i), str, contentOnly);
                        ++i;
                    }
                    str.append(">");
                }
                NodeList children = node.getChildNodes();
                i = 0;
                len = children.getLength();
                while (i < len) {
                    Util.asText(children.item(i), str, false);
                    ++i;
                }
                if (contentOnly || node.getNodeType() != 1) break;
                str.append("</" + node.getNodeName() + ">");
                break;
            }
            case 2: {
                str.append(node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                break;
            }
            case 3: {
                str.append(node.getNodeValue());
                break;
            }
            default: {
                throw new AssertionFailed("Unsupported node " + node.getNodeType());
            }
        }
    }

    public static String elementToString(Element element) {
        return Util.elementToString(element, "  ", true);
    }

    public static String escapeXmlContent(String str) {
        if (str == null) {
            throw new PreconditionViolation("parameter 'str' must not be null");
        }
        if (str.length() == 0) {
            return "";
        }
        String OX = "<X>";
        String CX = "</X>";
        String EMPTY = "<X />";
        Element elem = null;
        try {
            elem = Util.stringToElement("<X />");
        }
        catch (JDOMException e) {
            throw new AssertionFailed("problem for document content [" + str + "] : " + e.getMessage());
        }
        elem.setText(str);
        String result = Util.elementToString(elem, "", false);
        if ("<X />".equals(result) || result.length() < "<X>".length() + "</X>".length()) {
            throw new AssertionFailed("XML string assertion failed for '" + result + "'");
        }
        if ("<X />".equals(result)) {
            return "";
        }
        if (!result.startsWith("<X>") || !result.endsWith("</X>")) {
            throw new AssertionFailed("XML string [" + result + "] has an unexpected format");
        }
        return result.substring("<X>".length(), result.length() - "</X>".length());
    }

    public static boolean equals(Element left, Element right) {
        if (!left.getName().equals(right.getName())) {
            return false;
        }
        if (!left.getNamespace().equals((Object)right.getNamespace())) {
            return false;
        }
        List leftContent = left.getMixedContent();
        List rightContent = right.getMixedContent();
        int max = leftContent.size();
        if (max != rightContent.size()) {
            return false;
        }
        int i = 0;
        while (i < max) {
            Object a = leftContent.get(i);
            Object b = leftContent.get(i);
            if (!a.getClass().equals(b.getClass())) {
                return false;
            }
            if (a instanceof Element) {
                if (!Util.equals((Element)a, (Element)b)) {
                    return false;
                }
            } else if (a instanceof String) {
                if (!a.equals(b)) {
                    return false;
                }
            } else if (a instanceof Comment) {
                if (!((Comment)a).getText().equals(((Comment)b).getText())) {
                    return false;
                }
            } else if (a instanceof ProcessingInstruction) {
                ProcessingInstruction pA = (ProcessingInstruction)a;
                ProcessingInstruction pB = (ProcessingInstruction)b;
                if (pA.getTarget() == null && pB.getTarget() != null || !pA.getTarget().equals(pB.getTarget())) {
                    return false;
                }
                if (pA.getData() == null && pB.getData() != null || !pA.getData().equals(pB.getData())) {
                    return false;
                }
            } else {
                throw new UnsupportedOperationException("content not supported: " + a.getClass());
            }
            ++i;
        }
        List attrs = left.getAttributes();
        max = attrs.size();
        if (max != right.getAttributes().size()) {
            return false;
        }
        i = 0;
        while (i < max) {
            Attribute leftAttr = (Attribute)attrs.get(i);
            Attribute rightAttr = right.getAttribute(leftAttr.getName(), leftAttr.getNamespace());
            if (rightAttr == null || !leftAttr.getValue().equals(rightAttr.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static File locateHome() {
        String location;
        String PREFIX = "cannot locate X-Application home: ";
        Class cls = class$com$softwareag$xtools$xapplication$common$Util == null ? (class$com$softwareag$xtools$xapplication$common$Util = Util.class$("com.softwareag.xtools.xapplication.common.Util")) : class$com$softwareag$xtools$xapplication$common$Util;
        String name = cls.getName().replace('.', '/') + ".class";
        URL url = cls.getResource("/" + name);
        if (url == null) {
            throw new IllegalStateException(PREFIX + "cannot locate classfile resource " + name);
        }
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            location = url.getFile();
            int idx = location.indexOf(33);
            if (idx == -1) {
                throw new IllegalStateException(PREFIX + "X-Application jar file name not found in " + location);
            }
            if (!location.startsWith("file:")) {
                throw new IllegalStateException(PREFIX + "X-Application jar file name not found in " + location);
            }
            char urlSep = (location = location.substring(5, idx)).lastIndexOf(92) > location.lastIndexOf(47) ? (char)'\\' : '/';
            if ((idx = location.lastIndexOf(urlSep)) == -1) {
                throw new IllegalStateException(PREFIX + "absolute file name expected: " + location);
            }
            location = location.substring(0, idx) + urlSep;
        } else if ("file".equals(protocol)) {
            location = url.getFile();
            if (!location.endsWith(name)) {
                throw new IllegalStateException(PREFIX + "unexpected location: " + location);
            }
            location = location.substring(0, location.length() - name.length());
        } else {
            throw new IllegalStateException(PREFIX + "procotol not supported: " + protocol);
        }
        if (location.endsWith("/debug/")) {
            location = location.substring(0, location.length() - 6);
        } else if (location.endsWith("/opt/")) {
            location = location.substring(0, location.length() - 4);
        }
        if (location.endsWith("/lib/")) {
            location = location.substring(0, location.length() - 4);
        }
        return new File(location.replace('/', File.separatorChar));
    }

    public static String escapeElementText(String content) {
        int max = content.length();
        StringBuffer sb = new StringBuffer(max + 10);
        int i = 0;
        while (i < max) {
            char c = content.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void writeAttributeValue(String value, Writer dest) throws IOException {
        dest.write(34);
        int max = value.length();
        int i = 0;
        while (i < max) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    dest.write("&lt;");
                    break;
                }
                case '>': {
                    dest.write("&gt;");
                    break;
                }
                case '\"': {
                    dest.write("&quot;");
                    break;
                }
                case '&': {
                    dest.write("&amp;");
                    break;
                }
                default: {
                    dest.write(c);
                }
            }
            ++i;
        }
        dest.write(34);
    }

    public static void writeElementText(String text, Writer dest) throws IOException {
        int max = text.length();
        int i = 0;
        while (i < max) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    dest.write("&lt;");
                    break;
                }
                case '>': {
                    dest.write("&gt;");
                    break;
                }
                case '&': {
                    dest.write("&amp;");
                    break;
                }
                default: {
                    dest.write(c);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

