/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.ElementNode;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocumentState;
import com.softwareag.xtools.xapplication.businessdocument.state.Created;
import com.softwareag.xtools.xapplication.businessdocument.state.Read;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.store.Store;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.Timestamp;
import com.softwareag.xtools.xapplication.store.UpdateAssertionFailed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;

public class SingleBusinessDocument
implements BusinessDocument {
    private Element tree;
    protected SingleBusinessDocumentState state;
    protected Store store;
    private Map content;
    private Map nodeMap;
    private Schema schema;
    public Timestamp lastModified;

    private SingleBusinessDocument(Element tree, Store store, Schema schema, boolean created) {
        if (tree == null) {
            throw new PreconditionViolation("tree element must be defined");
        }
        this.store = store;
        this.content = new HashMap();
        this.nodeMap = new HashMap();
        this.schema = schema;
        this.lastModified = new Timestamp();
        this.setDomTree(tree);
        this.state = created ? new Created(this) : new Read(this);
    }

    public SingleBusinessDocument(Element tree, Store store, Schema schema) {
        this(tree, store, schema, true);
        if (store != null && store.getId(tree) != null) {
            throw new PreconditionViolation("document tree has already an id: " + store.getId(tree));
        }
    }

    public SingleBusinessDocument(Element tree, Store store, Schema schema, Timestamp ts) {
        this(tree, store, schema, false);
        if (ts.isValid()) {
            this.lastModified.setTime(ts.getTime());
        }
    }

    public int getState() {
        return this.state.getState();
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isReadAble() {
        int s = this.getState();
        return s != 4;
    }

    public boolean isWriteAble() {
        int s = this.getState();
        return s == 0 || s == 2;
    }

    public void read() throws BusinessDocumentStateException, StoreException {
        if (this.store == null) {
            throw new PreconditionViolation("cannot read: no store");
        }
        this.state.read();
    }

    public void modify() throws BusinessDocumentStateException {
        this.state.modify();
    }

    public void delete() throws BusinessDocumentStateException {
        this.state.delete();
    }

    public void commit() throws BusinessDocumentStateException, StoreException {
        if (this.store == null) {
            throw new PreconditionViolation("cannot commit: no store associated");
        }
        this.state.commit();
    }

    public void abandon() throws BusinessDocumentStateException {
        this.state.abandon();
    }

    public void map(String name, BusinessNode businessNode) {
        this.content.put(name, businessNode);
    }

    public void unmap(String name) {
        this.content.remove(name);
    }

    public BusinessNode lookup(String name) {
        return (BusinessNode)this.content.get(name);
    }

    public BusinessNode getRoot() {
        if (!this.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.state + "' does not allow read access");
        }
        return this.getElementNode(this.tree);
    }

    public BusinessNode getDescendant(String path) throws InvalidXPathException {
        if (!this.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.state + "' does not allow read access");
        }
        if (path == null) {
            throw new PreconditionViolation("parameter 'path' must not be null");
        }
        return this.getElementNode(this.tree).getDescendant(path);
    }

    public String getDocumentId() {
        if (this.getState() == 0) {
            return null;
        }
        return this.store.getIdQuery(this.tree);
    }

    public String getId() {
        if (this.getState() == 0) {
            return null;
        }
        return this.store.getId(this.tree);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof SingleBusinessDocument)) {
            return false;
        }
        SingleBusinessDocument other = (SingleBusinessDocument)ob;
        return SingleBusinessDocument.equals(this.tree, other.tree);
    }

    private static boolean equals(Element left, Element right) {
        if (!left.getName().equals(right.getName())) {
            return false;
        }
        if (!left.getNamespace().equals((Object)right.getNamespace())) {
            return false;
        }
        if (!SingleBusinessDocument.equalsElements(left.getChildren(), right.getChildren())) {
            return false;
        }
        if (!SingleBusinessDocument.containsAttributes(left.getAttributes(), right.getAttributes())) {
            return false;
        }
        return SingleBusinessDocument.containsAttributes(right.getAttributes(), left.getAttributes());
    }

    private static boolean equals(Attribute left, Attribute right) {
        return left.getName().equals(right.getName()) && left.getValue().equals(right.getValue()) && left.getNamespace().equals((Object)right.getNamespace());
    }

    private static boolean equalsElements(List lefts, List rights) {
        if (lefts == null) {
            throw new PreconditionViolation("list parameter 'lefts' must not be null");
        }
        if (rights == null) {
            throw new PreconditionViolation("list parameter 'rights' must not be null");
        }
        if (lefts.size() != rights.size()) {
            return false;
        }
        int i = 0;
        while (i < lefts.size()) {
            if (!SingleBusinessDocument.equals((Element)lefts.get(i), (Element)rights.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean containsAttributes(List all, List parts) {
        if (parts.size() > all.size()) {
            return false;
        }
        int i = 0;
        while (i < parts.size()) {
            Attribute part = (Attribute)parts.get(i);
            int j = 0;
            while (j < all.size()) {
                if (SingleBusinessDocument.equals(part, (Attribute)all.get(j))) break;
                ++j;
            }
            if (j == all.size()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void mapElementNode(ElementNode node) {
        if (node == null) {
            throw new PreconditionViolation("node must be defined");
        }
        if (this.nodeMap.containsKey(node.domNode)) {
            throw new PreconditionViolation("node was registered twice");
        }
        if (node.getDocument() != this) {
            throw new PreconditionViolation("node is not from this document");
        }
        this.nodeMap.put(node.domNode, node);
    }

    protected ElementNode getElementNode(Element key) {
        return (ElementNode)this.nodeMap.get(key);
    }

    protected BusinessNode unmapElementNode(Element node) {
        return (BusinessNode)this.nodeMap.remove(node);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setDomTree(Element domTree) {
        if (domTree == null) {
            throw new PreconditionViolation("parameter 'domTree' must not be null");
        }
        Element type = this.schema == null ? null : this.schema.lookupElement(domTree.getName());
        ElementNode rootElement = this.getElementNode(this.tree);
        if (this.tree != null && rootElement == null) {
            throw new AssertionFailed("root element not registered");
        }
        ArrayList all = new ArrayList();
        Iterator<Object> iter = this.nodeMap.values().iterator();
        while (iter.hasNext()) {
            all.add(iter.next());
        }
        iter = all.iterator();
        while (iter.hasNext()) {
            BusinessNodeImpl node = (BusinessNodeImpl)iter.next();
            SingleBusinessDocument.recursiveDeactivate(node);
        }
        this.nodeMap.clear();
        this.content.clear();
        if (this.tree != null) {
            this.tree.removeChildren();
            List childList = domTree.getChildren();
            int i = 0;
            int size = childList.size();
            while (i < size) {
                Element child = (Element)childList.get(i);
                domTree.removeContent(child);
                this.tree.addContent(child);
                ++i;
            }
            List attrList = domTree.getAttributes();
            int i2 = 0;
            int size2 = attrList.size();
            while (i2 < size2) {
                Attribute attr = (Attribute)attrList.get(i2);
                this.tree.removeAttribute(attr.getName(), attr.getNamespace());
                domTree.removeAttribute(attr.getName(), attr.getNamespace());
                this.tree.addAttribute(attr);
                ++i2;
            }
        } else {
            this.tree = domTree;
        }
        rootElement = new ElementNode(type, this.tree, this);
        if (rootElement != this.getElementNode(this.tree)) {
            throw new AssertionFailed("Creating a new element node without registration");
        }
    }

    private static void recursiveDeactivate(BusinessNodeImpl node) {
        if (node.isActive()) {
            int max = node.getUncheckedChildCount();
            int i = 0;
            while (i < max) {
                SingleBusinessDocument.recursiveDeactivate((BusinessNodeImpl)node.getChild(i));
                ++i;
            }
            node.deactivate();
        }
    }

    public Element getDomTree() {
        return this.getDomTree(true);
    }

    public Element getDomTree(boolean cloned) {
        return cloned ? (Element)this.tree.clone() : this.tree;
    }

    public boolean hasDomTree(Element ele) {
        return this.tree == ele;
    }

    public void rereadDocument() throws StoreException {
        Element dummy = this.store.read(this.getDocumentId(), this.lastModified);
        this.setDomTree(dummy);
        this.check();
    }

    public void validateModified() throws StoreException {
        if (!this.lastModified.isValid()) {
            try {
                Element dummy = this.store.read(this.getDocumentId(), this.lastModified);
                if (!Util.equals(dummy, this.tree)) {
                    this.lastModified.setTime("someTimeThatsNeverMatched");
                }
            }
            catch (StoreException e) {
                System.err.println("Could not access the document '" + this.getDocumentId() + "' for timestamp information");
                System.err.println("\t... use a default timestamp to prevent the commit of the document");
                e.printStackTrace();
                this.lastModified.setTime("someTimeThatsNeverMatched");
            }
        }
    }

    public void updateDocument() throws StoreException {
        try {
            this.store.update(this.tree.getName(), this.tree, this.lastModified);
        }
        catch (UpdateAssertionFailed e) {
            boolean updated = false;
            try {
                Thread.sleep(1000L);
                this.store.update(this.tree.getName(), this.tree, this.lastModified);
                updated = true;
            }
            catch (InterruptedException ie) {
                throw new AssertionFailed("unexpected interuption of sleep method: " + ie.getMessage());
            }
        }
    }

    public void deleteDocument() throws StoreException {
        this.store.delete(this.tree.getName(), this.tree, this.lastModified);
        ((BusinessNodeImpl)this.getRoot()).delete();
    }

    public void insertDocument() throws StoreException {
        this.store.insert(this.tree.getName(), this.tree, this.lastModified);
    }

    public String toString() {
        return Util.elementToString(this.tree);
    }

    public void check() {
        BusinessNodeImpl element;
        HashSet done = new HashSet();
        if (((ElementNode)this.getRoot()).domNode != this.tree) {
            throw new AssertionFailed("structure document tree differs from dom document tree");
        }
        Iterator iter = this.nodeMap.keySet().iterator();
        while (iter.hasNext()) {
            element = (BusinessNodeImpl)this.nodeMap.get(iter.next());
            if (done.contains(element)) continue;
            this.checkElement(element, done);
        }
        iter = this.content.keySet().iterator();
        while (iter.hasNext()) {
            element = (BusinessNodeImpl)this.content.get(iter.next());
            if (done.contains(element)) continue;
            this.checkElement(element, done);
        }
        if (!done.contains(this.getRoot())) {
            throw new AssertionFailed("root element not in nodeMap");
        }
    }

    private void checkElement(BusinessNodeImpl structElement, Set done) {
        int i;
        int max;
        if (structElement.getDocument() != this) {
            throw new AssertionFailed("wrong document");
        }
        if (structElement instanceof ElementNode) {
            done.add(structElement);
            Element domElement = ((ElementNode)structElement).domNode;
            if (this.nodeMap.get(domElement) != structElement) {
                throw new AssertionFailed("element node not in nodeMap: " + Util.elementToString(domElement));
            }
            if (structElement.isExpanded()) {
                List domChildren = domElement.getChildren();
                ArrayList structChildren = new ArrayList();
                SingleBusinessDocument.listStructChildren(structElement, structChildren);
                if (domElement != structElement.getParentDomElement()) {
                    throw new AssertionFailed("wrong parentDom");
                }
                max = domChildren.size();
                if (max != structChildren.size()) {
                    throw new AssertionFailed(domChildren + " != " + structChildren);
                }
                i = 0;
                while (i < max) {
                    if (domChildren.get(i) != structChildren.get(i)) {
                        throw new AssertionFailed("idx " + i + ":" + domChildren.get(i) + " != " + structChildren.get(i));
                    }
                    ++i;
                }
            }
        }
        if (structElement.isExpanded()) {
            max = structElement.getChildCount();
            i = 0;
            while (i < max) {
                this.checkElement(structElement.getChildImpl(i), done);
                ++i;
            }
        }
    }

    private static void listStructChildren(BusinessNodeImpl strucElement, List result) {
        int max = strucElement.getChildCount();
        int i = 0;
        while (i < max) {
            BusinessNodeImpl element = strucElement.getChildImpl(i);
            if (element instanceof ElementNode) {
                result.add(((ElementNode)element).domNode);
            } else {
                SingleBusinessDocument.listStructChildren(element, result);
            }
            ++i;
        }
    }

    public static void commitAll(List documents) throws StoreException {
        SingleBusinessDocument doc;
        documents = Util.removeDuplicates(documents);
        Store store = SingleBusinessDocument.getStore(documents = SingleBusinessDocument.sortList(documents));
        if (store == null) {
            return;
        }
        ArrayList<SingleBusinessDocument> done = new ArrayList<SingleBusinessDocument>();
        store.startTransaction();
        int i = 0;
        int max = documents.size();
        while (i < max) {
            doc = (SingleBusinessDocument)documents.get(i);
            if (doc.getState() == 0 || doc.getState() == 2 || doc.getState() == 3) {
                try {
                    doc.state.quasiCommit();
                    done.add(doc);
                }
                catch (StoreException e) {
                    try {
                        SingleBusinessDocument.rollback(store, done);
                    }
                    catch (StoreException s) {
                        System.err.println("could not rollback transaction after exception " + e.getMessage());
                        e.printStackTrace();
                        throw s;
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    try {
                        SingleBusinessDocument.rollback(store, done);
                    }
                    catch (StoreException s) {
                        System.err.println("could not rollback transaction after exception " + e.getMessage());
                        e.printStackTrace();
                        throw s;
                    }
                    throw e;
                }
            }
            ++i;
        }
        i = 0;
        max = done.size();
        while (i < max) {
            doc = (SingleBusinessDocument)done.get(i);
            doc.commit();
            ++i;
        }
        store.commitTransaction();
    }

    private static void rollback(Store store, List documents) throws StoreException {
        int i = 0;
        while (i < documents.size()) {
            BusinessDocument doc = (BusinessDocument)documents.get(i);
            doc.abandon();
            ++i;
        }
        store.rollbackTransaction();
    }

    private static List sortList(List documents) {
        int size = documents.size();
        ArrayList<BusinessDocument> result = new ArrayList<BusinessDocument>(size);
        int i = 0;
        while (i < size) {
            BusinessDocument doc = (BusinessDocument)documents.get(i);
            if (doc.getState() == 0) {
                result.add(0, doc);
            } else {
                result.add(doc);
            }
            ++i;
        }
        return result;
    }

    private static Store getStore(List documents) throws PreconditionViolation {
        if (documents.size() == 0) {
            return null;
        }
        Store store = ((BusinessDocument)documents.get(0)).getStore();
        int i = 1;
        while (i < documents.size()) {
            if (store != ((BusinessDocument)documents.get(i)).getStore()) {
                throw new PreconditionViolation("documents passed to commitAll use different stores");
            }
            ++i;
        }
        return store;
    }
}

