/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.List;
import org.jdom.Element;

public class SequenceNode
extends BusinessNodeImpl {
    public SequenceNode(Element type, SingleBusinessDocument doc, List body) {
        super(type, doc, body);
        if (type != null && !type.getName().equals("sequence")) {
            throw new PreconditionViolation("type: sequence element expected");
        }
    }

    public BusinessNode getChild(String tag) {
        if (tag == null) {
            throw new PreconditionViolation("the parameter 'tag' must be defined");
        }
        int index = Schema.getElementIndex(this.getType(), tag);
        return this.getChild(index);
    }

    protected Element getFirstDomElement() {
        int max = this.getChildCount();
        int i = 0;
        while (i < max) {
            Element result = this.getChildImpl(i).getFirstDomElement();
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected Element getLastDomElement() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            Element result = this.getChildImpl(i).getLastDomElement();
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    protected Element getParentDomElement() {
        return this.getParentImpl().getParentDomElement();
    }

    public String getPath() {
        BusinessNodeImpl parentElement = this.getParentImpl();
        if (parentElement == null) {
            throw new AssertionFailed("parent must be defined");
        }
        int index = parentElement.getChildImplClassIndex(this);
        if (index < 0) {
            throw new AssertionFailed("current occurrence node is not a child of its parent");
        }
        String result = parentElement.getPath() + "/xapp:seq(" + (index + 1) + ")";
        return result;
    }
}

