/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.util.ArrayList;
import java.util.List;

public class SchemaCache {
    private final TaminoStore store;
    private final List schemas;

    public SchemaCache(TaminoStore store) {
        this.store = store;
        this.schemas = new ArrayList();
    }

    public synchronized Schema lookup(String doctype) throws StoreException {
        Schema schema = this.lookupLocal(doctype);
        if (schema == null) {
            schema = Schema.read(this.store, doctype, false);
            if (schema == null) {
                throw new StoreException("the schema for doctype '" + doctype + "' could not be found");
            }
            this.schemas.add(schema);
        }
        return schema;
    }

    public synchronized Schema lookupLocal(String doctype) {
        int i = 0;
        int max = this.schemas.size();
        while (i < max) {
            Schema schema = (Schema)this.schemas.get(i);
            if (schema.lookupElement(doctype) != null) {
                return schema;
            }
            ++i;
        }
        return null;
    }
}

