/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;

public class Schema
implements TSDConstants {
    public static final Namespace XS_NS = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
    public static final Namespace TSD_NS = Namespace.getNamespace((String)"tsd", (String)"http://namespaces.softwareag.com/tamino/TaminoSchemaDefinition");
    private Map map;
    private Element schema;

    public static Schema read(TaminoStore store, String doctype, boolean withAnnotations) throws StoreException, InvalidSchemaException {
        Element schema = store.readTsd(doctype);
        if (schema == null) {
            throw new InvalidSchemaException("no such schema: " + doctype);
        }
        return new Schema(schema, withAnnotations);
    }

    public static Schema read(String filename, boolean withAnnotations) throws InvalidSchemaException, IOException {
        return new Schema(Util.slurpFile(new File(filename)), withAnnotations);
    }

    public Element getRoot() {
        return this.schema;
    }

    public void define(TaminoStore store, String collection, PrintStream progress) throws StoreException {
        this.setCollection(collection);
        Element rawSchema = Schema.normalize(Namespace.NO_NAMESPACE, XS_NS, TSD_NS, TSD_NS, this.schema);
        store.define(collection, rawSchema, this.getDoctypes(), progress);
    }

    public String[] getDoctypes() {
        ArrayList<String> result = new ArrayList<String>();
        Element element = this.getSchemaInfo();
        List children = element.getChildren("doctype", TSD_NS);
        int max = children.size();
        int i = 0;
        while (i < max) {
            element = (Element)children.get(i);
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new InvalidSchemaException("missing doctype/@name");
            }
            result.add(name);
            ++i;
        }
        String[] ar = new String[result.size()];
        result.toArray(ar);
        return ar;
    }

    private Element getSchemaInfo() {
        Element element = this.schema.getChild("annotation");
        if (element == null) {
            throw new InvalidSchemaException("missing annotation:" + Util.elementToString(this.schema));
        }
        if ((element = element.getChild("appinfo")) == null) {
            throw new InvalidSchemaException("missing appinfo:" + Util.elementToString(this.schema));
        }
        if ((element = element.getChild("schemaInfo", TSD_NS)) == null) {
            throw new InvalidSchemaException("missing schemaInfo:" + Util.elementToString(this.schema));
        }
        return element;
    }

    private void setCollection(String collection) {
        Element element = this.getSchemaInfo();
        if ((element = element.getChild("collection", TSD_NS)) == null) {
            throw new InvalidSchemaException("missing collection");
        }
        Attribute attribute = element.getAttribute("name");
        if (attribute == null) {
            throw new InvalidSchemaException("missing name attribute");
        }
        attribute.setValue(collection);
    }

    public Schema(String schema, boolean withAnnotations) throws InvalidSchemaException {
        this(Schema.toJDOMcatch(schema), withAnnotations);
    }

    private static Element toJDOMcatch(String xml) throws InvalidSchemaException {
        try {
            return Util.stringToElement(xml);
        }
        catch (JDOMException e) {
            throw new InvalidSchemaException("" + e.getMessage());
        }
    }

    public Schema(Element rawSchema, boolean withAnnotations) throws InvalidSchemaException {
        if (!withAnnotations) {
            Schema.removeAnnotations(rawSchema);
        }
        this.schema = Schema.normalize(rawSchema.getNamespace(), Namespace.NO_NAMESPACE, TSD_NS, TSD_NS, rawSchema);
        this.map = new HashMap();
        if (!this.schema.getName().equals("schema")) {
            throw new InvalidSchemaException("schema element expected, found " + this.schema.getName());
        }
        this.addElementDecls(this.schema);
    }

    private void addElementDecls(Element child) throws InvalidSchemaException {
        if (child.getName().equals("element") && child.getAttributeValue("ref") == null) {
            String name = child.getAttributeValue("name");
            if (name == null) {
                throw new InvalidSchemaException("missing name attribute: " + child);
            }
            if (this.map.get(name) != null) {
                throw new InvalidSchemaException("duplicate element decl: " + name);
            }
            this.map.put(name, child);
        }
        List children = child.getChildren();
        int i = 0;
        int max = children.size();
        while (i < max) {
            this.addElementDecls((Element)children.get(i));
            ++i;
        }
    }

    private static Element normalize(Namespace srcXsdNS, Namespace destXsdNS, Namespace srcTsdNS, Namespace destTsdNS, Element element) throws InvalidSchemaException {
        Namespace normalizedNS;
        Namespace elementNS = element.getNamespace();
        if (elementNS.equals((Object)srcXsdNS)) {
            normalizedNS = destXsdNS;
        } else if (elementNS.equals((Object)srcTsdNS)) {
            normalizedNS = destTsdNS;
        } else {
            throw new InvalidSchemaException("unexpected namespace. Found: " + element.getNamespace() + ". Expected " + srcXsdNS);
        }
        Element result = new Element(element.getName(), normalizedNS);
        List content = element.getMixedContent();
        int i = 0;
        int max = content.size();
        while (i < max) {
            Object child = content.get(i);
            if (child instanceof Element) {
                result.addContent(Schema.normalize(srcXsdNS, destXsdNS, srcTsdNS, destTsdNS, (Element)child));
            } else if (child instanceof String) {
                result.addContent((String)child);
            } else if (!(child instanceof Comment) && !(child instanceof ProcessingInstruction)) {
                if (child instanceof CDATA) {
                    throw new InvalidSchemaException("unexpected CDATA section: " + child);
                }
                throw new AssertionFailed("unkown content type: " + child);
            }
            ++i;
        }
        List attributes = element.getAttributes();
        int i2 = 0;
        int max2 = attributes.size();
        while (i2 < max2) {
            Attribute a = (Attribute)attributes.get(i2);
            Namespace attributeNS = a.getNamespace();
            if (attributeNS.equals((Object)Namespace.NO_NAMESPACE) || attributeNS.equals((Object)srcXsdNS) || attributeNS.equals((Object)srcTsdNS)) {
                result.addAttribute(new Attribute(a.getName(), a.getValue(), Namespace.NO_NAMESPACE));
            } else if (attributeNS.getPrefix().equals("ino")) {
                if (!a.getName().equals("id") && !a.getName().equals("docname")) {
                    throw new InvalidSchemaException("unkown attribute: " + a);
                }
            } else {
                throw new InvalidSchemaException("unexpected namespace for attribute: " + attributeNS);
            }
            ++i2;
        }
        return result;
    }

    public Element lookupElement(String name) {
        return (Element)this.map.get(name);
    }

    public Element lookupElement(String name, Element parentContext) {
        if (parentContext == null) {
            throw new PreconditionViolation("element parameter 'parentContext' must not be null");
        }
        if (parentContext.getChild("complexType") == null) {
            throw new PreconditionViolation("parent type node '" + parentContext.getName() + "' must be complex type");
        }
        ArrayList pathList = new ArrayList();
        Element child = Schema.getChild(name, parentContext.getChild("complexType"), pathList);
        if (child != null) {
            if (child.getAttribute("ref") != null) {
                return this.lookupElement(name);
            }
            if (child.getAttribute("name") == null) {
                throw new AssertionFailed("neither 'name' nor 'ref' attribute defined for element type '" + child.getName() + "'");
            }
        }
        return child;
    }

    public Element lookupContentType(String name) throws PreconditionViolation {
        Element element = this.lookupElement(name);
        if (element == null) {
            throw new PreconditionViolation("element not found: " + name);
        }
        return Schema.getContentType(element);
    }

    public static Element getContentType(Element element) throws InvalidSchemaException {
        Element child = element.getChild("complexType");
        if (child == null) {
            child = element.getChild("simpleType");
            if (child == null) {
                String name = element.getAttributeValue("type");
                if (name == null) {
                    throw new InvalidSchemaException("element '" + Schema.getElementName(element) + "' has an unsupported type definition");
                }
                child = new Element("simpleType");
                child.addAttribute("name", name);
                return child;
            }
            return child;
        }
        element = child;
        if ((child = element.getChild("simpleContent")) != null) {
            child = new Element("simpleType");
            child.addAttribute("name", "string");
            return child;
        }
        child = element.getChild("sequence");
        if (child != null) {
            return child;
        }
        child = element.getChild("choice");
        if (child != null) {
            return child;
        }
        return null;
    }

    public static boolean matchesType(Element left, Element right) {
        if (left == right) {
            return true;
        }
        if (!left.getName().equals("element")) {
            return false;
        }
        if (!right.getName().equals("element")) {
            return false;
        }
        String name = left.getAttributeValue("name");
        if (name == null) {
            name = right.getAttributeValue("name");
            if (name == null) {
                return false;
            }
            right = left;
        }
        String ref = right.getAttributeValue("ref");
        return name.equals(ref);
    }

    public static int getMinOccurs(Element element) throws InvalidSchemaException {
        String str = element.getAttributeValue("minOccurs");
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new InvalidSchemaException("invalid value for minOccurs: " + str);
            }
        }
        return 1;
    }

    public static int getMaxOccurs(Element element) throws InvalidSchemaException {
        String str = element.getAttributeValue("maxOccurs");
        if (str != null) {
            if (str.equals("unbounded")) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new InvalidSchemaException("invalid value for maxOccurs: " + str);
            }
        }
        return 1;
    }

    public Element getChildType(String kind, int index, Element type, List typePath) {
        String typeName;
        Element result = null;
        if ("element".equals(type.getName())) {
            String ref = type.getAttributeValue("ref");
            if (ref != null) {
                type = this.lookupElement(ref);
            }
            if ((type = type.getChild("complexType")) == null) {
                return null;
            }
        }
        if (!("complexType".equals(typeName = type.getName()) || "sequence".equals(typeName) || "choice".equals(typeName))) {
            return null;
        }
        if ("seq".equals(kind)) {
            List children = type.getChildren();
            int i = 0;
            while (i < children.size()) {
                Element child = (Element)children.get(i);
                if ("sequence".equals(child.getName()) && !Schema.isOccurrence(child) && --index <= 0) {
                    typePath.add(new Integer(i));
                    result = child;
                    break;
                }
                ++i;
            }
        } else if ("chc".equals(kind)) {
            List children = type.getChildren();
            int i = 0;
            while (i < children.size()) {
                Element child = (Element)children.get(i);
                if ("choice".equals(child.getName()) && !Schema.isOccurrence(child) && --index <= 0) {
                    typePath.add(new Integer(i));
                    result = child;
                    break;
                }
                ++i;
            }
        } else if ("child".equals(kind)) {
            typePath.add(new Integer(index));
            List children = type.getChildren();
            result = (Element)children.get(index);
        } else if ("occ".equals(kind)) {
            List children = type.getChildren();
            int i = 0;
            while (i < children.size()) {
                Element child = (Element)children.get(i);
                if (Schema.isOccurrence(child) && --index <= 0) {
                    typePath.add(new Integer(i));
                    result = child;
                    break;
                }
                ++i;
            }
        } else {
            throw new PreconditionViolation("the function '" + kind + "' for path expressions is not supported");
        }
        return result;
    }

    public Element getChild(String childName, int index, Element type, boolean isAttribute, List typePath) {
        if (childName == null) {
            throw new PreconditionViolation("name of the child must be defined");
        }
        if (type == null) {
            throw new PreconditionViolation("type must be defined");
        }
        if (typePath == null) {
            throw new PreconditionViolation("list for the type nodes must be defined");
        }
        if ("element".equals(type.getName())) {
            String elementName = Schema.getElementName(type);
            if (childName.equals(elementName) && Schema.isOccurrence(type)) {
                typePath.add(new Integer(index));
                return type;
            }
            if (type.getAttribute("ref") != null) {
                type = this.lookupElement(elementName);
            } else if (type.getAttribute("name") == null) {
                throw new AssertionFailed("neither 'name' nor 'ref' attribute defined for element " + type);
            }
            type = type.getChild("complexType");
            if (type != null) {
                Element typeContent = type.getChild("simpleContent");
                if (typeContent != null) {
                    typeContent = typeContent.getChild("extension");
                }
                if (typeContent != null) {
                    type = typeContent;
                }
            }
        }
        if (type != null) {
            List children = type.getChildren();
            int i = 0;
            int len = children.size();
            while (i < len) {
                Attribute attr;
                Element result;
                Element child = (Element)children.get(i);
                String childType = child.getName();
                if (!isAttribute && "element".equals(childType) && childName.equals(Schema.getElementName(child))) {
                    typePath.add(new Integer(i));
                    if (Schema.isOccurrence(child)) {
                        return this.getChild(childName, index, child, isAttribute, typePath);
                    }
                    return child;
                }
                if (!isAttribute && "sequence".equals(childType)) {
                    int lastIndex = typePath.isEmpty() ? 0 : typePath.size() - 1;
                    result = this.getChild(childName, index, child, isAttribute, typePath);
                    if (result != null) {
                        if (Schema.getMaxOccurs(child) == 1) {
                            typePath.add(lastIndex, new Integer(i));
                            if (Schema.getMinOccurs(child) < 1) {
                                typePath.add(lastIndex + 1, new Integer(0));
                            }
                            return result;
                        }
                        return null;
                    }
                } else if (!isAttribute && "choice".equals(childType)) {
                    int lastIndex = typePath.isEmpty() ? 0 : typePath.size() - 1;
                    result = this.getChild(childName, index, child, isAttribute, typePath);
                    if (result != null) {
                        if (Schema.getMaxOccurs(child) == 1) {
                            typePath.add(lastIndex, new Integer(i));
                            if (Schema.getMinOccurs(child) < 1) {
                                typePath.add(lastIndex + 1, new Integer(0));
                            }
                            return result;
                        }
                        return null;
                    }
                } else if (isAttribute && "attribute".equals(childType) && (attr = child.getAttribute("name")) != null && attr.getValue().equals(childName)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isOptional(Element type) throws InvalidSchemaException {
        boolean result;
        if ("attribute".equals(type.getName())) {
            String useValue = type.getAttributeValue("use");
            result = useValue == null || "optional".equals(useValue);
        } else {
            int minOcc = Schema.getMinOccurs(type);
            int maxOcc = Schema.getMaxOccurs(type);
            result = minOcc == 0 && maxOcc == 1;
        }
        return result;
    }

    public static boolean isOccurrence(Element type) throws InvalidSchemaException {
        return Schema.getMinOccurs(type) != 1 || Schema.getMaxOccurs(type) != 1;
    }

    public static Element getChild(String childName, Element complexType, List typePath) {
        Element child;
        int len;
        if (childName == null) {
            throw new PreconditionViolation("string parameter 'childName' must be defined");
        }
        if (complexType == null) {
            throw new PreconditionViolation("element parameter 'complexType' must be defined");
        }
        if (typePath == null) {
            throw new PreconditionViolation("list parameter 'typePath' must be defined");
        }
        Element result = null;
        int lastIndex = typePath.size();
        List children = complexType.getChildren("element", complexType.getNamespace());
        int childIndex = 0;
        int len2 = children.size();
        while (childIndex < len2) {
            Element child2 = (Element)children.get(childIndex);
            if (childName.equals(Schema.getElementName(child2))) {
                result = child2;
                typePath.add(lastIndex, new Integer(childIndex));
                typePath.add(lastIndex + 1, child2);
                break;
            }
            ++childIndex;
        }
        if (result == null) {
            children = complexType.getChildren("sequence", complexType.getNamespace());
            int childIndex2 = 0;
            len = children.size();
            while (childIndex2 < len) {
                child = (Element)children.get(childIndex2);
                result = Schema.getChild(childName, child, typePath);
                if (result != null) {
                    typePath.add(lastIndex, new Integer(childIndex2));
                    typePath.add(lastIndex + 1, child);
                    break;
                }
                ++childIndex2;
            }
        }
        if (result == null) {
            children = complexType.getChildren("choice", complexType.getNamespace());
            int childIndex3 = 0;
            len = children.size();
            while (childIndex3 < len) {
                child = (Element)children.get(childIndex3);
                result = Schema.getChild(childName, child, typePath);
                if (result != null) {
                    typePath.add(lastIndex, new Integer(childIndex3));
                    typePath.add(lastIndex + 1, child);
                    break;
                }
                ++childIndex3;
            }
        }
        if (result != null && !childName.equals(Schema.getElementName(result))) {
            throw new AssertionFailed("result must be an element node with reference or name");
        }
        return result;
    }

    public static List getAttributeDefinitions(Element elemDecl) throws InvalidSchemaException {
        Element complex = elemDecl.getChild("complexType");
        if (complex != null) {
            Element base = complex.getChild("simpleContent");
            if (base != null) {
                if ((base = base.getChild("extension")) == null) {
                    throw new InvalidSchemaException("simpleContent: missing child element 'extension':" + elemDecl);
                }
            } else {
                base = complex;
            }
            return base.getChildren("attribute");
        }
        return new ArrayList();
    }

    public static Element lookupAttributeDefinition(Element elemDecl, String name) throws InvalidSchemaException {
        List lst = Schema.getAttributeDefinitions(elemDecl);
        int i = 0;
        int max = lst.size();
        while (i < max) {
            Element def = (Element)lst.get(i);
            if (name.equals(def.getAttributeValue("name"))) {
                return def;
            }
            ++i;
        }
        return null;
    }

    public static List getIndexPathForStructureNodes(Element rootElem, List elements) {
        if (rootElem == null) {
            throw new PreconditionViolation("parameter 'rootElem' must not be null");
        }
        if (elements == null || elements.size() == 0) {
            throw new PreconditionViolation("parameter 'elements' must be a list with one element at least");
        }
        ArrayList<List> result = new ArrayList<List>();
        List elementList = Schema.getElementList(rootElem, true);
        int elemSize = elements.size();
        int elemListSize = elementList.size();
        int i = 0;
        while (i < elemListSize) {
            Element elem = (Element)elementList.get(i);
            if (Schema.getElementName(elem).equals((String)elements.get(0))) {
                Element baseElem;
                int j = 1;
                while (j < elemSize && i + j < elemListSize && Schema.getElementName((Element)elementList.get(i + j)).equals((String)elements.get(j))) {
                    ++j;
                }
                if (j == elemSize && (baseElem = Schema.getCommonElement(elem, (Element)elementList.get(i + j - 1), rootElem)) != null) {
                    result.add(Schema.getIndexList(baseElem, rootElem));
                }
            }
            ++i;
        }
        return result;
    }

    public static List getElementList(Element rootElem, boolean resolveElement) {
        if (rootElem == null) {
            throw new PreconditionViolation("parameter 'rootElem' must be defined");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        String elemType = rootElem.getName();
        if (!resolveElement && "element".equals(elemType)) {
            result.add(rootElem);
        } else {
            List children = rootElem.getChildren();
            int i = 0;
            int childSize = children.size();
            while (i < childSize) {
                Element child = (Element)children.get(i);
                result.addAll(Schema.getElementList(child, false));
                ++i;
            }
        }
        return result;
    }

    static Element getCommonElement(Element elem1, Element elem2, Element maxBase) {
        if (elem1 == null || elem2 == null) {
            throw new PreconditionViolation("both parameters 'elem1' and 'elem2' must not be null");
        }
        if (elem1 == elem2 && (Schema.isOccurrence(elem1) || elem1.getParent() != null && "choice".equals(elem1.getParent().getName()))) {
            return elem1;
        }
        List nodeList1 = Schema.getParentList(elem1, maxBase, true);
        List nodeList2 = Schema.getParentList(elem2, maxBase, false);
        int nodeListSize1 = nodeList1.size();
        int nodeListSize2 = nodeList2.size();
        if (nodeListSize1 == 0 || nodeListSize2 == 0) {
            return null;
        }
        Element refNode = (Element)nodeList1.get(0);
        int i = 0;
        while (i < nodeListSize2) {
            if (refNode == nodeList2.get(i)) {
                int j = 1;
                while (j < nodeListSize1 && i + 1 < nodeListSize2 && nodeList1.get(j) == nodeList2.get(i + 1)) {
                    refNode = (Element)nodeList1.get(j);
                    ++j;
                    ++i;
                }
                return refNode;
            }
            ++i;
        }
        refNode = (Element)nodeList2.get(0);
        int i2 = 0;
        while (i2 < nodeListSize1) {
            if (refNode == nodeList1.get(i2)) {
                int j = 1;
                while (j < nodeListSize2 && i2 + 1 < nodeListSize1 && nodeList2.get(j) == nodeList1.get(i2 + 1)) {
                    refNode = (Element)nodeList2.get(j);
                    ++j;
                    ++i2;
                }
                return refNode;
            }
            ++i2;
        }
        return null;
    }

    static List getParentList(Element elem, Element maxParent, boolean pos) {
        if (elem == null) {
            throw new PreconditionViolation("parameter 'elem' must be not null");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        Element parent = elem.getParent();
        while (parent != null) {
            int idx;
            List children = parent.getChildren();
            if (pos) {
                idx = children.indexOf(elem);
                if (idx > 0) {
                    if (!"complexType".equals(parent.getName())) break;
                    --idx;
                    while (idx >= 0 && "attribute".equals(((Element)children.get(idx)).getName())) {
                        --idx;
                    }
                    if (idx > 0) {
                        break;
                    }
                }
            } else {
                int childSize;
                idx = children.indexOf(elem);
                if (idx < (childSize = children.size()) - 1) {
                    if (!"complexType".equals(parent.getName())) break;
                    ++idx;
                    while (idx < childSize && "attribute".equals(((Element)children.get(idx)).getName())) {
                        ++idx;
                    }
                    if (idx < childSize) break;
                }
            }
            result.add(0, parent);
            if (parent == maxParent) break;
            elem = parent;
            parent = parent.getParent();
        }
        return result;
    }

    static List getIndexList(Element elem, Element maxParent) {
        if (elem == null) {
            throw new PreconditionViolation("parameter 'elem' must not be null");
        }
        if (maxParent == null) {
            throw new PreconditionViolation("parameter 'maxParent' must not be null");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (elem == maxParent) {
            return result;
        }
        Element parent = elem.getParent();
        while (parent != null) {
            if (!"complexType".equals(elem.getName())) {
                List children = parent.getChildren();
                int idx = children.indexOf(elem);
                int i = idx - 1;
                while (i >= 0) {
                    Element child = (Element)children.get(i);
                    if ("attribute".equals(child.getName())) {
                        --idx;
                    }
                    --i;
                }
                if (Schema.isOccurrence(elem)) {
                    result.add(0, new Integer(-1));
                }
                if ("choice".equals(parent.getName())) {
                    idx = (idx + 1) * -2;
                }
                result.add(0, new Integer(idx));
                if (parent == maxParent) break;
                elem = parent;
            }
            parent = parent.getParent();
        }
        return result;
    }

    public static List getPathsForStructureNodes(Element rootElem, List elements) {
        ArrayList result = new ArrayList();
        String type = rootElem.getName();
        if ("element".equals(type)) {
            Element complex = rootElem.getChild("complexType");
            if (complex == null) {
                if (elements.size() == 1 && Schema.isOccurrence(rootElem) && ((String)elements.get(0)).equals(Schema.getElementName(rootElem))) {
                    result.add(new ArrayList());
                }
                return result;
            }
            rootElem = complex;
        } else if (!"sequence".equals(type) && !"choice".equals(type)) {
            return result;
        }
        List childNodes = rootElem.getChildren();
        if (Schema.isPartOfElements(childNodes, elements.iterator())) {
            ArrayList<Integer> tmpRes = new ArrayList<Integer>();
            if ("complexType".equals(rootElem.getName())) {
                tmpRes.add(new Integer(0));
                Element child = rootElem.getChild("sequence");
                if (child == null) {
                    child = rootElem.getChild("choice");
                }
                if (child != null && Schema.isOccurrence(child)) {
                    tmpRes.add(new Integer(-1));
                }
            }
            result.add(tmpRes);
            return result;
        }
        int childSize = childNodes.size();
        int i = 0;
        while (i < childSize) {
            List tmpRes;
            Element child = (Element)childNodes.get(i);
            String childType = child.getName();
            if (("sequence".equals(childType) || "choice".equals(childType) || "element".equals(childType) && child.getChild("complexType") == null) && !(tmpRes = Schema.getPathsForStructureNodes(child, elements)).isEmpty()) {
                boolean isOcc = Schema.isOccurrence(child);
                Iterator it = tmpRes.iterator();
                while (it.hasNext()) {
                    List pathList = (List)it.next();
                    int idx = i;
                    if ("choice".equals(type)) {
                        idx = -((i + 1) * 2);
                    }
                    pathList.add(0, new Integer(idx));
                    if (!isOcc) continue;
                    pathList.add(1, new Integer(-1));
                }
                result.addAll(tmpRes);
            }
            ++i;
        }
        return result;
    }

    public static List getPathsForAlternativeNodes(Element rootElem, List elements) {
        ArrayList result = new ArrayList();
        String type = rootElem.getName();
        if ("element".equals(type)) {
            Element complex = rootElem.getChild("complexType");
            if (complex == null) {
                if (elements.size() == 1 && Schema.isOccurrence(rootElem) && ((String)elements.get(0)).equals(Schema.getElementName(rootElem))) {
                    result.add(new ArrayList());
                }
                return result;
            }
            rootElem = complex;
        } else if ("choice".equals(type)) {
            int alt = Schema.getAlternative(rootElem, elements);
            if (alt >= 0) {
                ArrayList<Integer> tmpRes = new ArrayList<Integer>();
                tmpRes.add(new Integer((alt + 1) * -2));
                result.add(tmpRes);
                return result;
            }
        } else if (!"sequence".equals(type)) {
            return result;
        }
        List childNodes = rootElem.getChildren();
        int childSize = childNodes.size();
        int i = 0;
        while (i < childSize) {
            List tmpRes;
            Element child = (Element)childNodes.get(i);
            String childType = child.getName();
            if (("sequence".equals(childType) || "choice".equals(childType) || "element".equals(childType) && child.getChild("complexType") == null) && !(tmpRes = Schema.getPathsForAlternativeNodes(child, elements)).isEmpty()) {
                boolean isOcc = Schema.isOccurrence(child);
                Iterator it = tmpRes.iterator();
                while (it.hasNext()) {
                    List pathList = (List)it.next();
                    int idx = i;
                    if ("choice".equals(type)) {
                        idx = -(i + 1) * 2;
                    }
                    pathList.add(0, new Integer(idx));
                    if (!isOcc) continue;
                    pathList.add(1, new Integer(-1));
                }
                result.addAll(tmpRes);
            }
            ++i;
        }
        return result;
    }

    public static int getAlternative(Element choiceType, List elements) {
        if (!"choice".equals(choiceType.getName())) {
            throw new PreconditionViolation("no choice type (current type = " + choiceType.getName() + ")");
        }
        List children = choiceType.getChildren();
        int childCount = children.size();
        ArrayList<Element> childList = new ArrayList<Element>();
        int i = 0;
        while (i < childCount) {
            Element child = (Element)children.get(i);
            Iterator it = elements.iterator();
            childList.clear();
            childList.add(child);
            if (Schema.isPartOfElements(childList, it)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isPartOfElements(List nodeList, Iterator elemIt) {
        boolean result = true;
        Iterator it = nodeList.iterator();
        while (it.hasNext() && result) {
            Element typeNode = (Element)it.next();
            String typeNodeStr = typeNode.getName();
            if ("element".equals(typeNodeStr)) {
                if (elemIt.hasNext()) {
                    String refElemName = (String)elemIt.next();
                    String elemName = Schema.getElementName(typeNode);
                    if (elemName != null && elemName.equals(refElemName)) continue;
                    result = false;
                    continue;
                }
                result = false;
                continue;
            }
            if (!"sequence".equals(typeNodeStr) && !"choice".equals(typeNodeStr)) continue;
            result = Schema.isPartOfElements(typeNode.getChildren(), elemIt);
        }
        return result;
    }

    public static String getElementName(Element elementTypeNode) {
        if (elementTypeNode == null) {
            throw new PreconditionViolation("parameter 'elementTypeNode' must be defined");
        }
        String result = elementTypeNode.getAttributeValue("ref");
        if (result == null) {
            result = elementTypeNode.getAttributeValue("name");
        }
        return result;
    }

    public static int getElementIndex(Element type, String elementName) {
        if (type == null) {
            throw new PreconditionViolation("parameter 'type' must be defined");
        }
        if (elementName == null) {
            throw new PreconditionViolation("parameter 'elementName' must be defined");
        }
        int result = 0;
        List childList = type.getChildren();
        Iterator it = childList.iterator();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            String childType = child.getName();
            if ("sequence".equals(childType) || "choice".equals(childType)) {
                ++result;
                continue;
            }
            if (!"element".equals(childType)) continue;
            if (elementName.equals(child.getAttributeValue("ref")) || elementName.equals(child.getAttributeValue("name"))) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    static void removeAnnotations(Element element) {
        if (!"schema".equals(element.getName()) && element.hasChildren()) {
            element.removeChildren("annotation", XS_NS);
        }
        List children = element.getChildren();
        int i = 0;
        int size = children.size();
        while (i < size) {
            Schema.removeAnnotations((Element)children.get(i));
            ++i;
        }
    }
}

