/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.common.PreconditionViolation;

public class QuerySort {
    private String xPath;
    private int sortType = 1;
    private int sortSequence = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;

    public QuerySort(String xPath) {
        this.xPath = xPath;
    }

    public QuerySort(String xPath, int sortType) {
        this(xPath);
        if (sortType != 1 && sortType != 2) {
            throw new PreconditionViolation("illegal sort type argument. can only be ASCENDING OR DESCENDING");
        }
        this.sortType = sortType;
    }

    public QuerySort(String xPath, int sortType, int sortSequence) {
        this(xPath, sortType);
        if (sortSequence < 0) {
            sortSequence = 1;
        }
        if (sortSequence > 9) {
            sortSequence = 9;
        }
        this.sortSequence = sortSequence;
    }

    public int getSequence() {
        return this.sortSequence;
    }

    public String buildQueryExpression() {
        if (this.sortType == 1) {
            return this.xPath + " ascending";
        }
        return this.xPath + " descending";
    }
}

