/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.QueryItem;

public class QueryElement
implements QueryItem {
    private String elementType = "=";
    private String dataType = "string";
    private String xPath = "";
    private String value = "";

    public QueryElement(String xPath, String value) {
        this.xPath = xPath;
        this.value = this.formatQuotesInToken(value);
    }

    public QueryElement(String xPath, String value, String elementType) {
        this(xPath, value);
        this.elementType = elementType;
    }

    public QueryElement(String xPath, String value, String elementType, String dataType) {
        this(xPath, value, elementType);
        this.dataType = dataType;
    }

    public String buildQueryExpression(String rootPath) {
        int index = 0;
        if (this.xPath.startsWith(rootPath)) {
            index = rootPath.length();
            if (this.xPath.length() > index && this.xPath.charAt(index) == '/') {
                ++index;
            }
        }
        if (this.dataType.equals("integer") || this.dataType.equals("float")) {
            return this.xPath.substring(index) + this.elementType + this.value;
        }
        return this.xPath.substring(index) + this.elementType + "'" + this.value + "'";
    }

    private String formatQuotesInToken(String token) {
        boolean count = false;
        int i = 0;
        StringBuffer stringBuffer = new StringBuffer(token);
        i = token.lastIndexOf("'");
        while (i > 0) {
            if (stringBuffer.charAt(i) == '\'') {
                stringBuffer.replace(i, i + 1, "&apos;");
            }
            --i;
        }
        token = stringBuffer.toString();
        return token;
    }
}

