/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.QueryContainer;
import com.softwareag.xtools.xapplication.businessdocument.QueryElement;
import com.softwareag.xtools.xapplication.businessdocument.QueryFilter;
import com.softwareag.xtools.xapplication.businessdocument.QueryGroup;
import com.softwareag.xtools.xapplication.businessdocument.QueryItem;
import com.softwareag.xtools.xapplication.businessdocument.QueryRange;
import com.softwareag.xtools.xapplication.businessdocument.QuerySort;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.Iterator;

public class QueryBuilder {
    private QueryContainer container;

    public QueryBuilder(QueryContainer container) {
        if (container == null) {
            throw new PreconditionViolation("container cannot be null");
        }
        this.container = container;
    }

    public String buildQueryExpression() {
        QuerySort qs;
        Object o;
        String rootPath = "/" + this.container.getDoctype();
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append(rootPath);
        boolean first = true;
        Iterator items = this.container.items();
        while (items.hasNext()) {
            Object o2 = items.next();
            if (!(o2 instanceof QueryElement) && !(o2 instanceof QueryGroup) && !(o2 instanceof QueryRange) && !(o2 instanceof QueryFilter)) continue;
            QueryItem qi = (QueryItem)o2;
            String work = qi.buildQueryExpression(rootPath);
            if (first) {
                queryBuffer.append("[");
            } else {
                queryBuffer.append(" and ");
            }
            queryBuffer.append(work);
            first = false;
        }
        if (!first) {
            queryBuffer.append("]");
        }
        first = true;
        int seq = 1;
        while (seq < 10) {
            items = this.container.items();
            while (items.hasNext()) {
                o = items.next();
                if (!(o instanceof QuerySort) || (qs = (QuerySort)o).getSequence() != seq) continue;
                if (first) {
                    queryBuffer.append(" sortby (");
                }
                queryBuffer.append(" " + qs.buildQueryExpression());
                first = false;
            }
            ++seq;
        }
        items = this.container.items();
        while (items.hasNext()) {
            o = items.next();
            if (!(o instanceof QuerySort) || (qs = (QuerySort)o).getSequence() != 0) continue;
            if (first) {
                queryBuffer.append(" sortby (");
            }
            queryBuffer.append(" " + qs.buildQueryExpression());
            first = false;
        }
        if (!first) {
            queryBuffer.append(")");
        }
        return queryBuffer.toString();
    }
}

