/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;

class PathFragment {
    private String namespacePrefix;
    private String name;
    private boolean isAttribute;
    private boolean isFunction;
    private Integer argument;

    PathFragment(String pathFragment) throws InvalidXPathException {
        int indexIdx2;
        int attrIndex;
        if (pathFragment.length() > 0 && pathFragment.charAt(0) == '@') {
            this.isAttribute = true;
            attrIndex = 0;
        } else {
            this.isAttribute = false;
            attrIndex = -1;
        }
        int namespaceIdx = pathFragment.indexOf(58, attrIndex + 1);
        if (namespaceIdx < 0) {
            this.namespacePrefix = "";
            namespaceIdx = attrIndex;
        } else {
            if (namespaceIdx == attrIndex + 1) {
                throw new InvalidXPathException("Invalid namespace for path fragment '" + pathFragment + "'");
            }
            this.namespacePrefix = pathFragment.substring(attrIndex + 1, namespaceIdx);
        }
        int indexIdx1 = pathFragment.indexOf(40, namespaceIdx + 1);
        if (indexIdx1 < 0) {
            indexIdx1 = pathFragment.length();
        }
        if ((indexIdx2 = pathFragment.indexOf(91, namespaceIdx + 1)) < 0) {
            indexIdx2 = pathFragment.length();
        }
        int indexIdx = Math.min(indexIdx1, indexIdx2);
        this.name = pathFragment.substring(namespaceIdx + 1, indexIdx);
        if (indexIdx >= 0 && indexIdx < pathFragment.length()) {
            int endIndex;
            if (indexIdx == indexIdx1) {
                this.isFunction = true;
                endIndex = pathFragment.indexOf(41, indexIdx);
                if (endIndex < 0) {
                    throw new InvalidXPathException("Invalid function for path fragment " + pathFragment + " - ')' required");
                }
            } else {
                this.isFunction = false;
                endIndex = pathFragment.indexOf(93, indexIdx);
                if (endIndex < 0) {
                    throw new InvalidXPathException("Invalid index for path fragment " + pathFragment + " - ']' required");
                }
            }
            if (endIndex + 1 < pathFragment.length()) {
                throw new InvalidXPathException("Unexpected characters after '" + pathFragment.charAt(endIndex) + "' within path fragment " + pathFragment);
            }
            if (indexIdx + 1 < endIndex) {
                try {
                    int value = Integer.parseInt(pathFragment.substring(indexIdx + 1, endIndex));
                    this.argument = new Integer(value);
                }
                catch (NumberFormatException e) {
                    throw new InvalidXPathException("Invalid integer '" + pathFragment.substring(indexIdx + 1, endIndex) + "' within path fragment " + pathFragment);
                }
            } else {
                this.argument = null;
            }
        } else {
            this.argument = null;
            this.isFunction = false;
        }
        if (this.isAttribute && (this.isFunction || this.argument != null)) {
            throw new InvalidXPathException("Invalid path fragment " + pathFragment + " - attributes cannot have index or parameters");
        }
        if (this.argument != null && this.argument <= 0) {
            throw new InvalidXPathException("argument or index in " + pathFragment + " must be geater than Zero");
        }
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return !this.isFunction ? this.argument : null;
    }

    public Integer getArgument() {
        return this.isFunction ? this.argument : null;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean hasIndex() {
        return !this.isFunction && this.argument != null;
    }

    public boolean hasArgument() {
        return this.isFunction && this.argument != null;
    }
}

