/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.ChoiceNode;
import com.softwareag.xtools.xapplication.businessdocument.ElementNode;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.OccurrenceNode;
import com.softwareag.xtools.xapplication.businessdocument.PathFragment;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SequenceNode;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Extension;

class Path
implements TSDConstants {
    static final char PATH_SEPARATOR = '/';
    static final String STRUCTURE_PREFIX = "xapp";
    String[] names;
    int currentNameIndex;
    private Object lastElement;
    private String attributeName;
    private Attribute attr;
    BusinessDocument doc;
    Schema schema;
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$businessdocument$SequenceNode;
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$businessdocument$OccurrenceNode;
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$businessdocument$ChoiceNode;
    static /* synthetic */ Class class$com$softwareag$xtools$xapplication$businessdocument$BusinessNode;

    public Path(BusinessNode start, String path) {
        if (start == null) {
            throw new PreconditionViolation("business node where the path starts, must be defined");
        }
        if (path == null || path.length() <= 0) {
            throw new PreconditionViolation("path must be defined and must not be the empty string - current path: [" + path + "]");
        }
        this.attributeName = null;
        this.attr = null;
        this.lastElement = start;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        this.names = Util.split(path, '/');
        this.currentNameIndex = 0;
        this.doc = start.getDocument();
        this.schema = ((SingleBusinessDocument)this.doc).getSchema();
    }

    public boolean isFinished() {
        return this.currentNameIndex >= this.names.length;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Attribute getAttribute() {
        return this.attr;
    }

    public Object getLastElement() {
        return this.lastElement;
    }

    public String getNextPathFragment() {
        return this.isFinished() ? null : this.names[this.currentNameIndex];
    }

    public void walk() throws InvalidXPathException {
        ElementNode tmp;
        while (this.currentNameIndex < this.names.length) {
            block14: {
                Element elem;
                int index;
                PathFragment pathFrag;
                block17: {
                    block16: {
                        block15: {
                            Element elem2;
                            block13: {
                                pathFrag = new PathFragment(this.names[this.currentNameIndex]);
                                if (!pathFrag.isFunction()) break block13;
                                if (!pathFrag.getNamespacePrefix().equals(STRUCTURE_PREFIX)) {
                                    throw new InvalidXPathException("Unsupported function within path fragment '" + this.names[this.currentNameIndex] + "'");
                                }
                                BusinessNode strucNode = this.getLastStructureNode();
                                int fktArg = pathFrag.hasArgument() ? pathFrag.getArgument() : 1;
                                this.lastElement = this.getNextStructureNode(strucNode, pathFrag.getName(), fktArg);
                                break block14;
                            }
                            if (!pathFrag.isAttribute()) break block15;
                            if (!(this.lastElement instanceof ElementNode) && !(this.lastElement instanceof Element)) {
                                throw new InvalidXPathException("switch to attribute '" + pathFrag.getName() + "' from node '" + ((BusinessNode)this.lastElement).getPath() + "' is not possible");
                            }
                            this.attributeName = pathFrag.getName();
                            if (this.lastElement instanceof ElementNode) {
                                elem2 = ((ElementNode)this.lastElement).domNode;
                            } else if (this.lastElement instanceof Element) {
                                elem2 = (Element)this.lastElement;
                            } else {
                                throw new InvalidXPathException("can not go from node '" + ((BusinessNode)this.lastElement).getPath() + "' to the attribute '" + pathFrag.getName() + "'");
                            }
                            this.attr = pathFrag.getNamespacePrefix().equals("ino") && pathFrag.getName().equals("id") ? Path.getInoAttribute(elem2) : elem2.getAttribute(pathFrag.getName());
                            if (this.attr == null) {
                                break;
                            }
                            break block14;
                        }
                        if (pathFrag.getName().equals(".")) break block14;
                        if (pathFrag.getName().length() == 0) {
                            throw new InvalidXPathException("path expression '" + this.toString() + "' must not contain '//'");
                        }
                        int n = index = pathFrag.hasIndex() ? pathFrag.getIndex() : 1;
                        if (this.lastElement instanceof Element) break block16;
                        elem = Path.switchToNextElement((BusinessNode)this.lastElement, pathFrag.getName(), index);
                        if (!pathFrag.getName().equals(elem.getName())) break block17;
                        this.lastElement = elem;
                        break block14;
                    }
                    elem = (Element)this.lastElement;
                }
                if (this.currentNameIndex == 0 && pathFrag.getName().equals(elem.getName())) {
                    this.lastElement = elem;
                } else {
                    this.lastElement = Extension.getChild(elem, pathFrag.getName(), index);
                    if (this.lastElement == elem) break;
                    if (this.lastElement instanceof Integer) {
                        throw new InvalidXPathException("index " + index + " within path fragment " + this.names[this.currentNameIndex] + " is out of range [0.." + ((Integer)this.lastElement - 1) + "]");
                    }
                }
            }
            ++this.currentNameIndex;
        }
        if (this.lastElement instanceof Element && (tmp = ((SingleBusinessDocument)this.doc).getElementNode((Element)this.lastElement)) != null) {
            this.lastElement = tmp;
        }
    }

    protected BusinessNode getNextStructureNode(BusinessNode parentNode, String fkt, int fktArg) throws InvalidXPathException {
        Class classFilter;
        if (fkt.equals("seq")) {
            classFilter = class$com$softwareag$xtools$xapplication$businessdocument$SequenceNode == null ? (class$com$softwareag$xtools$xapplication$businessdocument$SequenceNode = Path.class$("com.softwareag.xtools.xapplication.businessdocument.SequenceNode")) : class$com$softwareag$xtools$xapplication$businessdocument$SequenceNode;
        } else if (fkt.equals("occ")) {
            classFilter = class$com$softwareag$xtools$xapplication$businessdocument$OccurrenceNode == null ? (class$com$softwareag$xtools$xapplication$businessdocument$OccurrenceNode = Path.class$("com.softwareag.xtools.xapplication.businessdocument.OccurrenceNode")) : class$com$softwareag$xtools$xapplication$businessdocument$OccurrenceNode;
        } else if (fkt.equals("chc")) {
            classFilter = class$com$softwareag$xtools$xapplication$businessdocument$ChoiceNode == null ? (class$com$softwareag$xtools$xapplication$businessdocument$ChoiceNode = Path.class$("com.softwareag.xtools.xapplication.businessdocument.ChoiceNode")) : class$com$softwareag$xtools$xapplication$businessdocument$ChoiceNode;
        } else if (fkt.equals("child")) {
            classFilter = class$com$softwareag$xtools$xapplication$businessdocument$BusinessNode == null ? (class$com$softwareag$xtools$xapplication$businessdocument$BusinessNode = Path.class$("com.softwareag.xtools.xapplication.businessdocument.BusinessNode")) : class$com$softwareag$xtools$xapplication$businessdocument$BusinessNode;
        } else {
            throw new InvalidXPathException("unsupported funktion " + fkt + " in path fragment " + this.names[this.currentNameIndex]);
        }
        BusinessNodeImpl result = ((BusinessNodeImpl)parentNode).getChildImpl(fktArg - 1, classFilter);
        if (result == null) {
            throw new InvalidXPathException("function argument " + fktArg + " within path fragment " + this.names[this.currentNameIndex] + " out of range [1.." + parentNode.getChildCount() + "]. Path=" + this.toString());
        }
        return result;
    }

    protected static Element switchToNextElement(BusinessNode strucNode, String tagName, int index) throws InvalidXPathException {
        Element result;
        BusinessNode parentSNode = strucNode;
        if (strucNode instanceof ElementNode) {
            result = ((ElementNode)strucNode).domNode;
        } else if (strucNode instanceof SequenceNode) {
            if (!((strucNode = ((SequenceNode)strucNode).getChild(tagName)) instanceof ElementNode)) {
                throw new AssertionFailed("sequence node '" + parentSNode.getPath() + " must return an element node with name '" + tagName + "'");
            }
            result = ((ElementNode)strucNode).domNode;
        } else if (strucNode instanceof OccurrenceNode) {
            if (!((strucNode = strucNode.getChild(index - 1)) instanceof ElementNode)) {
                throw new InvalidXPathException("occurrence node '" + parentSNode.getPath() + "' can not switch to element node '" + tagName + "' by index " + (index - 1));
            }
            result = ((ElementNode)strucNode).domNode;
            if (!result.getName().equals(tagName)) {
                throw new InvalidXPathException("occurrence node '" + parentSNode.getPath() + "' has no element node " + result.getName());
            }
        } else if (strucNode instanceof ChoiceNode) {
            if (!((strucNode = strucNode.getChild(0)) instanceof ElementNode)) {
                throw new InvalidXPathException("choice node '" + parentSNode.getPath() + "' has no element node '" + tagName + "', current choice is " + strucNode.getChoice());
            }
            result = ((ElementNode)strucNode).domNode;
            if (!result.getName().equals(tagName)) {
                throw new InvalidXPathException("requested choice '" + tagName + "' is not set, current choice is " + result.getName());
            }
        } else {
            throw new UnsupportedOperationException("TODO: switch from a " + strucNode.getClass().getName() + " to element");
        }
        return result;
    }

    private BusinessNode getLastStructureNode() {
        if (this.lastElement == null) {
            throw new PreconditionViolation("internal error: last element must be defined for path processing");
        }
        if (this.lastElement instanceof BusinessNode) {
            return (BusinessNode)this.lastElement;
        }
        ElementNode result = ((SingleBusinessDocument)this.doc).getElementNode((Element)this.lastElement);
        if (result == null) {
            Element elemNode = (Element)this.lastElement;
            Element nodeType = this.getTypeDefinition(elemNode);
            result = new ElementNode(nodeType, elemNode, (SingleBusinessDocument)this.doc);
        }
        return result;
    }

    Element getTypeDefinition(Element elemNode) {
        if (elemNode == null) {
            throw new PreconditionViolation("element parameter 'elemNode' must not be null");
        }
        ElementNode businessNode = ((SingleBusinessDocument)this.doc).getElementNode(elemNode);
        if (businessNode != null) {
            return businessNode.getType();
        }
        return this.schema.lookupElement(elemNode.getName(), this.getTypeDefinition(elemNode.getParent()));
    }

    private static Attribute getInoAttribute(Element element) {
        String ID_NAMESPACE_PREFIX = "ino";
        if (element == null) {
            throw new PreconditionViolation("element for ino:id be defined");
        }
        Iterator iter = element.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!"ino".equals(attr.getNamespacePrefix())) continue;
            return attr;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.names.length) {
            buffer.append('/');
            buffer.append(this.names[i]);
            ++i;
        }
        return buffer.toString();
    }

    public boolean isValidPathForOptionals(List typePath) throws InvalidXPathException {
        if (typePath == null) {
            throw new PreconditionViolation("list for type nodes must be defined");
        }
        if (!typePath.isEmpty()) {
            throw new PreconditionViolation("list for type nodes must be empty");
        }
        if (this.schema == null) {
            throw new PreconditionViolation("check for optionals is not supported for documents without schema");
        }
        Element type = this.lastElement instanceof Element ? this.getTypeDefinition((Element)this.lastElement) : ((BusinessNodeImpl)this.lastElement).getType();
        int idx = this.currentNameIndex;
        while (idx < this.names.length) {
            int index;
            PathFragment pathFrag = new PathFragment(this.names[idx]);
            String childName = pathFrag.getName();
            if (pathFrag.isFunction()) {
                if (!STRUCTURE_PREFIX.equals(pathFrag.getNamespacePrefix())) {
                    throw new InvalidXPathException("unsupported function prefix '" + pathFrag.getNamespacePrefix() + "' within path expression '" + this.toString() + "'");
                }
                index = pathFrag.hasArgument() ? pathFrag.getArgument() - 1 : 0;
                type = this.schema.getChildType(childName, index, type, typePath);
                return false;
            }
            if (pathFrag.isAttribute() && idx + 1 < this.names.length) {
                throw new InvalidXPathException("attribute '" + this.names + "' is not the last term of the path expression '" + this.toString() + "'");
            }
            index = pathFrag.hasIndex() ? pathFrag.getIndex() - 1 : 0;
            Element child = this.schema.getChild(childName, index, type, pathFrag.isAttribute(), typePath);
            if (!pathFrag.isAttribute()) {
                type = this.schema.lookupElement(childName, type);
            }
            if (child != null) {
                int minOcc = Schema.getMinOccurs(child);
                if (!pathFrag.isAttribute()) {
                    if (!Schema.isOptional(child)) {
                        if (Schema.isOccurrence(child) && index >= minOcc) {
                            return false;
                        }
                    }
                }
            } else {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public boolean touchDescendant() throws InvalidXPathException {
        this.walk();
        ArrayList typePath = new ArrayList();
        boolean result = this.isValidPathForOptionals(typePath);
        if (result) {
            BusinessNode currentElem = this.getLastStructureNode();
            int size = typePath.size();
            int i = 0;
            while (i < size) {
                int index = (Integer)typePath.get(i);
                if (currentElem instanceof ChoiceNode) {
                    if (currentElem.getChoice() != index) {
                        currentElem.setChoice(index);
                    }
                    currentElem = currentElem.getChild(0);
                } else {
                    if (currentElem instanceof OccurrenceNode && currentElem.getChildCount() == 0) {
                        currentElem.insert(0);
                    }
                    currentElem = currentElem.getChild(index);
                }
                ++i;
            }
            this.walk();
            if (!this.isFinished()) {
                if (this.attributeName == null) {
                    throw new AssertionFailed("internal error: attribute excepted when touching descendant");
                }
                if (!(currentElem instanceof ElementNode)) {
                    throw new AssertionFailed("internal error: element expected for setting the attribute");
                }
                ((ElementNode)currentElem).addAttribute(this.attributeName, "");
            }
            this.walk();
        }
        return result;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

