/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.util.HashMap;

public abstract class Page {
    private String pageName = null;
    private int pagesize;
    private HashMap[] subpages;
    private Page basePage;
    private int baseIndex;

    protected Page(String name, int ps) {
        this.pageName = name;
        this.pagesize = ps;
        this.basePage = null;
        this.baseIndex = -1;
    }

    public int getPageCapacity() {
        return this.pagesize;
    }

    public void setPageCapacity(int ps) throws StoreException {
        if (ps <= 0) {
            throw new PreconditionViolation("pagesize parameter 'ps' must be greater than 0, but was " + ps);
        }
        this.pagesize = ps;
        if (this.subpages != null && this.pagesize != this.subpages.length) {
            this.subpages = new HashMap[this.pagesize];
        }
    }

    public void addSubPage(int idx, String targetname, BusinessNodePage np) {
        if (idx < 0 || this.getPageCapacity() <= idx) {
            throw new PreconditionViolation("index " + idx + " out of range [0.." + (this.getPageCapacity() - 1) + "] for page '" + this.pageName + "'");
        }
        if (this.subpages == null) {
            this.subpages = new HashMap[this.getPageCapacity()];
        }
        if (this.subpages[idx] == null) {
            this.subpages[idx] = new HashMap();
        }
        this.subpages[idx].put(targetname, np);
        super.setBasePage(this, idx);
    }

    protected void clearSubPages() {
        if (this.subpages != null) {
            int i = 0;
            while (i < this.subpages.length) {
                if (this.subpages[i] != null) {
                    this.subpages[i].clear();
                }
                ++i;
            }
        }
    }

    public HashMap getSubPages(int idx) {
        if (idx < 0 || this.getPageCapacity() <= idx) {
            throw new PreconditionViolation("index " + idx + " out of range [0.." + (this.getPageCapacity() - 1) + "] for page '" + this.pageName + "'");
        }
        return this.subpages != null ? this.subpages[idx] : null;
    }

    public Page getSubPage(int idx, String pageName) {
        if (idx < 0 || this.getPageCapacity() <= idx) {
            throw new PreconditionViolation("index " + idx + " out of range [0.." + (this.getPageCapacity() - 1) + "] for page '" + pageName + "'");
        }
        return this.subpages != null && this.subpages[idx] != null ? (Page)this.subpages[idx].get(pageName) : null;
    }

    public Page getBasePage() {
        return this.basePage;
    }

    private void setBasePage(Page base, int bIndex) {
        if (this != base.getSubPage(bIndex, this.getPageName())) {
            throw new PreconditionViolation("sub-page '" + this.getPageName() + "' must be registered by the base-page " + base.getPageName() + "'");
        }
        this.basePage = base;
        this.baseIndex = bIndex;
    }

    public String getPositionVector(int idx) {
        StringBuffer sb = new StringBuffer();
        this.getPositionVector(sb);
        int pos = Math.max(0, this.getPageStartElementNo() + 1 + idx);
        sb.append(",");
        sb.append(pos);
        return sb.toString();
    }

    private void getPositionVector(StringBuffer sb) {
        if (sb == null) {
            throw new PreconditionViolation("string buffer parameter 'sb' must not be null");
        }
        if (this.basePage != null) {
            this.basePage.getPositionVector(sb);
            sb.append(",");
            sb.append(this.baseIndex);
            sb.append(",");
        }
        sb.append(this.pageName);
    }

    public String getPageName() {
        return this.pageName;
    }

    public abstract int getPageStartElementNo();

    public abstract int size();

    public abstract int size(boolean var1);

    public abstract void close() throws StoreException;
}

