/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessFactory;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeCursor;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.ContentParser;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.ParseException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class OccurrenceNode
extends BusinessNodeImpl {
    public OccurrenceNode(Element type, SingleBusinessDocument doc) {
        super(type, doc, new ArrayList());
        if (this.document.getSchema() == null) {
            throw new PreconditionViolation("Occurrence nodes for documents without schema are not supported");
        }
        if (type != null) {
            String name = type.getName();
            if (!(name.equals("element") || name.equals("choice") || name.equals("sequence"))) {
                throw new PreconditionViolation("element type '" + name + "' is not ELEMENT, CHOICE or SEQUENCE...particle type expected");
            }
            if (Schema.getMinOccurs(type) == 1 && Schema.getMaxOccurs(type) == 1) {
                throw new PreconditionViolation("type '" + name + "' is mandatory but not an occurrence");
            }
        }
    }

    public void appendAll(List lst) {
        this.addChildNodes(lst);
    }

    public boolean isOccurrence() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return true;
    }

    public Cursor iterate(String regName) {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return new BusinessNodeCursor(this, regName);
    }

    public int getOccurrenceSize() {
        return this.getChildCount();
    }

    public BusinessNode insert(int idx) throws BusinessDocumentStateException {
        int domIdx;
        Element leftDomElement;
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("element write-access only allowed for created or modifiable documents");
        }
        if (idx < 0 || this.getChildCount() < idx) {
            throw new PreconditionViolation("index " + idx + " out of range [0.." + this.getChildCount() + "]");
        }
        if (this.getMaxOccurs() <= this.getChildCount()) {
            throw new PreconditionViolation("inserting a new sub-node at index " + idx + " of node '" + this.getPath() + "' exceeds maxOccurs limit " + this.getMaxOccurs() + ", number of current sub-nodes are " + this.getChildCount());
        }
        BusinessFactory factory = new BusinessFactory(this.document.store);
        List domTrees = factory.createTerm(this.getType(), this.document.getSchema());
        BusinessNodeImpl structureTree = null;
        try {
            structureTree = (BusinessNodeImpl)ContentParser.runNoOcc(domTrees, this.getType(), this.document);
        }
        catch (ParseException e) {
            throw new AssertionFailed("internal error, when creating a node to be inserted into the occurrence " + this.getPath(), e);
        }
        Element parentDomElement = this.getParentDomElement();
        List parentDomChildrenList = parentDomElement.getChildren();
        if (idx == 0) {
            leftDomElement = this.getParentImpl().getLeftDomElement(this);
        } else {
            leftDomElement = ((BusinessNodeImpl)this.getChild(idx - 1)).getLastDomElement();
            if (leftDomElement == null) {
                throw new AssertionFailed("InvalidSchema: optional item in occurrence in not deterministic");
            }
        }
        if (leftDomElement == null) {
            domIdx = 0;
        } else {
            domIdx = parentDomChildrenList.indexOf(leftDomElement) + 1;
            if (domIdx == 0) {
                throw new AssertionFailed("dom element was not found");
            }
        }
        if (domIdx == parentDomChildrenList.size()) {
            int x = 0;
            while (x < domTrees.size()) {
                parentDomChildrenList.add(domTrees.get(x));
                ++x;
            }
        } else {
            int x = 0;
            while (x < domTrees.size()) {
                parentDomChildrenList.add(domIdx + x, domTrees.get(x));
                ++x;
            }
        }
        this.addChildNode(idx, structureTree);
        return structureTree;
    }

    public BusinessNode remove(int idx) throws BusinessDocumentStateException {
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (idx < 0 || this.getOccurrenceSize() <= idx) {
            throw new PreconditionViolation("index out of range [0.." + (this.getOccurrenceSize() - 1) + "] for node " + this.getPath());
        }
        if (this.getChildCount() <= this.getMinOccurs()) {
            throw new PreconditionViolation("remove below lower bound " + this.getMinOccurs() + " of node " + this.getPath());
        }
        BusinessNodeImpl child = this.removeChildNode(idx);
        child.delete();
        return child;
    }

    public boolean isChoice() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return Schema.isOptional(this.getType()) && "choice".equals(this.getType().getName());
    }

    protected BusinessNodeImpl getSubNode(List indexList, List remainingPath) {
        if (indexList == null) {
            throw new PreconditionViolation("parameter 'indexList' must not be null");
        }
        if (remainingPath == null) {
            throw new PreconditionViolation("parameter 'remainingPath' must not be null");
        }
        if (!remainingPath.isEmpty()) {
            throw new PreconditionViolation("parameter 'remainingPath' must not be an empty list");
        }
        indexList.add(0, new Integer(-1));
        return super.getSubNode(indexList, remainingPath);
    }

    protected Element getFirstDomElement() {
        int max = this.getChildCount();
        int i = 0;
        while (i < max) {
            Element result = this.getChildImpl(i).getFirstDomElement();
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected Element getLastDomElement() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            Element result = this.getChildImpl(i).getLastDomElement();
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    protected Element getParentDomElement() {
        return this.getParentImpl().getParentDomElement();
    }

    public String getPath() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (this.getParentImpl() == null) {
            throw new AssertionFailed("parent node must be defined for occurrence node " + this.getPath());
        }
        BusinessNodeImpl parentElement = this.getParentImpl();
        int index = parentElement.getChildImplClassIndex(this);
        if (index < 0) {
            throw new AssertionFailed("current occurrence node is not a child of its parent");
        }
        String result = parentElement.getPath() + "/xapp:occ(" + (index + 1) + ")";
        return result;
    }

    protected String getContent() {
        if (this.getChildCount() != 0) {
            return this.getChildImpl(0).getContent();
        }
        return super.getContent();
    }
}

