/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.AttributeNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.ContentParser;
import com.softwareag.xtools.xapplication.businessdocument.ParseException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Extension;

public class ElementNode
extends BusinessNodeImpl {
    private List attributes;
    protected Element domNode;

    public ElementNode(Element type, Element domNode, SingleBusinessDocument doc) {
        super(type, doc);
        if (domNode == null) {
            throw new PreconditionViolation("domNode must be defined");
        }
        if (type != null && !type.getName().equals("element")) {
            throw new PreconditionViolation("type: element declaration expected");
        }
        this.domNode = domNode;
        if (this.document != null) {
            this.document.mapElementNode(this);
        }
        this.attributes = new ArrayList();
        List lst = domNode.getAttributes();
        int i = 0;
        int max = lst.size();
        while (i < max) {
            Attribute attr = (Attribute)lst.get(i);
            if (!attr.getNamespace().getPrefix().equals("ino")) {
                Element attrDef = type != null ? Schema.lookupAttributeDefinition(type, attr.getName()) : null;
                this.attributes.add(new AttributeNode(attrDef, attr, doc));
            }
            ++i;
        }
    }

    protected BusinessNodeImpl getParentNode() {
        Element parentDomNode;
        if (super.getParentImpl() == null && (parentDomNode = this.domNode.getParent()) != null) {
            ElementNode parentElementNode = this.document.getElementNode(parentDomNode);
            if (parentElementNode == null) {
                Element type = this.document.getSchema().lookupElement(parentDomNode.getName());
                parentElementNode = new ElementNode(type, parentDomNode, this.document);
            }
            parentElementNode.createStructureNodes();
        }
        return super.getParentImpl();
    }

    public boolean isContentNode() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        boolean result = false;
        Element type = this.getType();
        if (type.getAttributeValue("type") != null) {
            result = true;
        } else if (type.getChild("simpleType") != null) {
            result = true;
        } else {
            Element cn = type.getChild("complexType");
            if (cn != null && cn.getChild("simpleContent") != null) {
                result = true;
            }
        }
        return result;
    }

    public String getValue() throws BusinessDocumentStateException {
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("element access not allowed for dead documents");
        }
        return this.domNode.getTextTrim();
    }

    public void setValue(String value) throws BusinessDocumentStateException {
        if (!this.isContentNode()) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' is not a content node");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow write access");
        }
        this.domNode.setText(value);
    }

    public String toXML() throws BusinessDocumentStateException {
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        return Util.elementToString(this.domNode, null, false);
    }

    public AttributeNode getAttribute(String attrName) {
        int i = 0;
        int max = this.attributes.size();
        while (i < max) {
            AttributeNode attr = (AttributeNode)this.attributes.get(i);
            if (attr.getName().equals(attrName)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public AttributeNode addAttribute(String name, String value) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.getDocument().isWriteAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow write access");
        }
        Element attrType = Schema.lookupAttributeDefinition(this.getType(), name);
        if (attrType == null) {
            throw new PreconditionViolation("undefined attribute '" + name + "' for node '" + this.getPath() + "'");
        }
        Attribute domAttr = new Attribute(name, value);
        this.domNode.addAttribute(domAttr);
        AttributeNode attr = new AttributeNode(attrType, domAttr, (SingleBusinessDocument)this.getDocument());
        this.attributes.add(attr);
        return attr;
    }

    protected void delete() {
        Element parentElem;
        if (this.document.getElementNode(this.domNode) == this) {
            this.delete(this.domNode);
        }
        if ((parentElem = this.domNode.getParent()) != null) {
            List pChildren = parentElem.getChildren();
            pChildren.remove(this.domNode);
            if (this.domNode == parentElem) {
                throw new AssertionFailed("parent/child relationship violated for dom node " + this.domNode);
            }
        } else if (!this.isRootNode()) {
            throw new AssertionFailed("missing parent for node " + this.getPath());
        }
        this.document.unmapElementNode(this.domNode);
        if (this.document.getElementNode(this.domNode) != null) {
            throw new AssertionFailed("unexpected registration for an (J)DOM node");
        }
        super.delete();
    }

    private void delete(Element elem) {
        Iterator children = elem.getChildren().iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (child == elem || child.getParent() != elem) {
                throw new AssertionFailed("Parent/child relationship violated: child " + child + " in " + elem + " for first check: " + (child == elem));
            }
            ElementNode childElement = this.document.getElementNode(child);
            if (childElement != null) {
                ((BusinessNodeImpl)childElement).delete();
                continue;
            }
            this.delete(child);
        }
    }

    protected List createStructureNodes() {
        try {
            ArrayList<BusinessNode> children = new ArrayList<BusinessNode>();
            children.add(ContentParser.run(this.domNode, Schema.getContentType(this.getType()), this.document));
            return children;
        }
        catch (ParseException e) {
            throw new AssertionFailed("illegal content for node [" + this.getPath() + "]", e);
        }
    }

    protected Element getFirstDomElement() {
        return this.domNode;
    }

    protected Element getLastDomElement() {
        return this.domNode;
    }

    protected Element getParentDomElement() {
        return this.domNode;
    }

    public String getPath() {
        if (this.document.getElementNode(this.domNode) != this) {
            throw new AssertionFailed("node is not registed as a structure node of the document is belongs to: " + this);
        }
        StringBuffer result = new StringBuffer(64);
        ElementNode.getPath(result, ((ElementNode)this.document.getRoot()).domNode, this.domNode);
        return result.toString();
    }

    private static void getPath(StringBuffer buffer, Element root, Element element) {
        if (element == root) {
            buffer.append('/');
            buffer.append(element.getName());
        } else {
            ElementNode.getPath(buffer, root, element.getParent());
            int index = Extension.childIndex(element);
            buffer.append('/');
            buffer.append(element.getName());
            if (index > 1) {
                buffer.append('[');
                buffer.append(index);
                buffer.append(']');
            }
        }
    }

    public static String toString(Element element) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JDOM element " + element.getNamespace() + ":" + element.getName());
        List list = element.getAttributes();
        int i = 0;
        while (i < list.size()) {
            buffer.append(' ');
            buffer.append(ElementNode.toString((Attribute)list.get(i)));
            ++i;
        }
        return buffer.toString();
    }

    public static String toString(Attribute attribute) {
        return attribute.getName() + "='" + attribute.getValue() + "'";
    }

    protected String getContent() {
        return this.domNode.getName();
    }
}

