/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DefineTSD {
    private static final String USAGE = "X-Application defineTSD\n  defines a schema from an TSD file in Tamino.\nusage: defineTSD url collection tsd doctype\n  url        Tamino URL. \n  collection where to define the schema in.\n  tsd        TSD schema file.\n";

    public static void main(String[] args) {
        String msg;
        if (args.length != 3) {
            System.err.println("expected 3 arguments, got " + args.length);
            System.err.println(USAGE);
            System.exit(1);
        }
        if ((msg = DefineTSD.run(args[0], args[1], new File(args[2]), System.out)) == null) {
            return;
        }
        System.err.println("error: " + msg);
        System.err.println("aborted.");
        System.exit(1);
    }

    public static String run(String taminoURL, String collection, File tsd3file, PrintStream progress) {
        Element tsd3element;
        progress.println("reading tsd file " + tsd3file);
        try {
            tsd3element = Util.fileToElement(tsd3file);
        }
        catch (IOException e) {
            return "cannot read tsd file '" + tsd3file + "': " + e.getMessage();
        }
        catch (JDOMException e) {
            return "cannot convert file '" + tsd3file + "' into jdom tree : " + e.getMessage();
        }
        String msg = DefineTSD.def(taminoURL, collection, tsd3element, progress);
        if (msg != null) {
            return msg;
        }
        progress.println("done");
        return null;
    }

    public static String def(String taminoURL, String collection, String tsd3str, PrintStream progress) {
        Element tsd3element;
        try {
            tsd3element = Util.stringToElement(tsd3str);
        }
        catch (JDOMException e) {
            return "tsd schema is not wellformed: " + e.getMessage() + "\n" + tsd3str;
        }
        return DefineTSD.def(taminoURL, collection, tsd3element, progress);
    }

    public static String def(String taminoURL, String collection, Element tsd3str, PrintStream progress) {
        TaminoStore store;
        Schema tsd3;
        try {
            tsd3 = new Schema(tsd3str, true);
        }
        catch (InvalidSchemaException e) {
            return "invalid tsd schema: " + e.getMessage() + "\n" + Util.elementToString(tsd3str);
        }
        String[] doctypes = tsd3.getDoctypes();
        try {
            try {
                store = new TaminoStore(taminoURL);
            }
            catch (IllegalArgumentException e) {
                return "malformed url: " + e.getMessage();
            }
        }
        catch (StoreException e) {
            return "connect to Tamino failed: " + e.getMessage();
        }
        progress.println("defining tsd schema.");
        try {
            tsd3.define(store, collection, progress);
        }
        catch (StoreException e) {
            e.printStackTrace();
            return "error defining tsd schema: " + e.getMessage();
        }
        progress.println("tsd defined successfully");
        return null;
    }
}

