/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.common.framework.service.message.ExtendedMessage;
import com.softwareag.xtools.common.schematools.converterfromDTD.Main;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEvent;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEventKeeper;
import com.softwareag.xtools.common.schematools.schemamodel.api.event.SchemaToolsEventListener;
import com.softwareag.xtools.xapplication.businessdocument.DefineTSD;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;

public class DefineDTD {
    private static final String USAGE = "X-Application defineDTD\n  defines a schema from a DTD file in Tamino. \nusage: defineDTD url collection dtd doctype\n  url        Tamino URL, including the database name. \n  collection where to define the schema in.\n  dtd        DTD schema file.\n  doctype    root element.\n";

    public static void main(String[] args) {
        String msg;
        if (args.length != 4) {
            System.out.println("expected 4 arguments, got " + args.length);
            System.out.println(USAGE);
            System.exit(1);
        }
        if ((msg = DefineDTD.run(args[0], args[1], new File(args[2]), args[3], System.out)) == null) {
            return;
        }
        System.err.println("error: " + msg);
        System.err.println("aborted.");
        System.exit(1);
    }

    public static String run(String taminoURL, String collection, File dtdFile, String doctype, PrintStream progress) {
        String tsd;
        progress.println("reading dtd file " + dtdFile);
        SchemaToolsEventKeeper keeper = new SchemaToolsEventKeeper();
        try {
            tsd = Main.convert((String)dtdFile.toURL().toString(), (String)collection, null, (String)doctype, (SchemaToolsEventListener)keeper);
        }
        catch (MalformedURLException e) {
            return "invalid file name: " + dtdFile.toString();
        }
        int count = keeper.getEventList().size();
        if (count > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < count) {
                ExtendedMessage msg = ((SchemaToolsEvent)keeper.getEventList().get(i)).getMessage(true);
                buffer.append(msg.getMessageContent());
                buffer.append("(" + msg.getMessageCode() + ")\n");
                ++i;
            }
            return buffer.toString();
        }
        return DefineTSD.def(taminoURL, collection, tsd, System.out);
    }
}

