/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.ChoiceNode;
import com.softwareag.xtools.xapplication.businessdocument.ElementNode;
import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.OccurrenceNode;
import com.softwareag.xtools.xapplication.businessdocument.ParseException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SequenceNode;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.Util;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class ContentParser
implements TSDConstants {
    private List content;
    private int position;
    private SingleBusinessDocument document;
    private static final Element EMPTY_SEQUENCE = new Element("sequence");

    public static BusinessNode run(Element parent, Element type, SingleBusinessDocument document) throws ParseException, InvalidSchemaException {
        return ContentParser.run(parent.getChildren(), type, false, document);
    }

    public static BusinessNode runNoOcc(List content, Element type, SingleBusinessDocument document) throws ParseException, InvalidSchemaException {
        BusinessNode element = ContentParser.run(content, type, true, document);
        return element;
    }

    public static BusinessNode run(List content, Element type, SingleBusinessDocument document) throws ParseException, InvalidSchemaException {
        ContentParser parser = new ContentParser(content, document);
        BusinessNode element = parser.parse(type, false);
        if (element == null) {
            throw new ParseException("not matched");
        }
        if (!parser.eof()) {
            System.err.println("element " + element);
            System.err.println("position " + parser.position + " content " + parser.content);
            throw new ParseException("remaining input");
        }
        return element;
    }

    private static BusinessNode run(List content, Element type, boolean skipOccurrence, SingleBusinessDocument document) throws ParseException, InvalidSchemaException {
        ContentParser parser = new ContentParser(content, document);
        BusinessNode element = parser.parse(type, skipOccurrence);
        if (element == null) {
            throw new ParseException("not matched");
        }
        if (!parser.eof()) {
            System.err.println("element " + element);
            System.err.println("position " + parser.position + " content " + parser.content);
            throw new ParseException("remaining input");
        }
        return element;
    }

    private ContentParser(List content, SingleBusinessDocument document) {
        this.content = content;
        this.position = 0;
        this.document = document;
    }

    public boolean eof() {
        return this.position == this.content.size();
    }

    private BusinessNode parse(Element type, boolean skipOccurrence) throws ParseException, InvalidSchemaException {
        if (type == null) {
            if (this.content.size() != 0) {
                throw new ParseException("empty element expected");
            }
            return new SequenceNode(EMPTY_SEQUENCE, this.document, new ArrayList());
        }
        if (type.getName().equals("simpleType")) {
            if (this.content.size() != 0) {
                throw new ParseException("unexpected child elements found in simpleType element");
            }
            return new SequenceNode(EMPTY_SEQUENCE, this.document, new ArrayList());
        }
        return this.parseParticle(type, skipOccurrence);
    }

    private BusinessNode parseParticle(Element particle, boolean skipOccurrence) throws ParseException, InvalidSchemaException {
        int initialPosition = this.position;
        int min = Schema.getMinOccurs(particle);
        int max = Schema.getMaxOccurs(particle);
        if (skipOccurrence || min == 1 && max == 1) {
            return this.parseTerm(particle);
        }
        ArrayList<BusinessNode> body = new ArrayList<BusinessNode>();
        int count = 0;
        while (count < max) {
            int prevPosition = this.position;
            BusinessNode tmp = this.parseTerm(particle);
            if (tmp == null) break;
            if (this.position == prevPosition && count > min) {
                throw new InvalidSchemaException("schema is non-deterministic");
            }
            body.add(tmp);
            ++count;
        }
        if (count < min) {
            this.position = initialPosition;
            return null;
        }
        OccurrenceNode occ = new OccurrenceNode(particle, this.document);
        occ.appendAll(body);
        return occ;
    }

    private BusinessNode parseTerm(Element term) throws ParseException, InvalidSchemaException {
        String name = term.getName();
        if (name.equals("sequence")) {
            return this.parseSequence(term);
        }
        if (name.equals("choice")) {
            return this.parseChoice(term);
        }
        if (name.equals("element")) {
            return this.parseElement(term);
        }
        throw new InvalidSchemaException("unsupported schema element: " + Util.elementToString(term));
    }

    private BusinessNode parseSequence(Element sequence) throws ParseException, InvalidSchemaException {
        List seqBody = sequence.getChildren();
        int startPosition = this.position;
        ArrayList<BusinessNode> body = new ArrayList<BusinessNode>();
        int i = 0;
        while (i < seqBody.size()) {
            BusinessNode tmp = this.parseParticle((Element)seqBody.get(i), false);
            if (tmp == null) {
                this.position = startPosition;
                return null;
            }
            body.add(tmp);
            ++i;
        }
        return new SequenceNode(sequence, this.document, body);
    }

    private BusinessNode parseChoice(Element choice) throws ParseException, InvalidSchemaException {
        List choiceBody = choice.getChildren();
        int startPosition = this.position;
        BusinessNode firstEmptyChoice = null;
        int i = 0;
        while (i < choiceBody.size()) {
            Element chosen = (Element)choiceBody.get(i);
            BusinessNode tmp = this.parseParticle(chosen, false);
            if (tmp != null) {
                tmp = new ChoiceNode(choice, this.document, tmp);
                if (startPosition == this.position) {
                    if (firstEmptyChoice == null) {
                        firstEmptyChoice = tmp;
                    }
                } else {
                    return tmp;
                }
            }
            ++i;
        }
        return firstEmptyChoice;
    }

    private BusinessNode parseElement(Element element) throws ParseException, InvalidSchemaException {
        Element type;
        if (this.eof()) {
            return null;
        }
        String name = element.getAttributeValue("ref");
        if (name != null) {
            Schema schema = this.document.getSchema();
            if (schema == null) {
                throw new UnsupportedOperationException("TODO: support elements without schema information within the ContentParser");
            }
            type = schema.lookupElement(name);
        } else {
            name = element.getAttributeValue("name");
            if (name == null) {
                throw new InvalidSchemaException("name or ref attribute required: " + element);
            }
            type = element;
        }
        Element current = (Element)this.content.get(this.position);
        if (!current.getName().equals(name)) {
            return null;
        }
        ++this.position;
        ElementNode result = this.document.getElementNode(current);
        if (result == null) {
            result = new ElementNode(type, current, this.document);
        }
        return result;
    }
}

