/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessFactory;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.ContentParser;
import com.softwareag.xtools.xapplication.businessdocument.ParseException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ChoiceNode
extends BusinessNodeImpl {
    public ChoiceNode(Element type, SingleBusinessDocument doc, BusinessNode child) {
        super(type, doc, new ArrayList());
        if (type != null && !type.getName().equals("choice")) {
            throw new PreconditionViolation("type: choice element expected");
        }
        this.addChildNode(0, (BusinessNodeImpl)child);
    }

    public boolean isChoice() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return true;
    }

    public int getChoiceCount() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.getType().getChildren().size();
    }

    public int getChoice() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        int result = 0;
        Element choiceType = this.getChildImpl(0).getType();
        Iterator it = this.getType().getChildren().iterator();
        while (it.hasNext()) {
            Element current = (Element)it.next();
            if (Schema.matchesType(choiceType, current)) {
                return result;
            }
            ++result;
        }
        throw new AssertionFailed("alternative type " + choiceType + " could not be found for choice node " + this.getPath());
    }

    public String getChoiceTag() {
        return this.getChildImpl(0).getContent();
    }

    public BusinessNode setChoice(int alternative) throws BusinessDocumentStateException {
        int domIdx;
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (alternative < 0 || alternative >= this.getChoiceCount()) {
            throw new PreconditionViolation("alternative (" + alternative + ") out of range [0..." + (this.getChoiceCount() - 1) + "] for node " + this.getPath());
        }
        if (this.getChoice() == alternative) {
            return this.getChild(0);
        }
        BusinessNodeImpl oldStructAlternative = this.getChildImpl(0);
        Element parentDomElement = this.getParentDomElement();
        List parentDomChildrenList = parentDomElement.getChildren();
        Element leftDomElement = this.getLeftDomElement(oldStructAlternative);
        if (leftDomElement == null) {
            domIdx = 0;
        } else {
            domIdx = parentDomChildrenList.indexOf(leftDomElement) + 1;
            if (domIdx == 0) {
                throw new AssertionFailed("expected dom element was not found");
            }
        }
        BusinessFactory factory = new BusinessFactory(this.document.store);
        Element type = (Element)this.getType().getChildren().get(alternative);
        List domTrees = factory.createParticle(type, this.document.getSchema());
        BusinessNodeImpl structureAlternative = null;
        try {
            structureAlternative = (BusinessNodeImpl)ContentParser.run(domTrees, type, this.document);
        }
        catch (ParseException e) {
            throw new AssertionFailed("internal error, when creating a new structure node", e);
        }
        if (domIdx == parentDomChildrenList.size()) {
            int x = 0;
            while (x < domTrees.size()) {
                parentDomChildrenList.add(domTrees.get(x));
                ++x;
            }
        } else {
            int x = 0;
            while (x < domTrees.size()) {
                parentDomChildrenList.add(domIdx + x, domTrees.get(x));
                ++x;
            }
        }
        oldStructAlternative.delete();
        this.addChildNode(0, structureAlternative);
        return structureAlternative;
    }

    protected Element getFirstDomElement() {
        if (!this.isExpanded() || this.getChildCount() != 1) {
            throw new AssertionFailed("choice does not contain exactly one child");
        }
        return this.getChildImpl(0).getFirstDomElement();
    }

    protected Element getLastDomElement() {
        if (!this.isExpanded() || this.getChildCount() != 1) {
            throw new AssertionFailed("choice does not contain exactly one child");
        }
        return this.getChildImpl(0).getLastDomElement();
    }

    protected Element getParentDomElement() {
        return this.getParentImpl().getParentDomElement();
    }

    public String getPath() {
        if (this.getParentImpl() == null) {
            throw new AssertionFailed("parent must be defined");
        }
        BusinessNodeImpl parentElement = this.getParentImpl();
        int index = parentElement.getChildImplClassIndex(this);
        if (index < 0) {
            throw new AssertionFailed("current choice node is not a child of its parent");
        }
        String result = parentElement.getPath() + "/xapp:chc(" + (index + 1) + ")";
        return result;
    }
}

