/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.util.NoSuchElementException;

public class BusinessNodePage
extends Page {
    int pageStartingPos = 0;
    BusinessNode occ;
    boolean dynamicPagesize = super.getPageCapacity() <= 0;

    public BusinessNodePage(BusinessNode occurrenceNode, String cursorName, int pagesize) {
        super(cursorName, pagesize);
        this.occ = occurrenceNode;
    }

    public BusinessDocument getDocument() {
        return this.occ.getDocument();
    }

    public int getPageCapacity() {
        int ps = super.getPageCapacity();
        int occSize = this.occ.getChildCount();
        if (occSize > 0 && this.dynamicPagesize && ps != occSize) {
            try {
                super.setPageCapacity(this.occ.getChildCount());
            }
            catch (StoreException e) {
                throw new AssertionFailed("NodePage must not throw a StoreException", e);
            }
            ps = super.getPageCapacity();
        }
        return Math.max(ps, 0);
    }

    public void setPageCapacity(int size) {
        try {
            super.setPageCapacity(size);
            this.dynamicPagesize = super.getPageCapacity() <= 0;
        }
        catch (StoreException e) {
            throw new AssertionFailed("NodePage must not throw a StoreException", e);
        }
    }

    public boolean isActive() {
        return this.occ.isActive();
    }

    public boolean isEmpty() {
        return this.occ.getChildCount() <= 0;
    }

    public void insert(int idx) {
        this.occ.insert(this.pageStartingPos + idx);
    }

    public void remove(int idx) throws BusinessDocumentException {
        int occIdx = this.pageStartingPos + idx;
        if (!this.occ.getChild(occIdx).isRemoveable()) {
            throw new BusinessDocumentException("could not remove the node at index " + idx + " from the occurrence " + this.occ.getPath());
        }
        this.occ.remove(occIdx);
    }

    public BusinessNode getOccurrenceNode() {
        return this.occ;
    }

    public void gotoPageStartingAt(int idx) {
        if (idx < 0) {
            throw new PreconditionViolation("parameter 'idx' must not be negative, but was " + idx);
        }
        int occSize = this.occ.getChildCount();
        int ps = this.getPageCapacity();
        if (idx >= occSize) {
            this.pageStartingPos = idx - (idx - occSize + 1) / ps * ps;
            if (this.pageStartingPos >= occSize) {
                this.pageStartingPos -= ps;
            }
            this.pageStartingPos = Math.max(this.pageStartingPos, 0);
        } else {
            this.pageStartingPos = idx;
        }
        this.clearSubPages();
    }

    public void gotoPageWithIndex(int index) throws NoSuchElementException {
        int newIndex;
        if (index < 0) {
            throw new PreconditionViolation("parameter 'index' must not be negative, but was " + index);
        }
        int ps = this.getPageCapacity();
        int dist = index - this.pageStartingPos;
        int pageOffset = dist / ps;
        if (dist < 0 && dist % ps != 0) {
            --pageOffset;
        }
        if (0 < (newIndex = this.pageStartingPos + pageOffset * ps) && newIndex >= this.occ.getChildCount()) {
            throw new NoSuchElementException();
        }
        if (newIndex > index || index >= newIndex + ps) {
            throw new AssertionFailed("index " + index + " outside calculated range [" + newIndex + ", " + (newIndex + ps - 1) + "]");
        }
        if (newIndex != this.pageStartingPos) {
            this.gotoPageStartingAt(newIndex);
        }
    }

    public BusinessNode get(int idx) {
        int occIdx = this.pageStartingPos + idx;
        return occIdx < this.occ.getChildCount() ? this.occ.getChild(this.pageStartingPos + idx) : null;
    }

    public int getLastNodeIndex() {
        int result = this.getPageCapacity() - 1;
        while (result >= 0 && this.get(result) == null) {
            --result;
        }
        return result;
    }

    public boolean hasNextPage() {
        return this.occ.getChildCount() - this.pageStartingPos > this.getPageCapacity();
    }

    public boolean hasPreviousPage() {
        return this.pageStartingPos > 0;
    }

    public boolean allowsRemoving() {
        return this.size() > this.occ.getMinOccurs();
    }

    public int getPageStartElementNo() {
        return this.pageStartingPos - 1;
    }

    public int size() {
        return this.occ.getChildCount();
    }

    public int size(boolean reread) {
        return this.size();
    }

    public void close() {
    }
}

