/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.AttributeNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeCursor;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.ElementNode;
import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.Path;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public abstract class BusinessNodeImpl
implements BusinessNode,
TSDConstants {
    protected SingleBusinessDocument document;
    private List children;
    private BusinessNodeImpl parent;
    private Element type;

    public BusinessNodeImpl(Element type, SingleBusinessDocument doc) {
        if (doc == null) {
            throw new PreconditionViolation("Document must not be NULL");
        }
        this.children = null;
        this.parent = null;
        this.type = type;
        this.document = doc;
    }

    public BusinessNodeImpl(Element type, SingleBusinessDocument doc, List childNodes) {
        this(type, doc);
        this.children = new ArrayList(childNodes);
        int i = 0;
        while (i < this.children.size()) {
            BusinessNodeImpl child = (BusinessNodeImpl)this.children.get(i);
            child.parent = this;
            ++i;
        }
    }

    public boolean isActive() {
        return this.document != null || this.parent != null || this.children != null || this.type != null;
    }

    public boolean isRootNode() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this == this.document.getRoot();
    }

    public int getChildCount() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (this.children == null) {
            this.initChildren();
        }
        return this.children.size();
    }

    public int getUncheckedChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    public BusinessNode getChild(int idx) {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (this.children == null) {
            this.initChildren();
        }
        if (idx < 0 && this.getChildCount() <= idx) {
            throw new PreconditionViolation("index idx " + idx + " out of range [0.." + (this.getChildCount() - 1) + "] for node " + this.getPath());
        }
        return this.getChildImpl(idx);
    }

    public Cursor getChildren(String regName) {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (regName == null) {
            throw new PreconditionViolation("name for cursor registration must be defined");
        }
        if (this.children == null) {
            this.initChildren();
        }
        BusinessNodeCursor result = new BusinessNodeCursor(this, regName);
        return result;
    }

    public BusinessNode getDescendant(String path) throws InvalidXPathException {
        BusinessNode node;
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        Path p = new Path(this, path);
        p.walk();
        if (!p.isFinished()) {
            throw new InvalidXPathException("no such node: " + path);
        }
        if (p.getLastElement() instanceof Element) {
            Element element = (Element)p.getLastElement();
            node = new ElementNode(this.document.getSchema().lookupElement(element.getName()), element, this.document);
        } else {
            node = (BusinessNode)p.getLastElement();
        }
        if (p.getAttribute() != null) {
            if (!(node instanceof ElementNode)) {
                throw new AssertionFailed("node class 'ElementNode' was expected instead of class '" + node.getClass().getName() + "'");
            }
            AttributeNode attr = ((ElementNode)node).getAttribute(p.getAttributeName());
            if (attr == null) {
                if (p.getAttributeName().equals("id")) {
                    throw new PreconditionViolation("ino:id not available via getDescendant(), use getDocumentID() instead.");
                }
                throw new AssertionFailed("getAttribute returned null: " + p.getAttributeName());
            }
            return attr;
        }
        if (node == null) {
            throw new InvalidXPathException("path " + path + "returned null node");
        }
        return node;
    }

    public List getDescendantsByContent(String content) {
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        ArrayList result = new ArrayList();
        ArrayList remainingPathList = new ArrayList();
        List resolvedSubNodes = this.getDescendantsByContent(content, remainingPathList);
        int i = 0;
        int listSize = remainingPathList.size();
        while (i < listSize) {
            List remainingPath = (List)remainingPathList.get(i);
            int pathLen = remainingPath.size();
            if (pathLen == 0 || pathLen == 1 && (Integer)remainingPath.get(0) == -1) {
                result.add(resolvedSubNodes.get(i));
            }
            ++i;
        }
        return result;
    }

    public void touchDescendants(String path) throws InvalidXPathException, BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow write access");
        }
        Path p = new Path(this, path);
        if (!p.touchDescendant()) {
            throw new InvalidXPathException("The element to be touched which is addressed by '" + path + "' can not be reached");
        }
    }

    public BusinessNode getParent() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        return this.getParentImpl();
    }

    public BusinessDocument getDocument() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.document;
    }

    public boolean isContentNode() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return false;
    }

    public String getValue() throws BusinessDocumentStateException {
        if (!this.isContentNode()) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' is not a content node");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        throw new AssertionFailed("node '" + this.getPath() + "' is a content node, but class " + this.getClass().getName() + " does not overwrite the method getValue");
    }

    public void setValue(String value) throws BusinessDocumentStateException {
        if (!this.isContentNode()) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' is not a content node");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow write access");
        }
        throw new AssertionFailed("node '" + this.getPath() + "' is a content node, but class " + this.getClass().getName() + " does not overwrite the method setValue");
    }

    public String toXML() throws BusinessDocumentStateException {
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        int size = this.getChildCount();
        while (i < size) {
            BusinessNode bn = this.getChild(i);
            result.append(bn.toXML());
            ++i;
        }
        return result.toString();
    }

    public int getMinOccurs() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return Schema.getMinOccurs(this.type);
    }

    public int getMaxOccurs() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return Schema.getMaxOccurs(this.type);
    }

    public boolean isOccurrence() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.getChildCount() == 1 && this.getChild(0).getMaxOccurs() > 1;
    }

    public int getOccurrenceSize() {
        if (!this.isOccurrence()) {
            throw new PreconditionViolation("getting the number of children to be iterated is not supported for non-occurrence node '" + this.getPath() + "'");
        }
        return ((BusinessNodeImpl)this.getChild(0)).getOccurrenceSize();
    }

    public Cursor iterate(String regName) {
        if (!this.isOccurrence()) {
            throw new PreconditionViolation("iteration of non-occurrence node " + this.getPath() + " is not supported");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (regName == null) {
            throw new PreconditionViolation("parameter 'regName' to register the current iterated element must not be null");
        }
        return new BusinessNodeCursor(this.getChild(0), regName);
    }

    public Cursor iterate(String content, String regName) {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        if (regName == null) {
            throw new PreconditionViolation("parameter 'regName' to register the current iterated element must not be null");
        }
        List subNodes = this.getDescendantsByContent(content);
        if (subNodes.size() == 0) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' does not contain a sub-node identified by the content '" + content + "'");
        }
        if (subNodes.size() > 1) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' contains more than one sub-node identified by the content '" + content + "'");
        }
        BusinessNode subNode = (BusinessNode)subNodes.get(0);
        if (!subNode.isOccurrence()) {
            throw new PreconditionViolation("iteration of content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
        }
        return subNode.iterate(regName);
    }

    public Cursor iterate(String sPath, String content, String regName) throws InvalidXPathException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isReadAble()) {
            throw new BusinessDocumentStateException("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (sPath == null) {
            throw new PreconditionViolation("parameter 'sPath' must not be null");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        if (regName == null) {
            throw new PreconditionViolation("parameter 'regName' to register the current iterated element must not be null");
        }
        BusinessNode subNode = this.getDescendant(sPath);
        if (!subNode.isOccurrence()) {
            throw new PreconditionViolation("iteration of content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
        }
        List subNodeByContent = subNode.getDescendantsByContent(content);
        if (!subNodeByContent.contains(subNode)) {
            throw new PreconditionViolation("the structure node '" + subNode.getPath() + "' does not iterate the content '" + content + "'");
        }
        if (subNodeByContent.size() != 1) {
            throw new AssertionFailed("internal error: " + subNodeByContent.size() + " subnodes identified by content '" + content + "' for node '" + this.getPath() + "'");
        }
        return subNode.iterate(regName);
    }

    public BusinessNode insert(int idx) throws BusinessDocumentStateException {
        if (!this.isOccurrence()) {
            throw new PreconditionViolation("insert for node " + this.getPath() + " is not supported");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).insert(idx);
    }

    public BusinessNode insert(int idx, String content) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        if (this.isOccurrence() && "element".equals(this.type.getName()) && content.equals(Schema.getElementName(this.type))) {
            return this.insert(idx);
        }
        ArrayList remainingPathList = new ArrayList();
        List subNodes = this.getDescendantsByContent(content, remainingPathList);
        if (subNodes.size() == 0) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' does not contain a sub-node identified by the content '" + content + "'");
        }
        if (subNodes.size() > 1) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' contains more than one sub-node identified by the content '" + content + "'");
        }
        if (remainingPathList.size() != subNodes.size()) {
            throw new AssertionFailed("internal error: subnode (size=" + subNodes.size() + ") and alternative list (size=" + remainingPathList.size() + ") should have the same size");
        }
        BusinessNode subNode = (BusinessNode)subNodes.get(0);
        List remainingPath = (List)remainingPathList.get(0);
        if (remainingPath.size() > 2) {
            throw new PreconditionViolation("subnode for inserting content '" + content + "' could not be resolved for node '" + this.getPath() + "'");
        }
        if (!subNode.isOccurrence()) {
            throw new PreconditionViolation("insertion of content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
        }
        int indexVal = (Integer)remainingPath.get(0);
        if (remainingPath.size() >= 1 && indexVal <= -2) {
            throw new PreconditionViolation("insertion of content '" + content + "' (-> node = '" + subNode.getPath() + "') requires " + -1 * indexVal / 2 + ". aternative, but current alternative is " + (subNode.getChoice() + 1));
        }
        if (remainingPath.size() >= 1 && indexVal != -1) {
            throw new AssertionFailed("expected index -1 to indicate an occurrence for subnode '" + subNode.getPath() + "'");
        }
        int alternative = -1;
        if (remainingPath.size() >= 2) {
            alternative = (Integer)remainingPath.get(1);
            if (alternative >= -1) {
                throw new PreconditionViolation("insertion of content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
            }
            alternative = (alternative + 1) / -2;
        }
        subNode = subNode.insert(idx);
        if (alternative > -1) {
            if (!subNode.isChoice()) {
                throw new AssertionFailed("internal error: choice node expected instead of " + subNode.getClass().getName());
            }
            subNode = subNode.setChoice(alternative);
        }
        return subNode;
    }

    public BusinessNode insert(String sPath, int idx, String content) throws InvalidXPathException, BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (sPath == null) {
            throw new PreconditionViolation("parameter 'sPath' must not be null");
        }
        BusinessNode subNode = this.getDescendant(sPath);
        return subNode.insert(idx, content);
    }

    public BusinessNode append() throws BusinessDocumentStateException {
        if (!this.isOccurrence()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        return this.insert(this.getOccurrenceSize());
    }

    public BusinessNode append(String content) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        List subNodes = this.getDescendantsByContent(content);
        if (subNodes.size() == 0) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' does not contain a sub-node identified by the content '" + content + "'");
        }
        if (subNodes.size() > 1) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' contains more than one sub-node identified by the content '" + content + "'");
        }
        BusinessNode subNode = (BusinessNode)subNodes.get(0);
        if (!subNode.isOccurrence()) {
            throw new PreconditionViolation("insertion of content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
        }
        return subNode.insert(subNode.getOccurrenceSize(), content);
    }

    public BusinessNode append(String sPath, String content) throws InvalidXPathException, BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("element write-access only allowed for created or modifiable documents");
        }
        if (sPath == null) {
            throw new PreconditionViolation("parameter 'sPath' must not be null");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        BusinessNode subNode = this.getDescendant(sPath);
        return subNode.append(content);
    }

    public BusinessNode remove(int idx) throws BusinessDocumentStateException {
        if (!this.isOccurrence()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).remove(idx);
    }

    public BusinessNode remove(int idx, String content) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        if (this.isOccurrence() && "element".equals(this.type.getName()) && content.equals(Schema.getElementName(this.type))) {
            return this.remove(idx);
        }
        List subNodes = this.getDescendantsByContent(content);
        if (subNodes.size() == 0) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' does not contain a sub-node identified by the content '" + content + "'");
        }
        if (subNodes.size() > 1) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' contains more than one sub-node identified by the content '" + content + "'");
        }
        BusinessNode subNode = (BusinessNode)subNodes.get(0);
        if (!subNode.isOccurrence()) {
            throw new PreconditionViolation("removing content '" + content + "' (-> node = '" + subNode.getPath() + "') is not allowed at node '" + this.getPath() + "'");
        }
        return subNode.remove(idx);
    }

    public BusinessNode remove(String sPath, int idx, String content) throws InvalidXPathException, BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (sPath == null) {
            throw new PreconditionViolation("parameter 'sPath' must not be null");
        }
        BusinessNode subNode = this.getDescendant(sPath);
        return subNode.remove(idx, content);
    }

    public boolean isRemoveable() {
        BusinessNode parent;
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        boolean result = false;
        if (this.document.isWriteAble() && (parent = this.getParent()) != null && parent.isOccurrence() && parent.getMinOccurs() < parent.getOccurrenceSize()) {
            result = true;
        }
        return result;
    }

    public BusinessNode removeThis() throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        BusinessNodeImpl parentNode = this.getParentImpl();
        if (parentNode == null) {
            throw new AssertionFailed("parent must be defined for node " + this.getPath());
        }
        int index = parentNode.getChildImplIndex(this);
        if (index < 0) {
            throw new AssertionFailed("child node " + this.getPath() + " not found within parent node " + parentNode.getPath());
        }
        parentNode.remove(index);
        return this;
    }

    public boolean isChoice() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.getChildCount() == 1 && this.getChild(0).isChoice();
    }

    public int getChoiceCount() {
        if (!this.isChoice()) {
            throw new PreconditionViolation("choice count of non-choice node " + this.getPath() + " is not supported");
        }
        if (!this.document.isReadAble()) {
            throw new PreconditionViolation("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).getChoiceCount();
    }

    public int getChoice() {
        if (!this.isChoice()) {
            throw new PreconditionViolation("choice count of non-choice node " + this.getPath() + " is not supported");
        }
        if (!this.document.isReadAble()) {
            throw new PreconditionViolation("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).getChoice();
    }

    public String getChoiceTag() {
        if (!this.isChoice()) {
            throw new PreconditionViolation("choice count of non-choice node " + this.getPath() + " is not supported");
        }
        if (!this.document.isReadAble()) {
            throw new PreconditionViolation("the current state '" + this.document.getState() + "' of the document does not allow read access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).getChoiceTag();
    }

    public BusinessNode setChoice(String content) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        ArrayList remainingPathList = new ArrayList();
        List subNodes = this.getDescendantsByContent(content, remainingPathList);
        if (remainingPathList.size() != subNodes.size()) {
            throw new AssertionFailed("internal error: subnode (size=" + subNodes.size() + ") and alternative list (size=" + remainingPathList.size() + ") should have the same size");
        }
        if (subNodes.size() == 0) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' does not contain a sub-node identified by the content '" + content + "'");
        }
        if (subNodes.size() > 1) {
            throw new PreconditionViolation("the node '" + this.getPath() + "' contains more than one sub-node identified by the content '" + content + "'");
        }
        BusinessNodeImpl subNode = (BusinessNodeImpl)subNodes.get(0);
        List remainingPath = (List)remainingPathList.get(0);
        if (!remainingPath.isEmpty()) {
            if (!subNode.isChoice()) {
                throw new PreconditionViolation("expected a choice node identified by the content '" + content + "', but found the non-choice node '" + subNode.getPath() + "'");
            }
            subNode = subNode.createSubNode(remainingPath);
        }
        return subNode;
    }

    public BusinessNode setChoice(String sPath, String content) throws InvalidXPathException, BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        BusinessNode subNode = this.getDescendant(sPath);
        return subNode.setChoice(content);
    }

    public BusinessNode setChoice(int alternative) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.isChoice()) {
            throw new PreconditionViolation("setting the alternative (value=" + alternative + ") is not supported for the non-choice node '" + this.getPath() + "'");
        }
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("current document state '" + this.document.state.toString() + "' does not allow write access");
        }
        if (this.getChildCount() != 1) {
            throw new AssertionFailed("to few/many children (" + this.getChildCount() + ") for node '" + this.getPath() + "' ");
        }
        return this.getChild(0).setChoice(alternative);
    }

    public BusinessNode flipChoice(String tag) throws BusinessDocumentStateException {
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("element write-access only allowed for created or modifiable documents");
        }
        return this.getParent().setChoice(tag);
    }

    public BusinessNode flipChoice(int alternative) throws BusinessDocumentStateException {
        if (!this.document.isWriteAble()) {
            throw new BusinessDocumentStateException("element write-access only allowed for created or modifiable documents");
        }
        return this.getParent().setChoice(alternative);
    }

    public boolean isExpanded() {
        return this.children != null;
    }

    protected BusinessNodeImpl getParentImpl() {
        return this.parent;
    }

    protected BusinessNodeImpl getChildImpl(int idx) {
        if (!this.isExpanded()) {
            throw new PreconditionViolation("Internal error: the structure nodes for '" + this.getPath() + "' are not created");
        }
        if (idx < 0 || this.getChildCount() <= idx) {
            throw new PreconditionViolation("Index " + idx + " out of range [0.." + (this.getChildCount() - 1) + "] for node '" + this.getPath() + "'");
        }
        return (BusinessNodeImpl)this.children.get(idx);
    }

    protected BusinessNodeImpl getChildImpl(int idx, Class type) {
        if (this.children == null) {
            this.initChildren();
        }
        if (idx < 0 || this.getChildCount() <= idx) {
            return null;
        }
        if (type == null) {
            return this.getChildImpl(idx);
        }
        int i = 0;
        while (i < this.children.size()) {
            BusinessNodeImpl child = (BusinessNodeImpl)this.children.get(i);
            if (type.isInstance(child)) {
                if (idx == 0) {
                    return child;
                }
                --idx;
            }
            ++i;
        }
        return null;
    }

    protected void addChildNode(int idx, BusinessNodeImpl child) {
        if (!this.isExpanded()) {
            throw new PreconditionViolation("Inserting child although children set was not created");
        }
        if (idx < 0 || this.children.size() < idx) {
            throw new PreconditionViolation("Index " + idx + " out of range [0.." + this.children.size() + "]");
        }
        if (child == null) {
            throw new PreconditionViolation("Child must defined");
        }
        this.children.add(idx, child);
        child.parent = this;
    }

    protected void addChildNodes(List childNodes) {
        if (!this.isExpanded()) {
            throw new PreconditionViolation("Inserting children although children set was not created");
        }
        if (childNodes == null) {
            throw new PreconditionViolation("Child must defined");
        }
        int i = 0;
        while (i < childNodes.size()) {
            BusinessNodeImpl child = (BusinessNodeImpl)childNodes.get(i);
            child.parent = this;
            ++i;
        }
        this.children.addAll(childNodes);
    }

    protected BusinessNodeImpl removeChildNode(int idx) {
        if (!this.isExpanded()) {
            throw new PreconditionViolation("Inserting child although children set was not created");
        }
        if (idx < 0 || this.children.size() <= idx) {
            throw new PreconditionViolation("Index " + idx + " out of range [0.." + this.children.size() + "]");
        }
        BusinessNodeImpl result = (BusinessNodeImpl)this.children.remove(idx);
        result.parent = null;
        return result;
    }

    protected void removeChildNode(BusinessNodeImpl child) {
        if (!this.isExpanded()) {
            throw new PreconditionViolation("Inserting child although children set was not created");
        }
        if (!this.children.contains(child)) {
            throw new PreconditionViolation("The child to be removed is no child of the current node");
        }
        this.children.remove(child);
        child.parent = null;
    }

    protected int getChildImplIndex(BusinessNodeImpl node) {
        return this.children.indexOf(node);
    }

    protected int getChildImplClassIndex(BusinessNodeImpl node) {
        int result = this.getChildImplIndex(node);
        int i = result - 1;
        while (i >= 0) {
            Class<?> nodeClass = node.getClass();
            if (!nodeClass.isInstance(this.children.get(i))) {
                --result;
            }
            --i;
        }
        return result;
    }

    protected void delete() {
        if (this.children != null) {
            int i = this.children.size() - 1;
            while (i >= 0) {
                ((BusinessNodeImpl)this.children.get(i)).delete();
                --i;
            }
            if (this.children.size() != 0) {
                throw new AssertionFailed("Node " + this.getPath() + " has invalid relationships to its children");
            }
        }
        if (this.parent != null) {
            this.parent.removeChildNode(this);
        }
        this.deactivate();
    }

    protected void deactivate() {
        this.document = null;
        this.parent = null;
        this.children = null;
        this.type = null;
    }

    protected List createStructureNodes() throws InvalidSchemaException {
        throw new AssertionFailed("internal error: the method was expected to be implemented by the class " + this.getClass().getName());
    }

    protected Element getFirstDomElement() {
        throw new AssertionFailed("internal error: the method was expected to be implemented by the class " + this.getClass().getName());
    }

    protected Element getLastDomElement() {
        throw new AssertionFailed("internal error: the method was expected to be implemented by the class " + this.getClass().getName());
    }

    protected Element getLeftDomElement(BusinessNode rightNeighbour) {
        if (this.children != null && !this.children.contains(rightNeighbour)) {
            throw new PreconditionViolation("Invalid argument for searching left dom node");
        }
        Element result = null;
        int index = this.children.indexOf(rightNeighbour);
        int i = index - 1;
        while (i >= 0) {
            result = ((BusinessNodeImpl)this.children.get(i)).getLastDomElement();
            if (result != null) break;
            --i;
        }
        if (result == null && this.parent != null && this.getParentDomElement() == this.parent.getParentDomElement()) {
            result = this.parent.getLeftDomElement(this);
        }
        return result;
    }

    protected Element getParentDomElement() {
        throw new AssertionFailed("internal error: the method was expected to be implemented by the class " + this.getClass().getName());
    }

    public String getPath() {
        throw new AssertionFailed("internal error: the method was expected to be implemented by the class " + this.getClass().getName());
    }

    public Element getType() {
        return this.type;
    }

    public boolean isDeleted() {
        return this.document == null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    public void toString(int indent, StringBuffer buffer) {
        if (indent < 0) {
            throw new PreconditionViolation("parameter 'indent' [value" + indent + "]= must not be negative");
        }
        if (buffer == null) {
            throw new PreconditionViolation("parameter 'buffer' must not be null");
        }
        int i = 0;
        while (i < indent) {
            buffer.append("    ");
            ++i;
        }
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        buffer.append(name);
        buffer.append('\n');
        if (this.isExpanded()) {
            int max = this.getChildCount();
            i = 0;
            while (i < max) {
                this.getChild(i).toString(indent + 1, buffer);
                ++i;
            }
        }
    }

    private void initChildren() throws InvalidSchemaException {
        this.children = this.createStructureNodes();
        if (this.children == null) {
            throw new AssertionFailed("createStructureNodes must return a list of BusinessNodeImpls");
        }
        int i = this.children.size() - 1;
        while (i >= 0) {
            BusinessNodeImpl child = (BusinessNodeImpl)this.children.get(i);
            child.parent = this;
            --i;
        }
    }

    private void createOptionalAttribute(Object lastElem, String attrName, String value) {
        if (lastElem == null) {
            throw new PreconditionViolation("Internal Error: parameter 'lastElem' must be defined");
        }
        if (!(lastElem instanceof Element) && !(lastElem instanceof ElementNode)) {
            throw new PreconditionViolation("Internal Error: parameter 'lastElem' must be instance of 'Element' or 'ElementNode'");
        }
        if (attrName == null) {
            throw new PreconditionViolation("Internal Error: parameter 'attrName' must be defined");
        }
        Element elem = lastElem instanceof ElementNode ? ((ElementNode)lastElem).domNode : (Element)lastElem;
        Element attrDef = this.getAttributeDefinition(elem.getName(), attrName);
        if (attrDef == null) {
            throw new AssertionFailed("Attribute '" + attrName + "' is no attribute of node '" + elem.getName() + "'");
        }
        if (value == null && (value = attrDef.getAttributeValue("value")) == null) {
            value = "";
        }
        elem.addAttribute(attrName, value);
    }

    private Element getAttributeDefinition(String elemName, String attrName) {
        Element attrDef;
        Schema schema = this.document.getSchema();
        Element elemType = schema.lookupElement(elemName);
        if ((elemType = elemType.getChild("complexType")) == null) {
            return null;
        }
        Iterator it = elemType.getChildren("attribute").iterator();
        while (it.hasNext()) {
            attrDef = (Element)it.next();
            if (!attrName.equals(attrDef.getAttributeValue("name"))) continue;
            return attrDef;
        }
        if ((elemType = elemType.getChild("simpleContent")) == null) {
            return null;
        }
        if ((elemType = elemType.getChild("extension")) == null) {
            return null;
        }
        it = elemType.getChildren("attribute").iterator();
        while (it.hasNext()) {
            attrDef = (Element)it.next();
            if (!attrName.equals(attrDef.getAttributeValue("name"))) continue;
            return attrDef;
        }
        return null;
    }

    protected String getContent() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        List content = Schema.getElementList(this.type, true);
        int contentSize = content.size();
        if (contentSize <= 0) {
            throw new AssertionFailed("no content description possible for node " + this.getPath());
        }
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < contentSize - 1) {
            result.append((String)content.get(i) + " ");
            ++i;
        }
        result.append((String)content.get(contentSize - 1));
        return result.toString();
    }

    List getDescendantsByContent(String content, List remainingPathList) {
        if (content == null) {
            throw new PreconditionViolation("parameter 'content' must not be null");
        }
        if (remainingPathList == null) {
            throw new PreconditionViolation("parameter 'remainingPathList' must be not be null");
        }
        if (!remainingPathList.isEmpty()) {
            throw new PreconditionViolation("parameter 'remainingPathList' must be an empty list");
        }
        List strucNodePathList = Schema.getIndexPathForStructureNodes(this.getType(), BusinessNodeImpl.splitContent(content));
        int numStrucPath = strucNodePathList.size();
        ArrayList<BusinessNodeImpl> result = new ArrayList<BusinessNodeImpl>(numStrucPath);
        int i = 0;
        while (i < numStrucPath) {
            ArrayList rPath = new ArrayList();
            BusinessNodeImpl subNode = this.getSubNode((List)strucNodePathList.get(i), rPath);
            result.add(subNode);
            remainingPathList.add(rPath);
            ++i;
        }
        return result;
    }

    protected BusinessNodeImpl getSubNode(List indexList, List remainingPath) {
        if (indexList == null) {
            throw new PreconditionViolation("parameter 'indexList' must not be null");
        }
        if (remainingPath == null) {
            throw new PreconditionViolation("parameter 'remainingPath' must not be null");
        }
        if (!remainingPath.isEmpty()) {
            throw new PreconditionViolation("parameter 'remainingPath' must not be an empty list");
        }
        BusinessNodeImpl result = this;
        if (this.children == null) {
            this.initChildren();
        }
        int idxLen = indexList.size();
        int i = 0;
        while (i < idxLen) {
            int idx = (Integer)indexList.get(i);
            if (idx == -1) {
                if (result.isOccurrence()) break;
                throw new AssertionFailed("occurrence expected for node " + result.getPath());
            }
            if (idx < -1) {
                int alt = (idx + 1) / -2;
                if (!result.isChoice()) {
                    throw new AssertionFailed("alternative " + alt + " for a non-choice node " + result.getPath());
                }
                if (result.getChoice() != alt) break;
                idx = 0;
            }
            result = result.getChildImpl(idx);
            ++i;
        }
        while (i < idxLen) {
            remainingPath.add(indexList.get(i));
            ++i;
        }
        return result;
    }

    BusinessNodeImpl createSubNode(List indexList) {
        BusinessNodeImpl result = this;
        int i = 0;
        int listSize = indexList.size();
        while (i < listSize) {
            int idx = (Integer)indexList.get(i);
            if (idx < -1) {
                if (!result.isChoice()) {
                    throw new AssertionFailed("index " + idx + " indicates a choice, but work on non-choice node " + result.getPath());
                }
                idx = (idx + 1) / -2;
                result = (BusinessNodeImpl)result.setChoice(idx);
            } else if (idx == -1) {
                if (!result.isOccurrence()) {
                    throw new AssertionFailed("index indicates an occurrence, but work on non-occurrence node " + result.getPath());
                }
                result = result.getOccurrenceSize() <= 0 ? (BusinessNodeImpl)result.insert(0) : (BusinessNodeImpl)result.getChild(0);
            } else {
                result = (BusinessNodeImpl)result.getChild(idx);
            }
            ++i;
        }
        return result;
    }

    public static List splitContent(String content) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int nextIndex = content.indexOf(32);
        while (nextIndex >= 0) {
            result.add(content.substring(lastIndex, nextIndex));
            lastIndex = nextIndex + 1;
            nextIndex = content.indexOf(32, lastIndex);
        }
        if (content.length() > 0) {
            result.add(content.substring(lastIndex));
        }
        return result;
    }
}

