/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.InvalidCursorException;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.NoSuchElementException;

public class BusinessNodeCursor
implements Cursor {
    private BusinessDocument currentDocument = null;
    private BusinessNode currentParent = null;
    private String currentName;
    String parentPath;
    int currentIndex = 0;
    private boolean closed = false;

    protected BusinessNodeCursor() {
    }

    public BusinessNodeCursor(BusinessDocument document, String xPathQuery, String nodeName) throws InvalidXPathException {
        this(document, document.getRoot(), xPathQuery, nodeName);
    }

    public BusinessNodeCursor(BusinessDocument document, BusinessNode node, String xPathQuery, String nodeName) throws InvalidXPathException {
        this.currentName = nodeName;
        this.currentDocument = document;
        this.currentIndex = 0;
        this.currentParent = node.getDescendant(xPathQuery);
        this.parentPath = this.currentParent.getPath();
    }

    public BusinessNodeCursor(BusinessNode node, String regName) {
        if (node == null) {
            throw new PreconditionViolation("Parameter 'node' must be defined");
        }
        if (node.getDocument() == null) {
            throw new PreconditionViolation("The 'node' must be assigned to a document");
        }
        if (regName == null) {
            throw new PreconditionViolation("Parameter 'regName' must be defined");
        }
        this.currentParent = node;
        this.currentName = regName;
        this.currentDocument = node.getDocument();
        this.currentIndex = 0;
        this.parentPath = this.currentParent.getPath();
    }

    public void reset() {
        this.gotoNextIndex(0);
    }

    public void reload() {
        this.reset();
    }

    public boolean hasNext() throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentIndex < this.currentParent.getChildCount();
    }

    public boolean hasPrevious() throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentIndex > 0;
    }

    public Object next() throws NoSuchElementException, InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next node available");
        }
        BusinessNode currentNode = this.currentParent.getChild(this.currentIndex);
        this.currentDocument.map(this.currentName, currentNode);
        ++this.currentIndex;
        return currentNode;
    }

    public Object previous() throws NoSuchElementException, InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No previous node available");
        }
        BusinessNode currentNode = null;
        --this.currentIndex;
        currentNode = this.currentParent.getChild(this.currentIndex);
        this.currentDocument.map(this.currentName, currentNode);
        return currentNode;
    }

    public int count() throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentParent.getChildCount();
    }

    public int nextIndex() throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentIndex;
    }

    public boolean canMoveBy(int index) {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentIndex + index >= 0 && this.currentIndex + index <= this.count();
    }

    public void moveBy(int index) throws InvalidCursorException {
        this.gotoNextIndex(this.currentIndex + index);
    }

    public void gotoNextIndex(int index) throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        if (index < 0 || this.count() < index) {
            throw new PreconditionViolation("index " + index + " out of range [0.." + this.count() + "]");
        }
        this.currentIndex = index;
    }

    public int previousIndex() throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.currentIndex - 1;
    }

    public void gotoPreviousIndex(int index) throws InvalidCursorException {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        if (index < -1 || this.count() <= index) {
            throw new PreconditionViolation("index " + index + " out of range [-1.." + (this.count() - 1) + "]");
        }
        this.currentIndex = index + 1;
    }

    public boolean isActive() {
        return this.currentParent.isActive();
    }

    public void reread() throws InvalidCursorException {
        if (this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is valid");
        }
        if (!this.currentDocument.isReadAble()) {
            throw new InvalidCursorException("the document the cursor is related to, is not readable");
        }
        try {
            this.currentParent = this.currentDocument.getDescendant(this.parentPath);
            if (!this.currentParent.isOccurrence()) {
                throw new AssertionFailed("node '" + this.currentParent.getPath() + "' to be iterated was expected to be an occurrence node");
            }
        }
        catch (InvalidXPathException e) {
            throw new InvalidCursorException("the BusinessNode " + this.parentPath + " does not longer exist");
        }
        if (this.currentIndex < 0 || this.count() < this.currentIndex) {
            throw new InvalidCursorException("cursor for node '" + this.parentPath + "' at position '" + this.currentIndex + "' is out of range [0.." + this.count() + "]");
        }
        if (0 <= this.currentIndex && this.currentIndex < this.count()) {
            BusinessNode currentNode = this.currentParent.getChild(this.currentIndex);
            this.currentDocument.map(this.currentName, currentNode);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            throw new PreconditionViolation("cursor already closed");
        }
        this.closed = true;
    }

    public BusinessNode getIterationNode() {
        return this.currentParent;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed()) {
            System.err.println("WARNING: finalizing un-closed() BusinessElementCursor");
            this.close();
        }
    }

    public int getPagesize() {
        if (!this.isActive()) {
            throw new InvalidCursorException("the current cursor for node '" + this.parentPath + "' is invalid");
        }
        return this.count();
    }
}

