/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.InvalidRecursionException;
import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.TSDConstants;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.store.Store;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class BusinessFactory
implements TSDConstants {
    private TaminoStore store;
    private Schema schema;
    private List elements;

    public BusinessFactory(Store store) {
        this.store = store instanceof TaminoStore ? (TaminoStore)store : null;
    }

    public Schema lookupSchema(String doctype) throws StoreException, InvalidSchemaException {
        if (this.store == null) {
            return null;
        }
        return Schema.read(this.store, doctype, false);
    }

    public BusinessDocument createDocument(String doctype, Schema schema, Store store) throws InvalidSchemaException {
        Element empty;
        if (schema != null) {
            Element element = schema.lookupElement(doctype);
            if (element == null) {
                throw new PreconditionViolation("element type not found: " + doctype);
            }
            List lst = this.createParticle(element, schema);
            if (lst.size() != 1) {
                throw new InvalidSchemaException("result is not a tree");
            }
            empty = (Element)lst.get(0);
        } else {
            empty = new Element(doctype);
        }
        return new SingleBusinessDocument(empty, store, schema);
    }

    public BusinessDocument createDocument(String doctype, Store store) throws StoreException, InvalidSchemaException {
        return this.createDocument(doctype, this.lookupSchema(doctype), store);
    }

    public BusinessDocument createDocument(String doctype, Store store, String content) throws StoreException, InvalidSchemaException {
        if (store == null) {
            throw new PreconditionViolation("parameter 'store' must not be null");
        }
        if (content == null) {
            throw new PreconditionViolation("parameter 'store' must not be null");
        }
        return this.createDocument(this.lookupSchema(doctype), store, content);
    }

    public BusinessDocument createDocument(Schema schema, Store store, String content) throws InvalidSchemaException {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build((InputStream)new ByteArrayInputStream(content.getBytes()));
            Element root = doc.getRootElement();
            return new SingleBusinessDocument(root, store, schema);
        }
        catch (JDOMException e) {
            throw new InvalidSchemaException("content is not wellformed: " + e.getMessage());
        }
    }

    public List createParticle(Element type, Schema schema) throws InvalidSchemaException {
        if (type == null) {
            throw new PreconditionViolation("type must be defined");
        }
        if (schema == null) {
            throw new PreconditionViolation("schema must be defined");
        }
        this.schema = schema;
        this.elements = new ArrayList();
        ArrayList result = new ArrayList();
        this.createParticle(type, result);
        if (this.elements.size() > 0) {
            throw new AssertionFailed("recursion stack not empty");
        }
        return result;
    }

    public List createTerm(Element type, Schema schema) throws InvalidSchemaException {
        if (type == null) {
            throw new PreconditionViolation("type must be defined");
        }
        if (schema == null) {
            throw new PreconditionViolation("schema must be defined");
        }
        this.schema = schema;
        this.elements = new ArrayList();
        ArrayList result = new ArrayList();
        this.createTerm(type, result);
        if (this.elements.size() > 0) {
            throw new AssertionFailed("recursion stack not empty");
        }
        return result;
    }

    private void createParticle(Element type, List result) throws InvalidSchemaException {
        int count = Schema.getMinOccurs(type);
        while (count-- > 0) {
            this.createTerm(type, result);
        }
    }

    private void createTerm(Element type, List result) throws InvalidSchemaException {
        String name = type.getName();
        if ("element".equals(name)) {
            this.createElement(type, result);
        } else if ("choice".equals(name)) {
            this.createChoice(type, result);
        } else if ("sequence".equals(name)) {
            this.createSequence(type, result);
        } else {
            throw new InvalidSchemaException("unsupported schema element: " + Util.elementToString(type));
        }
    }

    private void createElement(Element element, List result) throws InvalidSchemaException {
        Element decl;
        String name = element.getAttributeValue("ref");
        if (name != null) {
            decl = this.schema.lookupElement(name);
            if (decl == null) {
                throw new InvalidSchemaException("no such element: " + name);
            }
        } else {
            name = element.getAttributeValue("name");
            if (name == null) {
                throw new InvalidSchemaException("missing name attribute: " + element);
            }
            decl = element;
        }
        Element resultElement = new Element(name);
        result.add(resultElement);
        Element complex = decl.getChild("complexType");
        if (complex != null) {
            Element child = complex.getChild("simpleContent");
            if (child != null) {
                if ((child = child.getChild("extension")) == null) {
                    throw new InvalidSchemaException("simpleContent element without extension element");
                }
                BusinessFactory.createAttributeList(child, resultElement);
            } else {
                this.enterRecursion(name);
                try {
                    ArrayList subresult = new ArrayList();
                    child = complex.getChild("choice");
                    if (child != null) {
                        this.createParticle(child, subresult);
                    } else {
                        child = complex.getChild("sequence");
                        if (child != null) {
                            this.createParticle(child, subresult);
                        }
                    }
                    int i = 0;
                    while (i < subresult.size()) {
                        resultElement.addContent((Element)subresult.get(i));
                        ++i;
                    }
                    BusinessFactory.createAttributeList(complex, resultElement);
                    Object var11_10 = null;
                    this.leaveRecursion();
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    this.leaveRecursion();
                    throw throwable;
                }
            }
        } else {
            resultElement.setText(BusinessFactory.createValue(decl));
        }
    }

    private void createSequence(Element sequence, List result) throws InvalidSchemaException {
        List lst = sequence.getChildren();
        int i = 0;
        while (i < lst.size()) {
            Element child = (Element)lst.get(i);
            this.createParticle(child, result);
            ++i;
        }
    }

    private void createChoice(Element choice, List result) throws InvalidSchemaException {
        List lst = choice.getChildren();
        int max = lst.size();
        InvalidRecursionException recursion = null;
        int i = 0;
        while (i < max) {
            Element child = (Element)lst.get(i);
            try {
                ArrayList altResult = new ArrayList();
                this.createParticle(child, altResult);
                result.addAll(altResult);
                return;
            }
            catch (InvalidRecursionException e) {
                if (recursion == null) {
                    recursion = e;
                }
                ++i;
            }
        }
        if (max == 0) {
            throw new InvalidSchemaException("cannot create document with empty choice -- empty choices cannot be matched");
        }
        if (recursion == null) {
            throw new AssertionFailed();
        }
        throw recursion;
    }

    private static void createAttributeList(Element element, Element result) throws InvalidSchemaException {
        List lst = element.getChildren("attribute");
        int i = 0;
        while (i < lst.size()) {
            String dflt;
            Element c = (Element)lst.get(i);
            String name = c.getAttributeValue("name");
            if (name == null) {
                throw new InvalidSchemaException("missing attribute name");
            }
            String use = c.getAttributeValue("use");
            if (use == null) {
                use = "optional";
            }
            if ((dflt = c.getAttributeValue("default")) == null) {
                dflt = c.getAttributeValue("fixed");
            }
            if (use.equals("required") || use.equals("optional") && dflt != null) {
                String value = dflt != null ? dflt : BusinessFactory.createValue(c);
                Attribute attr = new Attribute(name, value);
                result.addAttribute(attr);
            }
            ++i;
        }
    }

    public static String createValue(Element eleOrAttr) {
        return BusinessFactory.createValue(eleOrAttr, 0);
    }

    public static String createValue(Element eleOrAttr, int num) {
        String value = eleOrAttr.getAttributeValue("value");
        if (value == null) {
            ArrayList enums = new ArrayList();
            BusinessFactory.getEnumerations(eleOrAttr, enums);
            int max = enums.size();
            if (max == 0) {
                value = num == 0 ? "" : "" + num;
            } else {
                Element element = (Element)enums.get(num % max);
                value = element.getAttributeValue("value");
            }
        }
        return value;
    }

    private static void getEnumerations(Element attribute, List result) {
        Element ele = attribute.getChild("simpleType");
        if (ele == null) {
            return;
        }
        if ((ele = ele.getChild("restriction")) == null) {
            return;
        }
        result.addAll(ele.getChildren("enumeration"));
    }

    private void enterRecursion(String element) throws InvalidRecursionException {
        if (this.elements.contains(element)) {
            throw new InvalidRecursionException("invalid recursion for element " + element);
        }
        this.elements.add(element);
    }

    private void leaveRecursion() {
        this.elements.remove(this.elements.size() - 1);
    }
}

