/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentCursor;
import com.softwareag.xtools.xapplication.businessdocument.BusinessFactory;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.InvalidSchemaException;
import com.softwareag.xtools.xapplication.businessdocument.QueryBuilder;
import com.softwareag.xtools.xapplication.businessdocument.QueryContainer;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SchemaCache;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.common.XRuntimeException;
import com.softwareag.xtools.xapplication.store.Store;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import com.softwareag.xtools.xapplication.store.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class BusinessDocumentWorkspace {
    protected Store store;
    private Map content;
    private BusinessFactory factory;
    private SchemaCache schemaCache;

    public BusinessDocumentWorkspace(Store store) {
        this(store, new SchemaCache((TaminoStore)store));
    }

    public BusinessDocumentWorkspace(Store store, SchemaCache schemaCache) {
        this.store = store;
        this.content = new HashMap();
        this.factory = new BusinessFactory(store);
        this.schemaCache = schemaCache;
    }

    public BusinessFactory getFactory() {
        return this.factory;
    }

    public Store getStore() {
        return this.store;
    }

    public Cursor query(String documentName, QueryContainer queryExpression) throws StoreException {
        return this.query(documentName, queryExpression, 10);
    }

    public Cursor query(String documentName, QueryContainer queryExpression, int pageSize) throws StoreException {
        if (queryExpression == null) {
            throw new PreconditionViolation("query expression must not be null");
        }
        if (documentName == null) {
            throw new PreconditionViolation("document name must not be null");
        }
        if (pageSize <= 0) {
            throw new PreconditionViolation("parameter pageSize must be greater than Zero, but was " + pageSize);
        }
        Schema schema = this.schemaCache.lookup(queryExpression.getDoctype());
        if (schema == null) {
            throw new XRuntimeException("the doctype '" + queryExpression.getDoctype() + "' could not be found");
        }
        QueryBuilder queryBuilder = new QueryBuilder(queryExpression);
        BusinessDocumentCursor result = new BusinessDocumentCursor(queryBuilder.buildQueryExpression(), this, documentName, schema, pageSize);
        return result;
    }

    public BusinessDocument create(String documentName, String doctype) throws StoreException {
        BusinessDocument doc = null;
        try {
            doc = this.factory.createDocument(doctype, this.schemaCache.lookup(doctype), this.store);
        }
        catch (InvalidSchemaException e) {
            throw new AssertionFailed("schema " + doctype + " is invalid", e);
        }
        this.map(documentName, doc);
        return doc;
    }

    public Iterator iterateNames() {
        return this.content.keySet().iterator();
    }

    public BusinessDocument read(String documentName, String id) throws StoreException {
        Timestamp ts = new Timestamp();
        Element elem = this.store.read(id, ts);
        SingleBusinessDocument doc = null;
        try {
            doc = new SingleBusinessDocument(elem, this.store, this.schemaCache.lookup(elem.getName()), ts);
        }
        catch (InvalidSchemaException e) {
            throw new AssertionFailed("invalid schema detected. " + e.getMessage());
        }
        this.map(documentName, doc);
        return doc;
    }

    public void commitAll() throws StoreException {
        ArrayList lst = new ArrayList(this.content.values());
        SingleBusinessDocument.commitAll(lst);
    }

    public void commitAll(String[] documentNames) throws StoreException {
        ArrayList<BusinessDocument> lst = new ArrayList<BusinessDocument>();
        int i = 0;
        while (i < documentNames.length) {
            BusinessDocument doc = this.lookup(documentNames[i]);
            if (doc == null) {
                throw new PreconditionViolation("no such document: " + documentNames[i]);
            }
            lst.add(doc);
            ++i;
        }
        SingleBusinessDocument.commitAll(lst);
    }

    public void abandonAll() {
        List lst = Util.removeDuplicates(this.content.values());
        int max = lst.size();
        int i = 0;
        while (i < max) {
            BusinessDocument doc = (BusinessDocument)lst.get(i);
            if (doc.getState() == 2 || doc.getState() == 3) {
                doc.abandon();
            }
            ++i;
        }
    }

    public BusinessDocument lookup(String documentName) {
        return (BusinessDocument)this.content.get(documentName);
    }

    public BusinessDocument unmap(String documentName) {
        return (BusinessDocument)this.content.remove(documentName);
    }

    public BusinessDocument map(String documentName, BusinessDocument newDocument) {
        this.content.put(documentName, newDocument);
        return newDocument;
    }
}

