/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.util.NoSuchElementException;

public class BusinessDocumentPage
extends Page {
    public static final int SEARCH_PAGE_RANGE = 2;
    private int pageStartingPos;
    private int initialSize;
    private BusinessDocument[] page;
    private Cursor cursor;

    public BusinessDocumentPage(Cursor bdc, String pageName, int cursorPagesize) throws StoreException {
        super(pageName, cursorPagesize);
        if (cursorPagesize <= 0) {
            throw new PreconditionViolation("parameter 'cursorPagesize' must be greater than Zero, but was " + cursorPagesize);
        }
        if (bdc == null || bdc.isClosed()) {
            throw new PreconditionViolation("cursor parameter 'bdc' must not be closed");
        }
        this.pageStartingPos = -1;
        this.initialSize = -1;
        this.cursor = bdc;
        this.cursor.reset();
        this.createPage();
    }

    public boolean hasNextPage() throws StoreException {
        return this.cursor.canMoveBy(this.getPageCapacity() + 1);
    }

    public boolean hasPreviousPage() throws StoreException {
        return this.cursor.canMoveBy(-1);
    }

    public void gotoPageStartingAt(int elementNo) throws StoreException {
        int moveOffset = this.moveCursor(elementNo - this.pageStartingPos - 1);
        this.pageStartingPos += moveOffset;
        this.reloadPage();
    }

    public BusinessDocument get(int idx) {
        if (idx < 0 || this.getPageCapacity() <= idx) {
            throw new PreconditionViolation("index " + idx + " must be in range [0, " + (this.getPageCapacity() - 1) + "]");
        }
        return this.page[idx];
    }

    public int getPageStartElementNo() {
        return this.pageStartingPos;
    }

    public void setPageCapacity(int newSize) throws StoreException {
        if (newSize <= 0) {
            new PreconditionViolation("pagesize must be greater than Zero, but was " + newSize);
        }
        super.setPageCapacity(newSize);
        this.createPage();
        if (this.getPageCapacity() != this.page.length) {
            throw new AssertionFailed("page buffer was not updated correctly");
        }
    }

    public int size() {
        return this.size(true);
    }

    public int size(boolean reread) {
        try {
            int result = reread || this.initialSize == -1 ? this.cursor.count() : this.initialSize;
            this.initialSize = this.initialSize == -1 ? result : this.initialSize;
            return result;
        }
        catch (StoreException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean containsDeadDocuments() {
        int i = 0;
        while (i < this.page.length) {
            if (this.page[i] != null && this.page[i].getState() == 4) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int moveCursor(int offset) throws StoreException {
        if (offset > 0 && !this.cursor.canMoveBy(offset + 1)) {
            offset = -this.pageStartingPos - 1 + this.cursor.count() - this.getPageCapacity();
        }
        if (offset < 0 && !this.cursor.canMoveBy(offset)) {
            this.cursor.reset();
            offset = -this.pageStartingPos - 1;
        } else {
            this.cursor.moveBy(offset);
        }
        return offset;
    }

    private void reloadPage() throws StoreException {
        int cursorPagesize = this.cursor.getPagesize();
        if (this.pageStartingPos < cursorPagesize) {
            this.cursor.reload();
            int i = this.pageStartingPos + 1;
            while (i > 0 && this.cursor.hasNext()) {
                this.cursor.next();
                --i;
            }
        } else {
            this.cursor.moveBy(-1 - (this.pageStartingPos + 1) % cursorPagesize);
            int i = (this.pageStartingPos + 1) % cursorPagesize;
            while (i >= 0 && this.cursor.hasNext()) {
                this.cursor.next();
                --i;
            }
        }
        this.clearPage();
        this.loadPage();
    }

    private void createPage() throws StoreException {
        this.page = new BusinessDocument[this.getPageCapacity()];
        this.loadPage();
    }

    private void loadPage() throws StoreException {
        int i = 0;
        while (i < this.getPageCapacity() && this.cursor.hasNext()) {
            this.page[i] = (BusinessDocument)this.cursor.next();
            if (!this.page[i].isReadAble()) {
                throw new AssertionFailed("document at pos " + (this.pageStartingPos + i) + " must be readable");
            }
            ++i;
        }
        this.cursor.moveBy(-i);
        while (i < this.getPageCapacity()) {
            this.page[i] = null;
            ++i;
        }
    }

    private void clearPage() {
        int i = this.page.length - 1;
        while (i >= 0) {
            this.page[i] = null;
            --i;
        }
    }

    public int findDocument(int index, String docId) throws StoreException, NoSuchElementException {
        if (docId == null) {
            throw new PreconditionViolation("parameter 'docId' must not be null");
        }
        if (index < 0) {
            throw new PreconditionViolation("parameter 'index' must not be geater than Zero, but was " + index);
        }
        try {
            this.gotoPageWithIndex(index);
        }
        catch (NoSuchElementException e) {
            this.gotoPageStartingAt(index);
        }
        int ps = this.getPageCapacity();
        int result = index - (this.pageStartingPos + 1);
        if (!(result < ps && this.get(result) != null && docId.equals(this.get(result).getDocumentId()) || (result = this.findDocumentInRange(docId)) > -1)) {
            throw new NoSuchElementException();
        }
        if (result < 0 || ps < result) {
            throw new AssertionFailed("resulting index " + result + " must be in range [0.." + (ps - 1) + "]");
        }
        if (this.page[result] == null || !docId.equals(this.page[result].getDocumentId())) {
            throw new AssertionFailed("resulting index " + result + " refers to a document with other docid");
        }
        return result;
    }

    private int findDocumentInPage(String docId) throws NoSuchElementException {
        if (docId == null) {
            throw new PreconditionViolation("parameter 'docId' must not be null");
        }
        int result = this.getPageCapacity() - 1;
        while (result >= 0) {
            if (this.page[result] != null && docId.equals(this.page[result].getDocumentId())) break;
            --result;
        }
        return result;
    }

    private int findDocumentInRange(String docId) throws NoSuchElementException, StoreException {
        int idx = this.pageStartingPos + 1;
        int result = this.findDocumentInPage(docId);
        int pagesize = this.getPageCapacity();
        int i = -2;
        while (i <= 2 && result < 0) {
            int newIdx = idx + i * pagesize;
            if (newIdx >= 0 && i != 0) {
                this.gotoPageStartingAt(newIdx);
                result = this.findDocumentInPage(docId);
            }
            ++i;
        }
        return result;
    }

    public void gotoPageWithIndex(int index) throws StoreException, NoSuchElementException {
        int newIndex;
        if (index < 0) {
            throw new PreconditionViolation("parameter 'index' must be greater than Zero, but was " + index);
        }
        int dist = index - (this.pageStartingPos + 1);
        if (!this.cursor.canMoveBy(dist >= 0 ? dist + 1 : dist)) {
            throw new NoSuchElementException();
        }
        int pagesize = this.getPageCapacity();
        int pageOffset = dist / pagesize;
        if (dist < 0 && dist % pagesize != 0) {
            --pageOffset;
        }
        if ((newIndex = this.pageStartingPos + 1 + pageOffset * pagesize) > index || index >= newIndex + pagesize) {
            throw new AssertionFailed("index " + index + " outside calculated range [" + newIndex + ", " + (newIndex + this.cursor.getPagesize() - 1) + "]");
        }
        this.gotoPageStartingAt(newIndex);
    }

    public void close() throws StoreException {
        if (!this.cursor.isClosed()) {
            try {
                this.cursor.close();
            }
            catch (StoreException storeException) {
                // empty catch block
            }
        }
    }
}

