/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentWorkspace;
import com.softwareag.xtools.xapplication.businessdocument.Cursor;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.Timestamp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Element;

public class BusinessDocumentCursor
implements Cursor {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private String xPathQuery;
    private List documents;
    protected String documentName;
    BusinessDocument[] pageBuffer;
    int documentCounter;
    int pagesize;
    private ElementIterator elementIterator;
    private Schema schema;
    protected BusinessDocumentWorkspace workspace;

    public BusinessDocumentCursor(String xPathQuery, BusinessDocumentWorkspace workspace, String documentName, Schema schema) throws StoreException {
        this(xPathQuery, workspace, documentName, schema, 10);
    }

    public BusinessDocumentCursor(String xPathQuery, BusinessDocumentWorkspace workspace, String documentName, Schema schema, int pagesize) throws StoreException {
        if (xPathQuery == null) {
            throw new PreconditionViolation("query parameter 'xPathQuery' of a cursor must not be null");
        }
        if (workspace == null) {
            throw new PreconditionViolation("parameter 'workspace' of a cursor must not be null");
        }
        if (documentName == null) {
            throw new PreconditionViolation("parameter 'documentName' of a cursor must not be null");
        }
        if (schema == null) {
            throw new PreconditionViolation("parameter 'schema' of a cursor must not be null");
        }
        if (pagesize <= 0) {
            throw new PreconditionViolation("pagesize (value=" + pagesize + ") for cursor with query '" + xPathQuery + "' must be greater than Zero.");
        }
        this.xPathQuery = xPathQuery;
        this.workspace = workspace;
        this.documentName = documentName;
        this.schema = schema;
        this.pagesize = pagesize;
        this.pageBuffer = new BusinessDocument[pagesize];
        this.documentCounter = -1;
        this.elementIterator = workspace.store.query(xPathQuery, pagesize);
        this.documents = new ArrayList();
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void reset() throws StoreException {
        this.elementIterator.reset();
        if (this.pagesize <= this.documentCounter) {
            this.clearBuffer();
        }
        this.documentCounter = -1;
    }

    public void reload() throws StoreException {
        this.clearBuffer();
        this.documentCounter = -1;
        this.elementIterator.close();
        this.elementIterator = this.workspace.store.query(this.xPathQuery, this.pagesize);
        this.documents = new ArrayList();
    }

    public boolean canMoveBy(int index) throws StoreException {
        return this.elementIterator.canMoveBy(index);
    }

    public void moveBy(int index) throws StoreException, NoSuchElementException {
        if (!this.canMoveBy(index)) {
            throw new NoSuchElementException();
        }
        int pagePos = this.documentCounter % this.pagesize + index;
        if (pagePos < 0 || pagePos > this.pagesize - 1) {
            this.clearBuffer();
        }
        this.documentCounter += index;
        this.elementIterator.moveBy(index);
    }

    public boolean hasNext() {
        return this.elementIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.elementIterator.hasPrevious();
    }

    public Object next() throws NoSuchElementException, StoreException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element availaable");
        }
        BusinessDocument result = this.wrap(this.elementIterator.next());
        this.bufferDocument(result, true);
        return result;
    }

    public Object previous() throws NoSuchElementException, StoreException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No previous element available");
        }
        BusinessDocument result = this.wrap(this.elementIterator.previous());
        this.bufferDocument(result, false);
        return result;
    }

    public int count() throws StoreException {
        if (this.isClosed()) {
            throw new PreconditionViolation("count not allowed for closed cursor");
        }
        return this.workspace.store.count(this.xPathQuery);
    }

    public BusinessDocumentWorkspace getWorkspace() {
        return this.workspace;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    private BusinessDocument wrap(Element ele) {
        SingleBusinessDocument doc;
        int i = this.documents.size() - 1;
        while (i >= 0) {
            WeakReference weak = (WeakReference)this.documents.get(i);
            doc = (SingleBusinessDocument)weak.get();
            if (doc == null) {
                this.documents.remove(i);
            } else if (doc.hasDomTree(ele)) {
                this.workspace.map(this.documentName, doc);
                return doc;
            }
            --i;
        }
        Timestamp ts = new Timestamp();
        doc = new SingleBusinessDocument(ele, this.workspace.store, this.schema, ts);
        this.documents.add(new WeakReference<SingleBusinessDocument>(doc));
        this.workspace.map(this.documentName, doc);
        return doc;
    }

    public void close() throws StoreException {
        if (this.isClosed()) {
            throw new PreconditionViolation("cursor already closed");
        }
        this.elementIterator.close();
    }

    public boolean isClosed() {
        return this.elementIterator.isClosed();
    }

    void clearBuffer() {
        int i = 0;
        while (i < this.pageBuffer.length) {
            this.pageBuffer[i] = null;
            ++i;
        }
    }

    void bufferDocument(BusinessDocument doc, boolean increased) {
        if (this.documentCounter <= -2) {
            throw new PreconditionViolation("internal document counter must be greater than -2");
        }
        if (this.documentCounter % this.pagesize + 1 == this.pagesize) {
            this.clearBuffer();
        }
        if (increased) {
            ++this.documentCounter;
            this.pageBuffer[this.documentCounter % this.pagesize] = doc;
        } else {
            this.pageBuffer[this.documentCounter % this.pagesize] = doc;
            --this.documentCounter;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.elementIterator.isClosed()) {
            System.err.println("WARNING: finalizing un-closed() BusinessDocumentCursor");
            try {
                this.close();
            }
            catch (StoreException e) {
                e.printStackTrace();
                System.err.println("close failed: " + e);
            }
        }
    }
}

