/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.businessdocument;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeImpl;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.businessdocument.SingleBusinessDocument;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import org.jdom.Attribute;
import org.jdom.Element;

public class AttributeNode
extends BusinessNodeImpl {
    private Attribute attribute;
    private String name;

    public AttributeNode(Element type, Attribute attribute, SingleBusinessDocument doc) {
        super(type, doc);
        if (type != null && !type.getName().equals("attribute")) {
            throw new PreconditionViolation("type: attribute definition expected:" + type);
        }
        if (attribute == null) {
            throw new PreconditionViolation("JDOM attribute missing");
        }
        this.name = attribute.getName();
        if (this.name == null) {
            throw new PreconditionViolation("attribute definition without name: " + type);
        }
        if (type != null && !attribute.getName().equals(type.getAttributeValue("name"))) {
            throw new PreconditionViolation("attribute name '" + attribute.getName() + "' and name '" + type.getAttributeValue("name") + "' within attribute type definition are not equal");
        }
        this.attribute = attribute;
    }

    public String getName() {
        return this.name;
    }

    public String toXML() {
        return Util.escapeXmlContent(this.getValue());
    }

    public boolean isContentNode() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return true;
    }

    public String getValue() throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.getDocument().isReadAble()) {
            throw new BusinessDocumentStateException("read access not allowed for attribute the document");
        }
        return this.attribute.getValue();
    }

    public void setValue(String value) throws BusinessDocumentStateException {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        if (!this.getDocument().isWriteAble()) {
            throw new BusinessDocumentStateException("attribute write-access only allowed for created or modifiable documents");
        }
        if (value == null) {
            throw new PreconditionViolation("parameter 'value' must not be null");
        }
        this.attribute.setValue(value);
    }

    public boolean isRemoveable() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        Element type = this.getType();
        return this.document.isWriteAble() && (type == null || Schema.isOptional(type));
    }

    public BusinessNode removeThis() {
        if (!this.isRemoveable()) {
            throw new PreconditionViolation("the attribute node '" + this.getPath() + "' is not removeable");
        }
        throw new UnsupportedOperationException("TODO: implement removing optional attributes");
    }

    public String getPath() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.getParent().getPath() + "/@" + this.getName();
    }

    protected String getContent() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.name;
    }

    protected BusinessNodeImpl getParentImpl() {
        if (!this.isActive()) {
            throw new PreconditionViolation("the node of class " + this.getClass().getName() + " was deleted");
        }
        return this.document.getElementNode(this.attribute.getParent());
    }
}

