/*
 * The original code created by Software AG
 * is part of Software AG Tamino X-Application and
 * Copyright (c) 2001 - 2002 Software AG, All Rights Reserved.
 *
 * Software AG highly appreciate the efforts and contributions of
 * the Source Partners. For more information, please see
 * http://www.softwareag.com/developer/x-application/guide.htm
 *
 * You can redistribute this software and/or modify it under the terms of
 * the Software AG Source Add-On Software License
 * http://www.softwareag.com/developer/x-application/license.htm
 */


package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.common.Util;

import com.softwareag.xtools.xapplication.businessdocument.QueryContainer;
import com.softwareag.xtools.xapplication.businessdocument.QueryFilter;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentCursor;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.JspTag;
import com.softwareag.xtools.xapplication.jsp.util.ElementBuffer;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;
import javax.servlet.jsp.tagext.BodyContent;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 ** Implements the functionality to select values from field of an XML document
 ** to display them within a select box.
 **
 ** @author <a href="http://www.softwareag.com/developer/x-application/default.htm">Software AG Tamino X-Application Developers</a>
 ** @version $Revision: 1.6 $
 **/
public class SelectTag extends JspTag {
    private String moduleId = null;
    private String schema = null;
    private String filter = null;
    private String value = null;
    private String text = null;
    private String distinct = null;
    
    private Collection textResultSet = null;
    private Collection valueResultSet = null;
    
  
    /**
     ** sets the value property
     **
     ** @param value String xpath for value property
     **/
    public void setValue(String value) {
        this.value=value;
    }
    
    /**
     ** sets the text property
     **
     ** @param value String xpath for text property
     **/
    public void setText(String text) {
        this.text=text;
    }
    
    /**
     ** set the distinct property
     **
     ** @param value String value for distinct property
     **/
    public void setDistinct(String distinct) {
        this.distinct=distinct;
    }
    
    /**
     ** Standard method of JSP tags that is called when the start tag is processed.
     **
     ** @return return-code according to JSP spec
     **/
    public int doStartTagCore() {
        return EVAL_BODY_TAG;
    }
    
    /**
     ** Standard method of JSP tags that is called after the body is completly read.
     **
     ** @return int return-code according to JSP spec
     **
     ** @throws ExceptionContainer standard exception
     ** @throws IOException to indicate IO problem
     **/
    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        processField();
        return SKIP_BODY;
    }
    
    /**
     ** Populates the selection box.
     **
     ** @throws ExceptionContainer standard exception
     ** @throws IOException to indicate an IO problem
     **/
    public void processField() throws ExceptionContainer, IOException {
        
        long ts = System.currentTimeMillis();
        
        textResultSet = requestValues(text);
        if (value != null && value.length() != 0 ) {
            // Test if both queries are from the same doctype, if not throw exception
            // else continue
            if (compareDoctypes(text, value) == false) {
                throw new ExceptionContainer("229");
            }
            valueResultSet = requestValues(value);
        }
        else { //value is equal to text
            valueResultSet = textResultSet;
        }
        
        if (distinct != null && distinct.equalsIgnoreCase("true")) {
            makeDistinct();
        }
        
        ts = System.currentTimeMillis() - ts;
        
        BodyContent body = getBodyContent();
        String bodyContentStr = body.getString();
        HtmlElement htmlElement = (bodyContentStr.length() == 0) ?
            sessionContext.initHtmlElement("<select></select>") :
            sessionContext.initHtmlElement(bodyContentStr);
        
        ts = System.currentTimeMillis();
        
        
        Iterator it = textResultSet.iterator();
        while (it.hasNext()) {
            ElementBuffer ebt = (ElementBuffer)it.next();
            boolean stopWhile = false;
            Iterator itv = valueResultSet.iterator();
            while (itv.hasNext() && !stopWhile) {
                ElementBuffer ebv = (ElementBuffer)itv.next();
                if (ebt.getId().equals(ebv.getId())) {
                    htmlElement.addOption(ebv.getValue(), ebt.getValue());
                    stopWhile = true;
                }
            }
        }
        
        
        htmlElement.writeOut(getBodyContent().getEnclosingWriter());
        getBodyContent().clearBody();
        ts = System.currentTimeMillis() - ts;
    }

    /**
     ** fills a collection with the requested values defined by a query
     **
     ** @param accessString, the query string
     **
     ** @return Collection containing the result
     **/
    private Collection requestValues(String accessString) throws ExceptionContainer {
        
        int occBlank = -1;
        int occTab = -1;
        Collection resultSet = new ArrayList();
        
        ElementIterator it = null;
        String string;
        String filterString;
        try {
            
            // The folling filterString is used in order to isolate the attribute- or element name
            // for the direct access on the DOM-Object
            if (accessString.indexOf("[") > -1) {
                filterString = new String(accessString.substring(0,accessString.indexOf("[")));
            }
            else {
                filterString = new String(accessString);
            }
            if (filterString.toLowerCase().indexOf("sort") > -1 ||
                filterString.toLowerCase().indexOf(" ") >-1 ||
                filterString.toLowerCase().indexOf("\t") > -1)
            {
                int cut=-1;
                occBlank = filterString.indexOf(" ");
                occTab = filterString.indexOf("\t");
                if (occBlank >= 0 && occTab < 0) {
                    cut = occBlank;
                }
                else if (occBlank < 0 && occTab >= 0) {
                    cut = occTab;
                }
                else if (occBlank >=0 && occTab >= 0 ) {
                    cut = Math.min(occBlank, occTab);
                }
                filterString = filterString.substring(0,cut);
            }
            if (filterString.indexOf("@") > -1) {
                filterString = filterString.substring(filterString.indexOf("@") + 1);
            }
            else {
                filterString = "";
            }
            
            it = sessionContext.getWorkspace().getStore().query(accessString);
            while(it.hasNext()) {
                Element e = (Element)it.next();
                if (filterString.length() == 0) {
                    string = e.getText();
                }
                else {
                    string = e.getAttributeValue(filterString);
                }
                resultSet.add(new ElementBuffer(e.getAttributeValue("id",TaminoStore.INO_NS),string));
            }
            return resultSet;
        }
        catch (StoreException e) {
            throw new ExceptionContainer("008", e);
        }
        finally {
            if (it != null) {
                try {
                    it.close();
                }
                catch (StoreException e) {
                    e.printStackTrace();
                    throw new ExceptionContainer("008", e);
                }
            }
        }
    }

    /**
     ** if the destinct value is set to 'true' this method will reduse the full result set to
     ** a destinct set
     **
     **/
    private void makeDistinct() {
        int i = 0;
        int j = 0;
        int size = 0;
        if (valueResultSet == textResultSet) { //trivial Case
            size = textResultSet.size();
            while (i < size-1) {
                j = i + 1;
                while (j < size) {
                    if (((ElementBuffer)((ArrayList)textResultSet).get(j)).getValue().equals(
                        ((ElementBuffer)((ArrayList)textResultSet).get(i)).getValue()))
                    {
                        ((ArrayList)textResultSet).remove(j);
                        size--;
                    }
                    else
                    {
                        j++;
                    }
                }
                i++;
            }
            valueResultSet = textResultSet;
        }
        else { // compare to different sets
            size = textResultSet.size();
            while (i < size-1) {
                j = i + 1;
                while (j < size) {
                    if (((ElementBuffer)((ArrayList)textResultSet).get(j)).getValue().equals(
                        ((ElementBuffer)((ArrayList)textResultSet).get(i)).getValue()))
                    {
                        if (compareValues(((ElementBuffer)((ArrayList)textResultSet).get(i)).getId(),
                        ((ElementBuffer)((ArrayList)textResultSet).get(j)).getId()) == true)
                        {
                            removeEntryFromValueSet(((ElementBuffer)((ArrayList)textResultSet).get(j)).getId());
                            ((ArrayList)textResultSet).remove(j);
                            size--;
                        }
                        else
                        {
                            j++;
                        }
                    }
                    else
                    {
                        j++;
                    }
                }
                i++;
            }
        }
    }
    
    /**
     ** compares two values of both sets
     **
     ** @param firstIno, ino:id of the element out of the first set
     ** @param secondIno, ino:id of the element out of the second set
     **
     ** @return result of the comparision
     **/
    private boolean compareValues(String firstIno, String secondIno) {
        Iterator itv = valueResultSet.iterator();
        String bufferFirstInoResult = null;
        String bufferSecondInoResult = null;
        try {
        while (itv.hasNext()) {
            ElementBuffer ebv = (ElementBuffer)itv.next();
            if (ebv.getId().equals(firstIno)) {
                bufferFirstInoResult = ebv.getValue();
            }
            if (ebv.getId().equals(secondIno)) {
                bufferSecondInoResult = ebv.getValue();
            }
        }
        if (bufferFirstInoResult.equals(bufferSecondInoResult)) {
            return true;
        }
        else {
            return false;
        }
        }
        catch(NullPointerException npe) {
            return false;
        }
    }

    /**
     ** removes an element from the ValueSet
     **
     ** @param removeItem, ino:id of the element which is to delete
     **
     **/
    private void removeEntryFromValueSet(String removeItem) {
        Iterator itv = valueResultSet.iterator();
        while (itv.hasNext()) {
            ElementBuffer ebv = (ElementBuffer)itv.next();
            if (ebv.getId().equals(removeItem)) {
                itv.remove();
            }
        }
    }
    
    /**
     ** removes an element from the ValueSet
     **
     ** @param queryString1, first query
     ** @param queryString2, second query
     **
     ** @return result of the comparision
     **/
    private boolean compareDoctypes(String queryString1,String queryString2) {
        
        if (queryString1.startsWith("//") || queryString2.startsWith("//")) {
            return false;
        }
        String queryStringBuffer1 = queryString1.substring(queryString1.indexOf("/")+1);
        String queryStringBuffer2 = queryString2.substring(queryString2.indexOf("/")+1);
        
        if (queryStringBuffer1.indexOf("/") >=0 ) {
            queryStringBuffer1 = queryStringBuffer1.substring(0,queryStringBuffer1.indexOf("/"));
        }
        
        if (queryStringBuffer2.startsWith(queryStringBuffer1)) {
            return true;
        }
        else {
            return false;
        }
    }
    
    /**
     ** Start the dump of the collected information at the doEnd of a tag and step one level back in hierarchy.
     **
     ** @throws ExceptionContainer standard exception
     **/
    protected void endDumpDiagnosis() throws ExceptionContainer {
        
        traceInfo.addAttribute("module", moduleId);
        traceInfo.addAttribute("schema", schema);
        traceInfo.addAttribute("filter", filter);
        traceInfo.addAttribute("value", value);
        traceInfo.addAttribute("text", text);
        traceInfo.addAttribute("distinct", distinct);
        
        //process standard functionality
        super.endDumpDiagnosis();
    }
    
    
    
}


